/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.handlers.guild;

import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.argonauts.Argonauts;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.compat.cadmus.CadmusIntegration;
import earth.terrarium.argonauts.common.compat.heracles.HeraclesIntegration;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import earth.terrarium.argonauts.common.handlers.guild.settings.GuildSettings;
import earth.terrarium.argonauts.common.network.messages.ClientboundSyncGuildsPacket;
import earth.terrarium.argonauts.common.utils.EventUtils;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.Nullable;

public class GuildHandler
extends SaveHandler
implements GuildApi {
    private final Map<UUID, Guild> guilds = new HashMap<UUID, Guild>();
    private final Map<UUID, UUID> playerGuilds = new HashMap<UUID, UUID>();

    public void loadData(CompoundTag tag) {
        for (String key : tag.m_128431_()) {
            MutableComponent name;
            UUID id = UUID.fromString(key);
            CompoundTag guildTag = tag.m_128469_(key);
            CompoundTag settingsTag = guildTag.m_128469_("settings");
            CompoundTag membersTag = guildTag.m_128469_("members");
            CompoundTag alliesTag = guildTag.m_128469_("allies");
            ListTag fakePlayersTag = guildTag.m_128437_("fakePlayers", 8);
            GuildSettings settings = new GuildSettings();
            if (!settingsTag.m_128469_("hq").m_128456_()) {
                settings.setHq(ModUtils.readGlobalPos(settingsTag.m_128469_("hq")));
            }
            settings.setDisplayName((Component)((name = Component.Serializer.m_130701_((String)settingsTag.m_128461_("name"))) == null ? CommonComponents.f_237098_ : name));
            MutableComponent motd = Component.Serializer.m_130701_((String)settingsTag.m_128461_("motd"));
            settings.setMotd((Component)(motd == null ? CommonComponents.f_237098_ : motd));
            settings.setColor(ChatFormatting.m_126647_((int)settingsTag.m_128445_("color")));
            settings.setAllowFakePlayers(settingsTag.m_128471_("allowFakePlayers"));
            GuildMembers members = new GuildMembers(ModUtils.readBasicProfile(guildTag.m_128469_("owner")));
            membersTag.m_128431_().forEach(memberTag -> members.add(ModUtils.readBasicProfile(membersTag.m_128469_(memberTag))));
            alliesTag.m_128431_().forEach(allyTag -> members.ally(ModUtils.readBasicProfile(alliesTag.m_128469_(allyTag))));
            for (Tag tag1 : fakePlayersTag) {
                String uuidText = tag1.m_7916_();
                UUID uuid = ModUtils.parseUuidOrNull(uuidText);
                if (uuid != null) {
                    members.fakePlayers().add(uuid);
                    continue;
                }
                Constants.LOGGER.warn("Failed to parse fake player uuid of {} in guild {}", (Object)uuidText, (Object)id);
            }
            Guild guild = new Guild(id, settings, members);
            this.guilds.put(id, guild);
            this.updateInternal();
        }
    }

    public void saveData(CompoundTag tag) {
        this.guilds.forEach((uuid, guild) -> {
            CompoundTag guildTag = new CompoundTag();
            CompoundTag settingsTag = new CompoundTag();
            CompoundTag membersTag = new CompoundTag();
            CompoundTag alliesTag = new CompoundTag();
            ListTag fakePlayersTag = new ListTag();
            settingsTag.m_128365_("hq", (Tag)(guild.settings().hq().isPresent() ? ModUtils.writeGlobalPos(guild.settings().hq().get()) : new CompoundTag()));
            settingsTag.m_128359_("name", Component.Serializer.m_130703_((Component)guild.settings().displayName()));
            settingsTag.m_128359_("motd", Component.Serializer.m_130703_((Component)guild.settings().motd()));
            settingsTag.m_128344_("color", (byte)guild.settings().color().m_126656_());
            settingsTag.m_128379_("allowFakePlayers", guild.settings().allowFakePlayers());
            guildTag.m_128365_("settings", (Tag)settingsTag);
            guildTag.m_128365_("owner", (Tag)ModUtils.writeBasicProfile(((GuildMember)((GuildMembers)guild.members()).getLeader()).profile()));
            ((GuildMembers)guild.members()).forEach(member -> membersTag.m_128365_(member.profile().getId().toString(), (Tag)ModUtils.writeBasicProfile(member.profile())));
            ((GuildMembers)guild.members()).allies().forEach(member -> alliesTag.m_128365_(member.profile().getId().toString(), (Tag)ModUtils.writeBasicProfile(member.profile())));
            ((GuildMembers)guild.members()).fakePlayers().forEach(fakePlayer -> fakePlayersTag.add((Object)StringTag.m_129297_((String)fakePlayer.toString())));
            guildTag.m_128365_("members", (Tag)membersTag);
            guildTag.m_128365_("allies", (Tag)alliesTag);
            guildTag.m_128365_("fakePlayers", (Tag)fakePlayersTag);
            tag.m_128365_(uuid.toString(), (Tag)guildTag);
        });
    }

    public static GuildHandler read(MinecraftServer server) {
        return (GuildHandler)GuildHandler.read((DimensionDataStorage)server.m_129783_().m_8895_(), GuildHandler::new, (String)"argonauts_guilds");
    }

    @Override
    public void createGuild(ServerPlayer player, Component displayName) throws MemberException {
        GuildHandler data = GuildHandler.read(player.f_8924_);
        if (data.playerGuilds.containsKey(player.m_20148_())) {
            throw MemberException.ALREADY_IN_GUILD;
        }
        UUID id = (UUID)CommonUtils.generate(Predicate.not(data.guilds::containsKey), UUID::randomUUID);
        Guild guild = new Guild(id, (Player)player);
        guild.settings().setDisplayName(displayName);
        data.guilds.put(id, guild);
        data.playerGuilds.put(player.m_20148_(), id);
        ModUtils.sendToAllClientPlayers(new ClientboundSyncGuildsPacket(Set.of(guild), Set.of()), player.f_8924_);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_create", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
        EventUtils.created(guild, player);
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.addToCadmusTeam(player, id.toString());
        }
        if (Argonauts.isHeraclesLoaded()) {
            HeraclesIntegration.updateHeraclesChanger(player);
        }
    }

    @Override
    @Nullable
    public Guild get(MinecraftServer server, UUID id) {
        return GuildHandler.read((MinecraftServer)server).guilds.get(id);
    }

    @Override
    @Nullable
    public Guild get(ServerPlayer player) {
        return this.getPlayerGuild(player.f_8924_, player.m_20148_());
    }

    @Override
    @Nullable
    public Guild getPlayerGuild(MinecraftServer server, UUID player) {
        GuildHandler data = GuildHandler.read(server);
        return data.guilds.get(data.playerGuilds.get(player));
    }

    @Override
    public Collection<Guild> getAll(MinecraftServer server) {
        return GuildHandler.read((MinecraftServer)server).guilds.values();
    }

    @Override
    public void tryJoin(Guild guild, ServerPlayer player) throws MemberException {
        if (!guild.isPublic() && !((GuildMembers)guild.members()).isInvited(player.m_20148_())) {
            throw MemberException.NOT_ALLOWED_TO_JOIN_GUILD;
        }
        this.join(guild, player);
    }

    @Override
    public void join(Guild guild, ServerPlayer player) throws MemberException {
        GuildHandler data = GuildHandler.read(player.f_8924_);
        if (data.playerGuilds.containsKey(player.m_20148_())) {
            throw MemberException.ALREADY_IN_GUILD;
        }
        for (Member member : (GuildMembers)guild.members()) {
            ServerPlayer serverPlayer = player.f_8924_.m_6846_().m_11259_(member.profile().getId());
            if (serverPlayer == null) continue;
            serverPlayer.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_perspective_join", (Object[])new Object[]{player.m_7755_().getString(), guild.settings().displayName().getString()}), false);
        }
        ((GuildMembers)guild.members()).add(player.m_36316_());
        data.playerGuilds.put(player.m_20148_(), guild.id());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncGuildsPacket(Set.of(guild), Set.of()), player.f_8924_);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_join", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
        EventUtils.joined(guild, player);
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.addToCadmusTeam(player, guild.id().toString());
        }
        if (Argonauts.isHeraclesLoaded()) {
            HeraclesIntegration.updateHeraclesChanger(player);
        }
    }

    @Override
    public void leave(UUID id, ServerPlayer player) throws MemberException {
        GuildHandler data = GuildHandler.read(player.f_8924_);
        Guild guild = this.get(player.f_8924_, id);
        if (guild == null) {
            throw MemberException.GUILD_DOES_NOT_EXIST;
        }
        if (data.playerGuilds.get(player.m_20148_()) != id) {
            throw MemberException.PLAYER_IS_NOT_IN_GUILD;
        }
        if (((GuildMembers)guild.members()).isLeader(player.m_20148_())) {
            throw MemberException.YOU_CANT_REMOVE_GUILD_OWNER;
        }
        ((GuildMembers)guild.members()).remove(player.m_20148_());
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_leave", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
        for (Member member : (GuildMembers)guild.members()) {
            ServerPlayer serverPlayer = player.f_8924_.m_6846_().m_11259_(member.profile().getId());
            if (serverPlayer == null) continue;
            serverPlayer.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_perspective_leave", (Object[])new Object[]{player.m_7755_().getString(), guild.settings().displayName().getString()}), false);
        }
        data.playerGuilds.remove(player.m_20148_());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncGuildsPacket(Set.of(guild), Set.of()), player.f_8924_);
        EventUtils.left(guild, player);
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.removeFromCadmusTeam(player, id.toString());
        }
        if (Argonauts.isHeraclesLoaded()) {
            HeraclesIntegration.updateHeraclesChanger(player);
        }
    }

    @Override
    public void disband(Guild guild, MinecraftServer server) {
        ServerPlayer player = server.m_6846_().m_11259_(((GuildMember)((GuildMembers)guild.members()).getLeader()).profile().getId());
        if (player == null) {
            return;
        }
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_disband", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
        EventUtils.disbanned(guild);
        this.remove(false, guild, server);
    }

    @Override
    public void remove(boolean force, Guild guild, MinecraftServer server) {
        GuildHandler data = GuildHandler.read(server);
        data.guilds.remove(guild.id());
        ModUtils.sendToAllClientPlayers(new ClientboundSyncGuildsPacket(Set.of(), Set.of(guild.id())), server);
        EventUtils.removed(force, guild);
        if (Argonauts.isCadmusLoaded()) {
            CadmusIntegration.disbandCadmusTeam(guild, server);
        }
        if (Argonauts.isHeraclesLoaded()) {
            ((GuildMembers)guild.members()).forEach(m -> HeraclesIntegration.updateHeraclesChanger(server.m_129783_(), m.profile().getId()));
        }
        data.updateInternal();
    }

    private void updateInternal() {
        this.playerGuilds.clear();
        this.guilds.values().forEach(team -> ((GuildMembers)team.members()).forEach(member -> this.playerGuilds.put(member.profile().getId(), team.id())));
    }

    public boolean m_77764_() {
        return true;
    }
}

