/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.party;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.BaseCommands;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.commands.party.PartyCommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class PartyCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"party").then(PartyCommands.join())).then(PartyCommands.ignore())).then(PartyCommands.unignore())).then(PartyCommands.leave()));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> leave() {
        return BaseCommands.leave(PartyCommandHelper::getPartyOrThrow, PartyApi.API::leave);
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> join() {
        return BaseCommands.join(PartyCommandHelper::getPartyOrThrow, (group, player) -> PartyApi.API.join((Party)group, player));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> ignore() {
        return PartyCommands.ignoreHelper("ignore");
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> unignore() {
        return PartyCommands.ignoreHelper("unignore");
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> ignoreHelper(String subCommand) {
        return Commands.m_82127_((String)subCommand).then(Commands.m_82129_((String)"members", (ArgumentType)GameProfileArgument.m_94584_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Collection profiles = GameProfileArgument.m_94590_((CommandContext)context, (String)"members");
            Party party = PartyCommandHelper.getPartyOrThrow((Player)player, false);
            CommandHelper.runAction(() -> PartyCommands.lambda$ignoreHelper$1(party, (Player)player, subCommand, profiles));
            return 1;
        }));
    }

    private static /* synthetic */ void lambda$ignoreHelper$1(Party party, Player player, String subCommand, Collection profiles) throws MemberException {
        PartyMember member = (PartyMember)party.getMember(player);
        if (member.hasPermission("manage.members")) {
        } else {
            throw MemberException.YOU_CANT_MANAGE_MEMBERS_IN_PARTY;
        }
        Consumer<GameProfile> action = subCommand.equals("ignore") ? party.ignored()::add : party.ignored()::remove;
        profiles.forEach(action);
    }
}

