/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.server.level.ServerPlayer;

public class GuildAdminCommands {
    private static final SuggestionProvider<CommandSourceStack> GUILDS_SUGGESTION_PROVIDER = (context, builder) -> {
        Collection<Guild> guilds = GuildApi.API.getAll(((CommandSourceStack)context.getSource()).m_81377_());
        return SharedSuggestionProvider.m_82981_(guilds.stream().map(g -> g.id().toString()), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"guild").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"disband").then(Commands.m_82129_((String)"guild", (ArgumentType)UuidArgument.m_113850_()).suggests(GUILDS_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Guild guild = GuildApi.API.get(player.f_8924_, UuidArgument.m_113853_((CommandContext)context, (String)"guild"));
            GuildAdminCommands.removeGuild(guild, player);
            return 1;
        })))).then(Commands.m_82127_((String)"disbandall").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            new ArrayList<Guild>(GuildApi.API.getAll(player.f_8924_)).forEach(guild -> GuildAdminCommands.removeGuild(guild, player));
            return 1;
        }))).then(Commands.m_82127_((String)"join").then(Commands.m_82129_((String)"guild", (ArgumentType)UuidArgument.m_113850_()).suggests(GUILDS_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            Guild guild = GuildApi.API.get(player.f_8924_, UuidArgument.m_113853_((CommandContext)context, (String)"guild"));
            GuildAdminCommands.joinGuild(guild, player);
            return 1;
        })))));
    }

    public static void removeGuild(Guild guild, ServerPlayer player) {
        CommandHelper.runAction(() -> {
            if (guild == null) {
                throw MemberException.GUILD_DOES_NOT_EXIST;
            }
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.guild_disband", (Object[])new Object[]{guild.settings().displayName().getString()}), false);
            ((GuildMembers)guild.members()).forEach(p -> {
                ServerPlayer groupMember = player.f_8924_.m_6846_().m_11259_(p.profile().getId());
                if (groupMember != null) {
                    groupMember.m_5661_(CommonUtils.serverTranslatable((String)"text.argonauts.member.disband", (Object[])new Object[]{guild.displayName()}), false);
                }
            });
            GuildApi.API.remove(true, guild, player.f_8924_);
        });
    }

    public static void joinGuild(Guild guild, ServerPlayer player) {
        CommandHelper.runAction(() -> {
            if (guild == null) {
                throw MemberException.GUILD_DOES_NOT_EXIST;
            }
            GuildApi.API.join(guild, player);
        });
    }
}

