/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.rendering;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.common.utils.WebUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlTexture
extends SimpleTexture {
    private static final Map<String, Info> INFO = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static final Info DEFAULT_INFO = new Info(24, 24, 24, 24);
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("argonauts", "textures/gui/hourglass.png");
    private final String url;
    private boolean loaded;
    private CompletableFuture<?> loader;

    public UrlTexture(String url) {
        super(DEFAULT_TEXTURE);
        this.url = url;
    }

    public static ResourceLocation getTextureId(String url) {
        return new ResourceLocation("argonauts", "urlimages/" + Hashing.sha1().hashUnencodedChars((CharSequence)url));
    }

    public static Info getInfo(String url) {
        return INFO.getOrDefault(url, DEFAULT_INFO);
    }

    private void upload(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85040_(0, 0, 0, true);
        INFO.put(this.url, Info.from(image));
    }

    public void m_6704_(@NotNull ResourceManager manager) {
        Minecraft.m_91087_().execute(() -> {
            if (!this.loaded) {
                try {
                    super.m_6704_(manager);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.loaded = true;
            }
        });
        if (this.loader == null) {
            this.loader = CompletableFuture.runAsync(() -> WebUtils.get((String)this.url, HttpResponse.BodyHandlers.ofInputStream()).ifPresent(response -> {
                if (response.statusCode() / 100 == 2) {
                    NativeImage image = this.loadTexture((InputStream)response.body());
                    Minecraft.m_91087_().execute(() -> {
                        if (image != null) {
                            Minecraft.m_91087_().execute(() -> {
                                this.loaded = true;
                                if (!RenderSystem.isOnRenderThread()) {
                                    RenderSystem.recordRenderCall(() -> this.upload(image));
                                } else {
                                    this.upload(image);
                                }
                            });
                        }
                    });
                }
            }), Util.m_183991_());
        }
    }

    @Nullable
    private NativeImage loadTexture(InputStream stream) {
        NativeImage nativeImage = null;
        try {
            nativeImage = NativeImage.m_85058_((InputStream)stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nativeImage;
    }

    public record Info(int width, int height, int displayWidth, int displayHeight) {
        public static Info from(NativeImage image) {
            double widthMultiple = Math.ceil((double)image.m_84982_() / 150.0);
            double heightMultiple = Math.ceil((double)image.m_85084_() / 100.0);
            int ratio = (int)Math.max(widthMultiple, heightMultiple);
            return new Info(image.m_84982_(), image.m_85084_(), image.m_84982_() / ratio, image.m_85084_() / ratio);
        }
    }
}

