/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EmiBannerDuplicateRecipe
extends EmiPatternCraftingRecipe {
    public static final List<Item> BANNERS = List.of(Items.f_42660_, Items.f_42661_, Items.f_42662_, Items.f_42663_, Items.f_42664_, Items.f_42665_, Items.f_42666_, Items.f_42667_, Items.f_42668_, Items.f_42669_, Items.f_42670_, Items.f_42671_, Items.f_42672_, Items.f_42673_, Items.f_42727_, Items.f_42728_);
    private final Item banner;

    public EmiBannerDuplicateRecipe(Item banner, ResourceLocation id) {
        super(List.of(EmiStack.of((ItemLike)banner), EmiStack.of((ItemLike)banner).setRemainder(EmiStack.of((ItemLike)banner))), EmiStack.of((ItemLike)banner), id);
        this.banner = banner;
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of((ItemLike)this.banner), x, y);
        }
        if (slot == 1) {
            return new GeneratedSlotWidget(r -> this.getPattern((Random)r, true), this.unique, x, y);
        }
        return new SlotWidget(EmiStack.EMPTY, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> this.getPattern((Random)r, false), this.unique, x, y);
    }

    public EmiStack getPattern(Random random, boolean reminder) {
        ItemStack stack = new ItemStack((ItemLike)this.banner);
        int patterns = 1 + Math.max(random.nextInt(5), random.nextInt(3));
        BannerPattern.Builder pattern = new BannerPattern.Builder();
        for (int i = 0; i < patterns; ++i) {
            pattern = EmiPort.addRandomBanner(pattern, random);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Patterns", (Tag)pattern.m_58587_());
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)tag);
        EmiStack emiStack = EmiStack.of(stack);
        if (reminder) {
            emiStack.setRemainder(EmiStack.of(stack));
        }
        return emiStack;
    }
}

