/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.StackBatcher;
import dev.emi.emi.screen.tooltip.EmiTextTooltipWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ItemEmiStack
extends EmiStack
implements StackBatcher.Batchable {
    private static final Minecraft client = Minecraft.m_91087_();
    private final Item item;
    private final CompoundTag nbt;
    private boolean unbatchable;

    public ItemEmiStack(ItemStack stack) {
        this(stack, stack.m_41613_());
    }

    public ItemEmiStack(ItemStack stack, long amount) {
        this(stack.m_41720_(), stack.m_41783_(), amount);
    }

    public ItemEmiStack(Item item, CompoundTag nbt, long amount) {
        this.item = item;
        this.nbt = nbt != null ? nbt.m_6426_() : null;
        this.amount = amount;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((ItemLike)this.item, (int)this.amount);
        if (this.nbt != null) {
            stack.m_41751_(this.nbt);
        }
        return stack;
    }

    @Override
    public EmiStack copy() {
        ItemEmiStack e = new ItemEmiStack(this.item, this.nbt, this.amount);
        e.setChance(this.chance);
        e.setRemainder(this.getRemainder().copy());
        e.comparison = this.comparison;
        return e;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0L || this.item == Items.f_41852_;
    }

    @Override
    public CompoundTag getNbt() {
        return this.nbt;
    }

    @Override
    public Object getKey() {
        return this.item;
    }

    @Override
    public ResourceLocation getId() {
        return EmiPort.getItemRegistry().m_7981_((Object)this.item);
    }

    @Override
    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        ItemStack stack = this.getItemStack();
        if ((flags & 1) != 0) {
            Lighting.m_84931_();
            draw.m_280203_(stack, x, y);
            draw.m_280302_(ItemEmiStack.client.f_91062_, stack, x, y, "");
        }
        if ((flags & 2) != 0) {
            Object count = "";
            if (this.amount != 1L) {
                count = (String)count + this.amount;
            }
            EmiRenderHelper.renderAmount(context, x, y, (Component)EmiPort.literal((String)count));
        }
        if ((flags & 8) != 0) {
            EmiRender.renderRemainderIcon(this, context.raw(), x, y);
        }
    }

    @Override
    public boolean isSideLit() {
        return client.m_91291_().m_174264_(this.getItemStack(), null, null, 0).m_7547_();
    }

    @Override
    public boolean isUnbatchable() {
        ItemStack stack = this.getItemStack();
        return this.unbatchable || stack.m_41790_() || stack.m_41768_() || !EmiAgnos.canBatch(stack) || client.m_91291_().m_174264_(this.getItemStack(), null, null, 0).m_7521_();
    }

    @Override
    public void setUnbatchable() {
        this.unbatchable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderForBatch(MultiBufferSource vcp, GuiGraphics draw, int x, int y, int z, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(draw);
        ItemStack stack = this.getItemStack();
        ItemRenderer ir = client.m_91291_();
        BakedModel model = ir.m_174264_(stack, null, null, 0);
        context.push();
        try {
            context.matrices().m_252880_((float)x, (float)y, 100.0f + (float)z + (float)(model.m_7539_() ? 50 : 0));
            context.matrices().m_85837_(8.0, 8.0, 0.0);
            context.matrices().m_85841_(16.0f, 16.0f, 16.0f);
            ir.m_115143_(stack, ItemDisplayContext.GUI, false, context.matrices(), vcp, 0xF000F0, OverlayTexture.f_118083_, model);
        }
        finally {
            context.pop();
        }
    }

    @Override
    public List<Component> getTooltipText() {
        return this.getItemStack().m_41651_((Player)ItemEmiStack.client.f_91074_, (TooltipFlag)TooltipFlag.f_256752_);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        ItemStack stack = this.getItemStack();
        ArrayList list = Lists.newArrayList();
        if (!this.isEmpty()) {
            Object e;
            list.addAll(EmiAgnos.getItemTooltip(stack));
            if (!list.isEmpty() && (e = list.get(0)) instanceof ClientTextTooltip) {
                ClientTextTooltip ottc = (ClientTextTooltip)e;
                list.set(0, new EmiTextTooltipWrapper((EmiIngredient)this, ottc));
            }
            list.addAll(super.getTooltip());
        }
        return list;
    }

    @Override
    public Component getName() {
        if (this.isEmpty()) {
            return EmiPort.literal("");
        }
        return this.getItemStack().m_41786_();
    }

    static class ItemEntry {
        ItemEntry() {
        }
    }
}

