/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.effect.BlackoutEffect;
import net.satisfy.brewery.effect.DrunkEffect;
import net.satisfy.brewery.effect.HaleyEffect;
import net.satisfy.brewery.effect.HarddrinkingEffect;
import net.satisfy.brewery.effect.HealingTouchEffect;
import net.satisfy.brewery.effect.PartystarterEffect;
import net.satisfy.brewery.effect.PintCharismaEffect;
import net.satisfy.brewery.effect.ProtectiveTouchEffect;
import net.satisfy.brewery.effect.RenewingTouchEffect;
import net.satisfy.brewery.effect.SaturatedEffect;
import net.satisfy.brewery.effect.SnowWhiteEffect;
import net.satisfy.brewery.effect.ToxicTouchEffect;
import net.satisfy.brewery.util.BreweryIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> DRUNK = MobEffectRegistry.registerEffect("drunk", DrunkEffect::new);
    public static final RegistrySupplier<MobEffect> BLACKOUT;
    public static final RegistrySupplier<MobEffect> SATURATED;
    public static final RegistrySupplier<MobEffect> RENEWINGTOUCH;
    public static final RegistrySupplier<MobEffect> TOXICTOUCH;
    public static final RegistrySupplier<MobEffect> HEALINGTOUCH;
    public static final RegistrySupplier<MobEffect> PROTECTIVETOUCH;
    public static final RegistrySupplier<MobEffect> HARDDRINKING;
    public static final RegistrySupplier<MobEffect> PARTYSTARTER;
    public static final RegistrySupplier<MobEffect> SNOWWHITE;
    public static final RegistrySupplier<MobEffect> PINTCHARISMA;
    public static final RegistrySupplier<MobEffect> HALEY;

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new BreweryIdentifier(name), effect);
    }

    public static void init() {
        Brewery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        HARDDRINKING = MobEffectRegistry.registerEffect("harddrinking", HarddrinkingEffect::new);
        BLACKOUT = MobEffectRegistry.registerEffect("blackout", () -> new BlackoutEffect().m_216879_(() -> new MobEffectInstance.FactorData(22)));
        SATURATED = MobEffectRegistry.registerEffect("saturated", SaturatedEffect::new);
        TOXICTOUCH = MobEffectRegistry.registerEffect("toxictouch", () -> new ToxicTouchEffect(MobEffectCategory.BENEFICIAL, 9500817));
        RENEWINGTOUCH = MobEffectRegistry.registerEffect("renewingtouch", () -> new RenewingTouchEffect(MobEffectCategory.BENEFICIAL, 9500817));
        HEALINGTOUCH = MobEffectRegistry.registerEffect("healingtouch", () -> new HealingTouchEffect(MobEffectCategory.BENEFICIAL, 9500817));
        PROTECTIVETOUCH = MobEffectRegistry.registerEffect("protectivetouch", () -> new ProtectiveTouchEffect(MobEffectCategory.BENEFICIAL, 9500817));
        PARTYSTARTER = MobEffectRegistry.registerEffect("partystarter", () -> new PartystarterEffect(MobEffectCategory.BENEFICIAL, 9500817));
        SNOWWHITE = MobEffectRegistry.registerEffect("snowwhite", () -> new SnowWhiteEffect(MobEffectCategory.BENEFICIAL, 9500817));
        PINTCHARISMA = MobEffectRegistry.registerEffect("pintcharisma", () -> new PintCharismaEffect(MobEffectCategory.BENEFICIAL, 9500817));
        HALEY = MobEffectRegistry.registerEffect("haley", () -> new HaleyEffect(MobEffectCategory.BENEFICIAL, 9500817));
    }
}

