/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.flywheel_bearing.mechanics;

import com.kipti.bnb.content.flywheel_bearing.FlywheelBearingBlockEntity;
import com.kipti.bnb.registry.BnbConfigs;
import com.kipti.bnb.registry.BnbTags;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class FlywheelMovementMechanics {
    private static final double ANGULAR_MASS_EPSILON = 0.01;
    public static float STRESS_UNITS_PER_KE_JOULE = 8.0f;
    public static float TRANSFER_CAPACITY_PER_ANGULAR_MASS = 5.0f;
    public float maxAngularVelocity = 19.2f;
    public float angularVelocity = 0.0f;
    public float prevClientAngle = 0.0f;
    public float angle = 0.0f;
    public Float clientAngle = null;
    public float angularMass = 1.0f;
    public float lastStoredStressTicks = 0.0f;
    public float currentStoredStressTicks = 0.0f;
    public float kineticTransfer = 0.0f;

    public void writeAdditional(CompoundTag compound) {
        compound.m_128350_("AngularVelocity", this.angularVelocity);
        compound.m_128350_("Angle", this.angle);
        compound.m_128350_("AngularMass", this.angularMass);
    }

    public void readAdditional(CompoundTag compound, boolean clientPacket) {
        if (compound.m_128441_("AngularVelocity")) {
            this.angularVelocity = compound.m_128457_("AngularVelocity");
        }
        if (((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue() && this.angularVelocity < 0.0f) {
            this.angularVelocity = 0.0f;
        }
        this.angle = compound.m_128457_("Angle");
        this.angularMass = compound.m_128457_("AngularMass");
    }

    public void tickForStorageBehaviour(FlywheelBearingBlockEntity be) {
        float availableExcessKineticStrength;
        float displayAngle;
        Level level = be.m_58904_();
        this.prevClientAngle = displayAngle = level != null && level.f_46443_ && this.clientAngle != null ? this.clientAngle.floatValue() : this.angle;
        this.lastStoredStressTicks = this.getStoredStressTicks();
        boolean canReceiveStressBefore = this.canReceiveStress();
        boolean canProvideStressBefore = this.canProvideStress();
        float maxTransferCapacity = this.getMaxTransferCapacity();
        this.kineticTransfer = availableExcessKineticStrength = Math.min(Math.max(be.getFlywheelStressDelta(), -maxTransferCapacity), maxTransferCapacity);
        float kejEnergyChange = availableExcessKineticStrength / FlywheelMovementMechanics.getActualStressUnitsPerKeJoule();
        float currentKejEnergy = 0.5f * this.angularMass * this.angularVelocity * this.angularVelocity;
        float newKejEnergy = Math.max(currentKejEnergy + kejEnergyChange, 0.0f);
        float f = this.angularVelocity = (double)this.angularMass <= 0.01 ? 0.0f : (float)Math.sqrt(2.0f * newKejEnergy / this.angularMass);
        if (this.angularVelocity > this.maxAngularVelocity) {
            this.angularVelocity = this.maxAngularVelocity;
        }
        this.angle += this.angularVelocity;
        this.clientAngle = Float.valueOf(Mth.m_14179_((float)0.1f, (float)(displayAngle + this.angularVelocity), (float)this.angle));
        boolean canNowProvideStress = this.canProvideStress();
        if (canProvideStressBefore != canNowProvideStress) {
            be.updateGeneratedRotation();
            be.updateFlywheelStressesInNetwork();
            if (!canNowProvideStress) {
                this.angularVelocity = 0.0f;
            }
        }
        if (canReceiveStressBefore != this.canReceiveStress()) {
            be.updateFlywheelStressesInNetwork();
        }
        this.currentStoredStressTicks = this.getStoredStressTicks();
    }

    public void assemble(FlywheelBearingBlockEntity be, BearingContraption contraption) {
        this.angularMass = 0.0f;
        Vec3 axis = Vec3.m_82528_((Vec3i)contraption.getFacing().m_122436_());
        Vec3 anchor = Vec3.m_82512_((Vec3i)BlockPos.f_121853_);
        for (Map.Entry block : contraption.getBlocks().entrySet()) {
            float angularDistance = (float)((BlockPos)block.getKey()).m_252807_().m_82546_(anchor).m_82537_(axis).m_82553_() + 1.0f;
            float mass = this.getMassOfBlock(((StructureTemplate.StructureBlockInfo)block.getValue()).f_74676_());
            this.angularMass += mass * angularDistance * angularDistance;
        }
        be.updateFlywheelStressesInNetwork();
    }

    public void tick(FlywheelBearingBlockEntity be) {
        float displayAngle;
        Level level = be.m_58904_();
        this.prevClientAngle = displayAngle = level != null && level.f_46443_ && this.clientAngle != null ? this.clientAngle.floatValue() : this.angle;
        float targetAngularVelocity = be.getSpeed() * 360.0f / 1200.0f;
        float reactivity = (double)this.angularMass <= 0.01 ? 1.0f : Math.min(Math.max(1.0f / this.angularMass, 0.005f), 1.0f);
        this.angularVelocity = targetAngularVelocity * reactivity + this.angularVelocity * (1.0f - reactivity);
        this.angle += this.angularVelocity;
        this.clientAngle = Float.valueOf(Mth.m_14179_((float)0.1f, (float)(displayAngle + this.angularVelocity), (float)this.angle));
    }

    public boolean canReceiveStress() {
        return this.angularVelocity < this.maxAngularVelocity;
    }

    public float getStoredStressTicks() {
        float kejEnergy = 0.5f * this.angularMass * this.angularVelocity * this.angularVelocity;
        return kejEnergy * FlywheelMovementMechanics.getActualStressUnitsPerKeJoule();
    }

    public float getMaxStoredStressTicks() {
        float maxKejEnergy = 0.5f * this.angularMass * this.maxAngularVelocity * this.maxAngularVelocity;
        return maxKejEnergy * FlywheelMovementMechanics.getActualStressUnitsPerKeJoule();
    }

    public boolean canProvideStress() {
        return this.getStoredStressTicks() >= this.getMaxTransferCapacity();
    }

    public float getMaxTransferCapacity() {
        return Math.max(1.0f, this.angularMass * TRANSFER_CAPACITY_PER_ANGULAR_MASS);
    }

    public float getFlywheelStressCapacity() {
        return this.canReceiveStress() ? this.getMaxTransferCapacity() : 0.0f;
    }

    public float getMaxAngularVelocity() {
        return this.maxAngularVelocity;
    }

    private float getMassOfBlock(BlockState state) {
        Block block = state.m_60734_();
        if (BnbTags.BnbBlockTags.SUPER_HEAVY.matches(block)) {
            return 4.0f;
        }
        if (BnbTags.BnbBlockTags.HEAVY.matches(block)) {
            return 2.0f;
        }
        if (BnbTags.BnbBlockTags.LIGHT.matches(block)) {
            return 0.5f;
        }
        return 1.0f;
    }

    public static float getActualStressUnitsPerKeJoule() {
        return (float)((double)STRESS_UNITS_PER_KE_JOULE * (Double)BnbConfigs.server().FLYWHEEL_STORAGE_FACTOR.get());
    }

    public void zero() {
        this.angularVelocity = 0.0f;
        this.angle = 0.0f;
        this.clientAngle = Float.valueOf(0.0f);
        this.prevClientAngle = 0.0f;
        this.lastStoredStressTicks = 0.0f;
        this.currentStoredStressTicks = 0.0f;
        this.kineticTransfer = 0.0f;
    }

    public String formatAngularMass() {
        if ((double)this.angularMass <= 0.01) {
            return "0 cg\u00b7m\u00b2";
        }
        if (this.angularMass < 0.1f) {
            return "<0.1 cg\u00b7m\u00b2";
        }
        return String.format("%.1f cg\u00b7m\u00b2", Float.valueOf(this.angularMass));
    }

    public Component getAngularMassDescription() {
        if ((double)this.angularMass <= 0.01) {
            return Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass.none");
        }
        if (this.angularMass <= 1.0f) {
            return Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass.super_light");
        }
        if (this.angularMass <= 10.0f) {
            return Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass.light");
        }
        if (this.angularMass <= 100.0f) {
            return Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass.medium");
        }
        if (this.angularMass <= 1000.0f) {
            return Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass.heavy");
        }
        if (this.angularMass <= 10000.0f) {
            return Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass.super_heavy");
        }
        return Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass.absurdly_heavy");
    }
}

