/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.item;

import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChainPathfinder;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.item.CogwheelChainPlacementInteraction;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CogwheelChainPlacementEffect {
    private static final float PARTICLE_DENSITY = 0.1f;

    public static void tick(LocalPlayer player) {
        ItemStack heldItem;
        if (Minecraft.m_91087_().m_91104_() || Minecraft.m_91087_().f_91077_ == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || CogwheelChainPlacementInteraction.currentChainLevel == null || CogwheelChainPlacementInteraction.currentBuildingChain == null) {
            return;
        }
        if (!CogwheelChainPlacementInteraction.currentChainLevel.equals((Object)level.m_46472_()) || !CogwheelChainPlacementInteraction.currentBuildingChain.checkMatchingNodesInLevel((Level)level)) {
            CogwheelChainPlacementInteraction.currentBuildingChain = null;
            CogwheelChainPlacementInteraction.currentChainLevel = null;
            return;
        }
        Object object = CogwheelChainPlacementEffect.isChain(player.m_21205_()) ? player.m_21205_() : (heldItem = CogwheelChainPlacementEffect.isChain(player.m_21206_()) ? player.m_21206_() : null);
        if (heldItem != null) {
            BlockPos targetedPos = CogwheelChainPlacementEffect.getTargetedBlockAndDisplay();
            if (!player.m_7500_()) {
                double additionalDistance = targetedPos != null ? Vec3.m_82528_((Vec3i)targetedPos.m_121996_((Vec3i)CogwheelChainPlacementInteraction.currentBuildingChain.getLastNode().pos())).m_82553_() : 0.0;
                int chainsRequired = CogwheelChainPlacementInteraction.currentBuildingChain.getChainsRequired(additionalDistance);
                boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)Items.f_42026_.m_7968_(), (int)chainsRequired, (boolean)true);
                BlueprintOverlayRenderer.displayChainRequirements((Item)Items.f_42026_, (int)chainsRequired, (boolean)hasEnough);
            }
        }
    }

    private static boolean isChain(ItemStack offhandItem) {
        return offhandItem.m_150930_(Items.f_42026_);
    }

    @Nullable
    private static BlockPos getTargetedBlockAndDisplay() {
        if (CogwheelChainPlacementInteraction.currentBuildingChain == null) {
            return null;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        HitResult genericHit = Minecraft.m_91087_().f_91077_;
        if (!(genericHit instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult hit = (BlockHitResult)genericHit;
        PlacingCogwheelNode lastNode = CogwheelChainPlacementInteraction.currentBuildingChain.getLastNode();
        Vec3 lastNodePos = Vec3.m_82512_((Vec3i)lastNode.pos());
        Direction.Axis axis = lastNode.rotationAxis();
        Vec3 targetedOrigin = hit.m_82450_();
        Vec3 toTargeted = targetedOrigin.m_82546_(lastNodePos);
        Vec3 axisNormal = Vec3.m_82528_((Vec3i)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122436_());
        Vec3 projected = toTargeted.m_82546_(axisNormal.m_82490_(toTargeted.m_82526_(axisNormal))).m_82549_(lastNodePos);
        for (int i = 0; i < CogwheelChainPlacementInteraction.currentBuildingChain.getSize(); ++i) {
            CogwheelChainPlacementEffect.showBlockOutline(level, CogwheelChainPlacementInteraction.currentBuildingChain.getNodes().get(i).pos());
        }
        for (int side = -1; side <= 1; side += 2) {
            for (int i = 0; i < CogwheelChainPlacementInteraction.currentBuildingChain.getSize() - 1; ++i) {
                Vec3 pathingTangentA;
                Vec3 pathingTangentB;
                PlacingCogwheelNode nodeB;
                PlacingCogwheelNode nodeA = CogwheelChainPlacementInteraction.currentBuildingChain.getNodes().get(i);
                if (CogwheelChainPathfinder.isValidPathStep(nodeA, side, nodeB = CogwheelChainPlacementInteraction.currentBuildingChain.getNodes().get(i + 1), side)) {
                    pathingTangentB = CogwheelChainPathfinder.getPathingTangentOnCog(nodeA, nodeB, side);
                    pathingTangentA = CogwheelChainPathfinder.getPathingTangentOnCog(nodeB, nodeA, -side);
                    Outliner.getInstance().showLine((Object)("cogwheel_chain_placement_pathing_" + nodeA.pos() + "_" + nodeB.pos() + "_side_" + side), nodeA.center().m_82549_(pathingTangentA), nodeB.center().m_82549_(pathingTangentB)).colored(9817409).lineWidth(0.0625f);
                    continue;
                }
                if (!CogwheelChainPathfinder.isValidPathStep(nodeA, side, nodeB, -side)) continue;
                pathingTangentB = CogwheelChainPathfinder.getPathingTangentOnCog(nodeA, nodeB, -side);
                pathingTangentA = CogwheelChainPathfinder.getPathingTangentOnCog(nodeB, nodeA, -side);
                Outliner.getInstance().showLine((Object)("cogwheel_chain_placement_pathing_" + nodeA.pos() + "_" + nodeB.pos() + "_side_" + side + "_switching"), nodeA.center().m_82549_(pathingTangentA), nodeB.center().m_82549_(pathingTangentB)).colored(9817409).lineWidth(0.0625f);
            }
        }
        Vec3 lastPos = CogwheelChainPlacementInteraction.currentBuildingChain.getLastNode().center();
        CogwheelChainPlacementEffect.renderParticlesBetween(level, lastPos, projected);
        BlockPos targetedPos = hit.m_82425_();
        BlockState targetedState = level.m_8055_(targetedPos);
        return PlacingCogwheelChain.isValidBlockTarget(targetedState) ? targetedPos : null;
    }

    private static void showBlockOutline(ClientLevel level, BlockPos pos) {
        AtomicInteger counter = new AtomicInteger(0);
        level.m_8055_(pos).m_60808_((BlockGetter)level, pos).m_83224_((fx, fy, fz, tx, ty, tz) -> Outliner.getInstance().showLine((Object)("cogwheel_chain_placement_" + pos + "_outline_" + counter.getAndIncrement()), new Vec3(fx, fy, fz).m_82549_(Vec3.m_82528_((Vec3i)pos)), new Vec3(tx, ty, tz).m_82549_(Vec3.m_82528_((Vec3i)pos))).colored(9817409).lineWidth(0.0625f));
    }

    private static void renderParticlesBetween(ClientLevel level, Vec3 from, Vec3 to) {
        Vec3 delta = to.m_82546_(from);
        double length = delta.m_82553_();
        if (length < 0.001 || length > 256.0) {
            return;
        }
        Vec3 dir = delta.m_82541_();
        double step = 0.25;
        for (double t = 0.0; t <= length; t += 0.25) {
            if (level.m_213780_().m_188501_() > 0.1f) continue;
            Vec3 lerped = from.m_82549_(dir.m_82490_(t));
            level.m_6493_((ParticleOptions)new DustParticleOptions(new Vector3f(0.66796875f, 0.8984375f, 0.32421875f), 1.0f), true, lerped.f_82479_, lerped.f_82480_, lerped.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

