/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge;

import earth.terrarium.botarium.Botarium;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyItem;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.item.ItemContainerBlock;
import earth.terrarium.botarium.forge.energy.ForgeEnergyContainer;
import earth.terrarium.botarium.forge.energy.ForgeItemEnergyContainer;
import earth.terrarium.botarium.forge.fluid.ForgeFluidContainer;
import earth.terrarium.botarium.forge.fluid.ForgeItemFluidContainer;
import earth.terrarium.botarium.forge.item.ItemContainerWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

@Mod(value="botarium")
public class BotariumForge {
    public BotariumForge() {
        Botarium.init();
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addGenericListener(BlockEntity.class, BotariumForge::attachBlockCapabilities);
        bus.addGenericListener(ItemStack.class, BotariumForge::attachItemCapabilities);
    }

    public static void attachBlockCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object;
        Object nonEntityFluidContainer;
        FluidApi.BlockFluidGetter<?> nonEntityBlockFluidGetter;
        Object fluidContainer;
        FluidApi.BlockFluidGetter<?> blockFluidGetter;
        Object object2;
        Object nonEntityEnergyContainer;
        EnergyApi.BlockEnergyGetter<?> nonEntityEnergyGetter;
        Object energyContainer;
        EnergyApi.BlockEnergyGetter<?> blockEnergyGetter;
        EnergyApi.finalizeBlockRegistration();
        FluidApi.finalizeBlockRegistration();
        Object object3 = event.getObject();
        if (object3 instanceof BotariumEnergyBlock) {
            BotariumEnergyBlock energyBlock = (BotariumEnergyBlock)object3;
            event.addCapability(new ResourceLocation("botarium", "energy"), new ForgeEnergyContainer(energyBlock.getEnergyStorage(), (BlockEntity)event.getObject()));
        }
        if ((blockEnergyGetter = EnergyApi.FINALIZED_BLOCK_ENTITY_LOOKUP_MAP.get(((BlockEntity)event.getObject()).m_58903_())) != null && (energyContainer = blockEnergyGetter.getEnergyContainer(((BlockEntity)event.getObject()).m_58904_(), ((BlockEntity)event.getObject()).m_58899_(), ((BlockEntity)event.getObject()).m_58900_(), (BlockEntity)event.getObject(), null)) != null) {
            event.addCapability(new ResourceLocation("botarium", "energy"), new ForgeEnergyContainer(energyContainer, (BlockEntity)event.getObject()));
        }
        if ((nonEntityEnergyGetter = EnergyApi.FINALIZED_BLOCK_LOOKUP_MAP.get(((BlockEntity)event.getObject()).m_58900_().m_60734_())) != null && (nonEntityEnergyContainer = nonEntityEnergyGetter.getEnergyContainer(((BlockEntity)event.getObject()).m_58904_(), ((BlockEntity)event.getObject()).m_58899_(), ((BlockEntity)event.getObject()).m_58900_(), (BlockEntity)event.getObject(), null)) != null) {
            event.addCapability(new ResourceLocation("botarium", "energy"), new ForgeEnergyContainer(nonEntityEnergyContainer, (BlockEntity)event.getObject()));
        }
        if ((object2 = event.getObject()) instanceof BotariumFluidBlock) {
            BotariumFluidBlock fluidHoldingBlock = (BotariumFluidBlock)object2;
            event.addCapability(new ResourceLocation("botarium", "fluid"), new ForgeFluidContainer(fluidHoldingBlock.getFluidContainer(), (BlockEntity)event.getObject()));
        }
        if ((blockFluidGetter = FluidApi.FINALIZED_BLOCK_ENTITY_LOOKUP_MAP.get(((BlockEntity)event.getObject()).m_58903_())) != null && (fluidContainer = blockFluidGetter.getFluidContainer(((BlockEntity)event.getObject()).m_58904_(), ((BlockEntity)event.getObject()).m_58899_(), ((BlockEntity)event.getObject()).m_58900_(), (BlockEntity)event.getObject(), null)) != null) {
            event.addCapability(new ResourceLocation("botarium", "fluid"), new ForgeFluidContainer(fluidContainer, (BlockEntity)event.getObject()));
        }
        if ((nonEntityBlockFluidGetter = FluidApi.FINALIZED_BLOCK_LOOKUP_MAP.get(((BlockEntity)event.getObject()).m_58900_().m_60734_())) != null && (nonEntityFluidContainer = nonEntityBlockFluidGetter.getFluidContainer(((BlockEntity)event.getObject()).m_58904_(), ((BlockEntity)event.getObject()).m_58899_(), ((BlockEntity)event.getObject()).m_58900_(), (BlockEntity)event.getObject(), null)) != null) {
            event.addCapability(new ResourceLocation("botarium", "fluid"), new ForgeFluidContainer(nonEntityFluidContainer, (BlockEntity)event.getObject()));
        }
        if ((object = event.getObject()) instanceof ItemContainerBlock) {
            ItemContainerBlock itemContainerBlock = (ItemContainerBlock)object;
            event.addCapability(new ResourceLocation("botarium", "item"), (ICapabilityProvider)new ItemContainerWrapper(itemContainerBlock.getContainer()));
        }
    }

    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        Object fluidContainer;
        FluidApi.ItemFluidGetter<?> itemFluidGetter;
        Item item;
        Object energyContainer;
        EnergyApi.ItemEnergyGetter<?> itemEnergyGetter;
        EnergyApi.finalizeItemRegistration();
        FluidApi.finalizeItemRegistration();
        Item item2 = ((ItemStack)event.getObject()).m_41720_();
        if (item2 instanceof BotariumEnergyItem) {
            BotariumEnergyItem energyItem = (BotariumEnergyItem)item2;
            event.addCapability(new ResourceLocation("botarium", "energy"), new ForgeItemEnergyContainer(energyItem.getEnergyStorage((ItemStack)event.getObject()), (ItemStack)event.getObject()));
        }
        if ((itemEnergyGetter = EnergyApi.FINALIZED_ITEM_LOOKUP_MAP.get(((ItemStack)event.getObject()).m_41720_())) != null && (energyContainer = itemEnergyGetter.getEnergyContainer((ItemStack)event.getObject())) != null) {
            event.addCapability(new ResourceLocation("botarium", "energy"), new ForgeItemEnergyContainer(energyContainer, (ItemStack)event.getObject()));
        }
        if ((item = ((ItemStack)event.getObject()).m_41720_()) instanceof BotariumFluidItem) {
            BotariumFluidItem fluidHoldingItem = (BotariumFluidItem)item;
            event.addCapability(new ResourceLocation("botarium", "fluid"), new ForgeItemFluidContainer(fluidHoldingItem.getFluidContainer((ItemStack)event.getObject()), (ItemStack)event.getObject()));
        }
        if ((itemFluidGetter = FluidApi.FINALIZED_ITEM_LOOKUP_MAP.get(((ItemStack)event.getObject()).m_41720_())) != null && (fluidContainer = itemFluidGetter.getFluidContainer((ItemStack)event.getObject())) != null) {
            event.addCapability(new ResourceLocation("botarium", "fluid"), new ForgeItemFluidContainer(fluidContainer, (ItemStack)event.getObject()));
        }
    }
}

