/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.impl;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.function.BiPredicate;
import java.util.function.IntToLongFunction;
import net.minecraft.util.Mth;

public class InsertOnlyFluidContainer
extends SimpleFluidContainer {
    public InsertOnlyFluidContainer(IntToLongFunction maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        super(maxAmount, tanks, fluidFilter);
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        return FluidHooks.emptyFluid();
    }

    @Override
    public FluidHolder internalExtract(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            FluidHolder toExtract = fluid.copyHolder();
            if (this.storedFluid.isEmpty()) {
                return FluidHooks.emptyFluid();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long extractedAmount = (long)Mth.m_14036_((float)fluid.getFluidAmount(), (float)0.0f, (float)((FluidHolder)this.storedFluid.get(i)).getFluidAmount());
            toExtract.setAmount(extractedAmount);
            if (simulate) {
                return toExtract;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() - extractedAmount);
            if (((FluidHolder)this.storedFluid.get(i)).getFluidAmount() == 0L) {
                this.storedFluid.set(i, (Object)FluidHooks.emptyFluid());
            }
            return toExtract;
        }
        return FluidHooks.emptyFluid();
    }

    @Override
    public boolean allowsExtraction() {
        return false;
    }
}

