/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.worldgen;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.worldgen.TFMGConfiguredFeatures;
import com.simibubi.create.infrastructure.worldgen.ConfigPlacementFilter;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class TFMGPlacedFeatures {
    public static final ResourceKey<PlacedFeature> OIL_DEPOSIT = TFMGPlacedFeatures.key("oil_deposit");
    public static final ResourceKey<PlacedFeature> OIL_WELL = TFMGPlacedFeatures.key("oil_well");
    public static final ResourceKey<PlacedFeature> LEAD_ORE = TFMGPlacedFeatures.key("lead_ore");
    public static final ResourceKey<PlacedFeature> NICKEL_ORE = TFMGPlacedFeatures.key("nickel_ore");
    public static final ResourceKey<PlacedFeature> LITHIUM_ORE = TFMGPlacedFeatures.key("lithium_ore");
    public static final ResourceKey<PlacedFeature> TFMG_STRIATED_ORES_OVERWORLD = TFMGPlacedFeatures.key("tfmg_striated_ores_overworld");
    public static final ResourceKey<PlacedFeature> TFMG_STRIATED_ORES_NETHER = TFMGPlacedFeatures.key("tfmg_striated_ores_nether");

    private static ResourceKey<PlacedFeature> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)TFMG.asResource(name));
    }

    public static void bootstrap(BootstapContext<PlacedFeature> ctx) {
        HolderGetter featureLookup = ctx.m_255420_(Registries.f_256911_);
        Holder.Reference oilDeposit = featureLookup.m_255043_(TFMGConfiguredFeatures.OIL_DEPOSIT);
        Holder.Reference oilWell = featureLookup.m_255043_(TFMGConfiguredFeatures.OIL_WELL);
        Holder.Reference leadOre = featureLookup.m_255043_(TFMGConfiguredFeatures.LEAD_ORE);
        Holder.Reference nickelOre = featureLookup.m_255043_(TFMGConfiguredFeatures.NICKEL_ORE);
        Holder.Reference lithiumOre = featureLookup.m_255043_(TFMGConfiguredFeatures.LITHIUM_ORE);
        Holder.Reference striatedOresOverworld = featureLookup.m_255043_(TFMGConfiguredFeatures.TFMG_STRIATED_ORES_OVERWORLD);
        Holder.Reference striatedOresNether = featureLookup.m_255043_(TFMGConfiguredFeatures.TFMG_STRIATED_ORES_NETHER);
        PlacementUtils.m_254943_(ctx, OIL_DEPOSIT, (Holder)oilDeposit, TFMGPlacedFeatures.oilPlacement((PlacementModifier)RarityFilter.m_191900_((int)4)));
        PlacementUtils.m_254943_(ctx, OIL_WELL, (Holder)oilWell, TFMGPlacedFeatures.oilPlacement((PlacementModifier)RarityFilter.m_191900_((int)750)));
        PlacementUtils.m_254943_(ctx, LEAD_ORE, (Holder)leadOre, TFMGPlacedFeatures.placement((PlacementModifier)CountPlacement.m_191628_((int)5), -15, 80));
        PlacementUtils.m_254943_(ctx, NICKEL_ORE, (Holder)nickelOre, TFMGPlacedFeatures.placement((PlacementModifier)CountPlacement.m_191628_((int)5), -63, 20));
        PlacementUtils.m_254943_(ctx, LITHIUM_ORE, (Holder)lithiumOre, TFMGPlacedFeatures.placement((PlacementModifier)CountPlacement.m_191628_((int)3), -63, -5));
        PlacementUtils.m_254943_(ctx, TFMG_STRIATED_ORES_OVERWORLD, (Holder)striatedOresOverworld, TFMGPlacedFeatures.placement((PlacementModifier)RarityFilter.m_191900_((int)18), -30, 70));
        PlacementUtils.m_254943_(ctx, TFMG_STRIATED_ORES_NETHER, (Holder)striatedOresNether, TFMGPlacedFeatures.placement((PlacementModifier)RarityFilter.m_191900_((int)18), 40, 90));
    }

    private static List<PlacementModifier> placement(PlacementModifier frequency, int minHeight, int maxHeight) {
        return List.of(frequency, InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxHeight)), ConfigPlacementFilter.INSTANCE);
    }

    private static List<PlacementModifier> oilPlacement(PlacementModifier frequency) {
        return List.of(frequency, InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)-64)), ConfigPlacementFilter.INSTANCE);
    }
}

