/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.concrete_hose;

import com.drmangotea.tfmg.content.machinery.misc.concrete_hose.ConcreteFillingBehavior;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ConcreteHoseFluidHandler
implements IFluidHandler {
    private SmartFluidTank internalTank;
    private ConcreteFillingBehavior filler;
    private Supplier<BlockPos> rootPosGetter;
    private Supplier<Boolean> predicate;

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.getFluid().m_6212_((Fluid)TFMGFluids.LIQUID_CONCRETE.getSource())) {
            return 0;
        }
        if (!this.internalTank.isEmpty() && !resource.isFluidEqual(this.internalTank.getFluid())) {
            return 0;
        }
        if (resource.isEmpty() || !FluidHelper.hasBlockState((Fluid)resource.getFluid())) {
            return 0;
        }
        int diff = resource.getAmount();
        int totalAmountAfterFill = diff + this.internalTank.getFluidAmount();
        FluidStack remaining = resource.copy();
        boolean deposited = false;
        if (this.predicate.get().booleanValue() && totalAmountAfterFill >= 1000 && this.filler.tryDeposit(resource.getFluid(), this.rootPosGetter.get(), action.simulate())) {
            remaining.shrink(1000);
            diff -= 1000;
            deposited = true;
        }
        if (action.simulate()) {
            return diff <= 0 ? resource.getAmount() : this.internalTank.fill(remaining, action);
        }
        if (diff <= 0) {
            this.internalTank.drain(-diff, IFluidHandler.FluidAction.EXECUTE);
            return resource.getAmount();
        }
        return this.internalTank.fill(remaining, action) + (deposited ? 1000 : 0);
    }

    public FluidStack getFluidInTank(int tank) {
        return this.internalTank.getFluidInTank(tank);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public ConcreteHoseFluidHandler(SmartFluidTank internalTank, ConcreteFillingBehavior filler, Supplier<BlockPos> rootPosGetter, Supplier<Boolean> predicate) {
        this.internalTank = internalTank;
        this.filler = filler;
        this.rootPosGetter = rootPosGetter;
        this.predicate = predicate;
    }

    public int getTanks() {
        return this.internalTank.getTanks();
    }

    public int getTankCapacity(int tank) {
        return this.internalTank.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.internalTank.isFluidValid(tank, stack);
    }
}

