/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public final class AthenaUtils {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static boolean asBool(Direction.AxisDirection axisDir) {
        return axisDir == Direction.AxisDirection.POSITIVE;
    }

    public static <T> T ternary(Direction.AxisDirection axisDir, T first, T second) {
        return axisDir == Direction.AxisDirection.POSITIVE ? first : second;
    }

    public static Pair<Direction, Direction> getMinMax(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Pair.of((Object)Direction.WEST, (Object)Direction.EAST);
            case Direction.Axis.Y -> Pair.of((Object)Direction.UP, (Object)Direction.DOWN);
            case Direction.Axis.Z -> Pair.of((Object)Direction.NORTH, (Object)Direction.SOUTH);
        };
    }

    public static BlockPos getFacingPos(BlockPos pos, Direction facing, UrMom urMom) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.m_122012_();
                    }
                    case DOWN: {
                        yield pos.m_122019_();
                    }
                    case LEFT: {
                        yield pos.m_122024_();
                    }
                    case RIGHT: 
                }
                yield pos.m_122029_();
            }
            case Direction.DOWN -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.m_122019_();
                    }
                    case DOWN: {
                        yield pos.m_122012_();
                    }
                    case LEFT: {
                        yield pos.m_122024_();
                    }
                    case RIGHT: 
                }
                yield pos.m_122029_();
            }
            case Direction.NORTH -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.m_7494_();
                    }
                    case DOWN: {
                        yield pos.m_7495_();
                    }
                    case LEFT: {
                        yield pos.m_122029_();
                    }
                    case RIGHT: 
                }
                yield pos.m_122024_();
            }
            case Direction.SOUTH -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.m_7494_();
                    }
                    case DOWN: {
                        yield pos.m_7495_();
                    }
                    case LEFT: {
                        yield pos.m_122024_();
                    }
                    case RIGHT: 
                }
                yield pos.m_122029_();
            }
            case Direction.WEST -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.m_7494_();
                    }
                    case DOWN: {
                        yield pos.m_7495_();
                    }
                    case LEFT: {
                        yield pos.m_122012_();
                    }
                    case RIGHT: 
                }
                yield pos.m_122019_();
            }
            case Direction.EAST -> {
                switch (urMom) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield pos.m_7494_();
                    }
                    case DOWN: {
                        yield pos.m_7495_();
                    }
                    case LEFT: {
                        yield pos.m_122019_();
                    }
                    case RIGHT: 
                }
                yield pos.m_122012_();
            }
        };
    }

    public static boolean getFromDir(BlockState state, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_);
            case Direction.DOWN -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61367_);
            case Direction.NORTH -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
            case Direction.SOUTH -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
            case Direction.WEST -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
            case Direction.EAST -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
        };
    }

    public static enum UrMom {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

