/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PenguinEntity
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.m_20159_() && (entity = this.m_20202_()) instanceof Boat) {
            Boat boat = (Boat)entity;
            boat.m_20256_(boat.m_20184_().m_82542_(1.25, 1.0, 1.25));
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public PenguinEntity(EntityType<? extends PenguinEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22279_, (double)0.23f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.15));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new BoatDrivingGoal((Mob)this, 0.5));
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.4f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.PENGUIN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.PENGUIN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.PENGUIN_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    @Nullable
    public PenguinEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (PenguinEntity)((EntityType)EntityRegistry.PENGUIN.get()).m_20615_((Level)serverLevel);
    }

    public static class BoatDrivingGoal
    extends Goal {
        private final Mob entity;
        private Boat boat;
        private final double speed;

        public BoatDrivingGoal(Mob entity, double speed) {
            this.entity = entity;
            this.speed = speed;
        }

        public boolean m_8036_() {
            if (this.entity.m_20159_() && this.entity.m_20202_() instanceof Boat) {
                this.boat = (Boat)this.entity.m_20202_();
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.boat.m_213877_();
        }

        public void m_8056_() {
            this.boat.m_146922_(this.entity.m_146908_());
        }

        public void m_8041_() {
            this.boat = null;
        }

        public void m_8037_() {
            if (this.boat == null) {
                return;
            }
            if (this.isOnWater()) {
                float yaw = this.entity.m_146908_();
                Vector3f moveDirection = new Vector3f((float)(-Math.sin(Math.toRadians(yaw))), 0.0f, (float)Math.cos(Math.toRadians(yaw)));
                this.boat.m_20334_((double)moveDirection.x() * this.speed * 1.25, this.boat.m_20184_().m_7098_(), (double)moveDirection.z() * this.speed * 1.25);
                this.boat.m_38339_(moveDirection.x() != 0.0f || moveDirection.z() != 0.0f, moveDirection.x() != 0.0f || moveDirection.z() != 0.0f);
            } else {
                this.navigateToWater();
            }
        }

        private boolean isOnWater() {
            BlockPos pos = this.boat.m_20183_();
            BlockState blockState = this.entity.m_9236_().m_8055_(pos.m_7495_());
            return blockState.m_60713_(Blocks.f_49990_);
        }

        private void navigateToWater() {
            BlockPos boatPos = this.boat.m_20183_();
            for (int dx = -5; dx <= 5; ++dx) {
                for (int dz = -5; dz <= 5; ++dz) {
                    BlockPos pos = boatPos.m_7918_(dx, 0, dz);
                    BlockState blockState = this.entity.m_9236_().m_8055_(pos);
                    if (!blockState.m_60713_(Blocks.f_49990_)) continue;
                    double directionX = (double)pos.m_123341_() + 0.5 - this.boat.m_20185_();
                    double directionZ = (double)pos.m_123343_() + 0.5 - this.boat.m_20189_();
                    Vector3f direction = new Vector3f((float)directionX, 0.0f, (float)directionZ).normalize();
                    this.boat.m_20334_((double)direction.x() * this.speed, this.boat.m_20184_().f_82480_, (double)direction.z() * this.speed);
                    return;
                }
            }
        }
    }
}

