/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.gui.handlers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.satisfy.wildernature.block.entity.BountyBoardBlockEntity;
import net.satisfy.wildernature.event.EventManager;
import net.satisfy.wildernature.network.BountyBlockNetworking;
import net.satisfy.wildernature.util.BountyBoardTier;
import net.satisfy.wildernature.util.contract.Contract;
import net.satisfy.wildernature.util.contract.ContractInProgress;
import org.jetbrains.annotations.NotNull;

public class BountyBlockScreenHandler
extends AbstractContainerMenu {
    private static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.f_256798_);
    public static final RegistrySupplier<MenuType<BountyBlockScreenHandler>> BOUNTY_BLOCK = MENUS.register("bounty_menu", () -> MenuRegistry.ofExtended((id, inventory, buf) -> {
        BountyBlockScreenHandler handler = new BountyBlockScreenHandler(id, inventory, null);
        handler.onServerUpdate(buf);
        return handler;
    }));
    public final BountyBoardBlockEntity targetEntity;
    public EventManager onContractUpdate = new EventManager();
    public ContractInProgress activeContractProgress;
    public Contract activeContract;
    public long boardId;
    public Contract[] contracts;
    public int time;
    public int rerolls;
    public float progress;
    public ResourceLocation tierId;

    public static void registerMenuTypes() {
        MENUS.register();
    }

    public BountyBlockScreenHandler(int id, Inventory inventory, BountyBoardBlockEntity targetEntity) {
        super((MenuType)BOUNTY_BLOCK.get(), id);
        this.targetEntity = targetEntity;
        if (targetEntity != null) {
            targetEntity.onTick.subscribe(() -> {
                if (targetEntity.rerollCooldownLeft % 20 == 0 && inventory.f_35978_.f_36096_ == this) {
                    FriendlyByteBuf buf = new FriendlyByteBuf((ByteBuf)new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 0, 32768));
                    BountyBlockScreenHandler.writeBlockDataChange(buf, targetEntity.rerollsLeft, targetEntity.rerollCooldownLeft, targetEntity.boardId, targetEntity.tier, targetEntity.xp);
                    NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)inventory.f_35978_), (ResourceLocation)BountyBlockNetworking.ID_SCREEN_UPDATE, (FriendlyByteBuf)buf);
                }
            });
            targetEntity.onBlockDataChange.subscribe(() -> {
                if (inventory.f_35978_.f_36096_ == this) {
                    FriendlyByteBuf buf = new FriendlyByteBuf((ByteBuf)new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 0, 32768));
                    buf.m_130068_((Enum)BountyBlockNetworking.BountyServerUpdateType.MULTI);
                    buf.writeShort(3);
                    BountyBlockScreenHandler.writeBlockDataChange(buf, targetEntity.rerollsLeft, targetEntity.rerollCooldownLeft, targetEntity.boardId, targetEntity.tier, targetEntity.xp);
                    BountyBlockScreenHandler.writeUpdateContracts(buf, targetEntity);
                    BountyBlockScreenHandler.writeActiveContractInfo(buf, (ServerPlayer)inventory.f_35978_);
                    NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)inventory.f_35978_), (ResourceLocation)BountyBlockNetworking.ID_SCREEN_UPDATE, (FriendlyByteBuf)buf);
                }
            });
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, i * 9 + j + 9, j * 18 + 8, i * 18 + 86));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, j * 18 + 8, 144));
        }
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public static void writeBlockDataChange(FriendlyByteBuf buf, int rerolls, int time, long boardId, ResourceLocation tierId, int xp) {
        buf.m_130068_((Enum)BountyBlockNetworking.BountyServerUpdateType.SEND_BOARD_DATA);
        buf.writeInt(time);
        buf.writeByte(rerolls);
        buf.writeLong(boardId);
        buf.m_130085_(tierId);
        buf.writeFloat(BountyBoardTier.byId(tierId).orElseThrow(() -> new RuntimeException("Tier not found: " + tierId)).progress(xp));
    }

    public static void writeActiveContractInfo(FriendlyByteBuf buf, ServerPlayer player) {
        ContractInProgress contractProgress = ContractInProgress.progressPerPlayer.get(player.m_20148_());
        if (contractProgress == null) {
            buf.m_130068_((Enum)BountyBlockNetworking.BountyServerUpdateType.CLEAR_ACTIVE_CONTRACT);
        } else {
            buf.m_130068_((Enum)BountyBlockNetworking.BountyServerUpdateType.SET_ACTIVE_CONTRACT);
            buf.m_130079_((CompoundTag)ContractInProgress.SERVER_CODEC.encode((Object)contractProgress, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).get().left().orElseThrow(() -> new RuntimeException("Failed to encode contract progress")));
            buf.m_130079_((CompoundTag)Contract.CODEC.encode((Object)contractProgress.getContract(), (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).get().left().orElseThrow(() -> new RuntimeException("Failed to encode contract")));
        }
    }

    public static void writeUpdateContracts(FriendlyByteBuf buf, BountyBoardBlockEntity blockEntity) {
        buf.m_130068_((Enum)BountyBlockNetworking.BountyServerUpdateType.UPDATE_CONTRACTS);
        buf.m_130079_(blockEntity.getContractsNbt());
    }

    public void handleClientAction(ServerPlayer player, FriendlyByteBuf buf) {
        BountyBlockNetworking.BountyClientActionType action = (BountyBlockNetworking.BountyClientActionType)buf.m_130066_(BountyBlockNetworking.BountyClientActionType.class);
        switch (action) {
            case REROLL: {
                this.targetEntity.tryReroll();
                break;
            }
            case CONFIRM_CONTRACT: {
                this.handleConfirmContract(player, buf);
                break;
            }
            case FINISH_CONTRACT: {
                this.handleFinishContract(player);
                break;
            }
            case DELETE_CONTRACT: {
                this.handleDeleteContract(player);
            }
        }
        this.targetEntity.m_6596_();
    }

    private void handleConfirmContract(ServerPlayer player, FriendlyByteBuf buf) {
        ContractInProgress playerContract = ContractInProgress.progressPerPlayer.get(player.m_20148_());
        if (playerContract != null) {
            player.m_213846_((Component)Component.m_237113_((String)"Error: you already have a contract"));
            return;
        }
        byte id = buf.readByte();
        ResourceLocation contract = this.targetEntity.getContracts()[id];
        this.targetEntity.setRandomContractInSlot(id);
        ItemStack stack = Contract.fromId(contract).contractStack();
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("contract_id", contract.toString());
        tag.m_128362_("player_uuid", player.m_20148_());
        long startTick = Objects.requireNonNull(Objects.requireNonNull(player.m_20194_()).m_129783_(), "Server level not available").m_46467_();
        long expiryTick = startTick + 72000L;
        tag.m_128356_("expiry_tick", expiryTick);
        player.m_150109_().m_36054_(stack);
        ContractInProgress.progressPerPlayer.put(player.m_20148_(), ContractInProgress.newInstance(contract, Contract.fromId(contract).count(), this.targetEntity.boardId, startTick));
        this.updatePlayerScreen(player);
    }

    private void handleFinishContract(ServerPlayer player) {
        ContractInProgress contract = ContractInProgress.progressPerPlayer.get(player.m_20148_());
        if (contract == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Error: player does not have a contract"));
            return;
        }
        if (!contract.isFinished()) {
            player.m_213846_((Component)Component.m_237113_((String)"Error: contract is not finished"));
            return;
        }
        player.m_213846_((Component)Component.m_237110_((String)"text.gui.wildernature.bounty.finished", (Object[])new Object[]{Component.m_237115_((String)contract.getContract().name())}));
        ContractInProgress.progressPerPlayer.remove(player.m_20148_());
        contract.onFinish(player);
        this.updatePlayerScreen(player);
    }

    private void handleDeleteContract(ServerPlayer player) {
        ContractInProgress contract = ContractInProgress.progressPerPlayer.get(player.m_20148_());
        if (contract == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Error: you do not have a contract to delete."));
            return;
        }
        ContractInProgress.progressPerPlayer.remove(player.m_20148_());
        this.updatePlayerScreen(player);
    }

    private void updatePlayerScreen(ServerPlayer player) {
        FriendlyByteBuf newBuf = new FriendlyByteBuf((ByteBuf)new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 0, 32768));
        BountyBlockScreenHandler.writeActiveContractInfo(newBuf, player);
        BountyBlockScreenHandler.writeUpdateContracts(newBuf, this.targetEntity);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)BountyBlockNetworking.ID_SCREEN_UPDATE, (FriendlyByteBuf)newBuf);
    }

    public static AbstractContainerMenu createServer(int id, Inventory inventory, BountyBoardBlockEntity bountyBoardBlockEntity) {
        return new BountyBlockScreenHandler(id, inventory, bountyBoardBlockEntity);
    }

    public void onServerUpdate(FriendlyByteBuf buf) {
        BountyBlockNetworking.BountyServerUpdateType updateType = (BountyBlockNetworking.BountyServerUpdateType)buf.m_130066_(BountyBlockNetworking.BountyServerUpdateType.class);
        try {
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.MULTI) {
                int count = buf.readShort();
                for (int i = 0; i < count; ++i) {
                    this.onServerUpdate(buf);
                }
            }
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.UPDATE_CONTRACTS) {
                this.contracts = ((List)((Pair)Contract.CODEC.listOf().decode((DynamicOps)NbtOps.f_128958_, (Object)Objects.requireNonNull(buf.m_130260_()).m_128423_("list")).getOrThrow(false, error -> {
                    throw new RuntimeException((String)error);
                })).getFirst()).toArray(new Contract[3]);
                this.onContractUpdate.invoke();
            }
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.SEND_BOARD_DATA) {
                this.time = buf.readInt();
                this.rerolls = buf.readByte();
                this.boardId = buf.readLong();
                this.tierId = buf.m_130281_();
                this.progress = buf.readFloat();
            }
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.SET_ACTIVE_CONTRACT) {
                Platform.isDevelopmentEnvironment();
                CompoundTag nbt = buf.m_130260_();
                this.activeContractProgress = (ContractInProgress)((Pair)ContractInProgress.SERVER_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt).getOrThrow(false, error -> {
                    throw new RuntimeException((String)error);
                })).getFirst();
                nbt = buf.m_130260_();
                this.activeContract = (Contract)((Pair)Contract.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt).getOrThrow(false, error -> {
                    throw new RuntimeException((String)error);
                })).getFirst();
            }
            if (updateType == BountyBlockNetworking.BountyServerUpdateType.CLEAR_ACTIVE_CONTRACT) {
                this.activeContractProgress = null;
                this.activeContract = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

