/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.dragonLibLegacy.tag;

import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import plus.dragons.createenchantmentindustry.dragonLibLegacy.init.SafeRegistrate;

public class TagGen {
    private static final List<TagGen> READY_TO_GEN = new ArrayList<TagGen>();
    private SafeRegistrate registrate;
    private final List<NonNullConsumer<RegistrateTagsProvider<Block>>> blockTagGen;
    private final List<NonNullConsumer<RegistrateTagsProvider<Fluid>>> fluidTagGen;
    private final List<NonNullConsumer<RegistrateTagsProvider<Item>>> itemTagGen;

    private TagGen(SafeRegistrate registrate, List<NonNullConsumer<RegistrateTagsProvider<Block>>> blockTagGen, List<NonNullConsumer<RegistrateTagsProvider<Fluid>>> fluidTagGen, List<NonNullConsumer<RegistrateTagsProvider<Item>>> itemTagGen) {
        this.registrate = registrate;
        this.blockTagGen = blockTagGen;
        this.fluidTagGen = fluidTagGen;
        this.itemTagGen = itemTagGen;
    }

    public static void genAll() {
        for (TagGen tagGen : READY_TO_GEN) {
            for (NonNullConsumer<RegistrateTagsProvider<Block>> nonNullConsumer : tagGen.blockTagGen) {
                tagGen.registrate.addDataGenerator(ProviderType.BLOCK_TAGS, nonNullConsumer);
            }
            for (NonNullConsumer<RegistrateTagsProvider<Block>> nonNullConsumer : tagGen.itemTagGen) {
                tagGen.registrate.addDataGenerator(ProviderType.ITEM_TAGS, nonNullConsumer);
            }
            for (NonNullConsumer<RegistrateTagsProvider<Block>> nonNullConsumer : tagGen.fluidTagGen) {
                tagGen.registrate.addDataGenerator(ProviderType.FLUID_TAGS, nonNullConsumer);
            }
        }
    }

    public void activate() {
        READY_TO_GEN.add(this);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144280_}).tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144280_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<BlockItem, BlockBuilder<T, P>>> tagBlockAndItem(String ... path) {
        return b -> {
            for (String p : path) {
                b.tag(new TagKey[]{AllTags.forgeBlockTag((String)p)});
            }
            ItemBuilder item = b.item();
            for (String p : path) {
                item.tag(new TagKey[]{AllTags.forgeItemTag((String)p)});
            }
            return item;
        };
    }

    public static <T extends TagsProvider.TagAppender<?>> T addOptional(T appender, Mods mod, String id) {
        appender.m_176839_(mod.asResource(id));
        return appender;
    }

    public static <T extends TagsProvider.TagAppender<?>> T addOptional(T appender, Mods mod, String ... ids) {
        for (String id : ids) {
            appender.m_176839_(mod.asResource(id));
        }
        return appender;
    }

    public static class Builder {
        private SafeRegistrate registrate;
        private final List<NonNullConsumer<RegistrateTagsProvider<Block>>> blockTagGen = new ArrayList<NonNullConsumer<RegistrateTagsProvider<Block>>>();
        private final List<NonNullConsumer<RegistrateTagsProvider<Fluid>>> fluidTagGen = new ArrayList<NonNullConsumer<RegistrateTagsProvider<Fluid>>>();
        private final List<NonNullConsumer<RegistrateTagsProvider<Item>>> itemTagGen = new ArrayList<NonNullConsumer<RegistrateTagsProvider<Item>>>();

        public Builder(SafeRegistrate registrate) {
            this.registrate = registrate;
        }

        public Builder addItemTagFactory(NonNullConsumer<RegistrateTagsProvider<Item>> consumer) {
            this.itemTagGen.add(consumer);
            return this;
        }

        public Builder addBlockTagFactory(NonNullConsumer<RegistrateTagsProvider<Block>> consumer) {
            this.blockTagGen.add(consumer);
            return this;
        }

        public Builder addFluidTagFactory(NonNullConsumer<RegistrateTagsProvider<Fluid>> consumer) {
            this.fluidTagGen.add(consumer);
            return this;
        }

        public TagGen build() {
            return new TagGen(this.registrate, this.blockTagGen, this.fluidTagGen, this.itemTagGen);
        }
    }
}

