/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.level.CustomSpawner;
import net.minecraftforge.registries.ForgeRegistries;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.commands.TorchInfo;

public class CommandTorchmaster {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"torchmaster");
        for (SubCommands subCommand : SubCommands.values()) {
            command.then(Commands.m_82127_((String)subCommand.getTranslationKey()).executes(subCommand::execute));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.requires(cmdSrc -> cmdSrc.m_6761_(2))).executes(ctx -> 0));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SubCommands {
        DUMP_TORCHES("torchdump"){

            @Override
            public int execute(CommandContext<CommandSourceStack> ctx) {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                MinecraftServer server = source.m_81377_();
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("# Torchmaster Torch Dump Start  #");
                Torchmaster.Log.info("#################################");
                for (ServerLevel level : server.m_129785_()) {
                    level.getCapability(ModCaps.TEB_REGISTRY, Direction.DOWN).ifPresent(container -> {
                        Torchmaster.Log.info("Torches in dimension {}:", (Object)level.m_46472_().m_211136_());
                        for (TorchInfo torch : container.getEntries()) {
                            Torchmaster.Log.info("  {} @ {}", (Object)torch.getName(), (Object)torch.getPos());
                        }
                    });
                }
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("# Torchmaster Torch Dump End    #");
                Torchmaster.Log.info("#################################");
                source.m_288197_(() -> Component.m_237115_((String)"torchmaster.command.torch_dump.completed"), false);
                return 0;
            }
        }
        ,
        DUMP_ENTITIES("entitydump"){

            @Override
            public int execute(CommandContext<CommandSourceStack> ctx) {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("# Torchmaster Entity Dump Start #");
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("List of registered entities:");
                for (ResourceLocation loc : ForgeRegistries.ENTITY_TYPES.getKeys()) {
                    Torchmaster.Log.info("  {}", (Object)loc);
                }
                Torchmaster.Log.info("Dread Lamp Registry Content:");
                for (ResourceLocation loc : Torchmaster.DreadLampFilterRegistry.getRegisteredEntities()) {
                    Torchmaster.Log.info("  {}", (Object)loc);
                }
                Torchmaster.Log.info("Mega Torch Registry Content:");
                for (ResourceLocation loc : Torchmaster.MegaTorchFilterRegistry.getRegisteredEntities()) {
                    Torchmaster.Log.info("  {}", (Object)loc);
                }
                Torchmaster.Log.info("#################################");
                Torchmaster.Log.info("# Torchmaster Entity Dump End   #");
                Torchmaster.Log.info("#################################");
                source.m_288197_(() -> Component.m_237115_((String)"torchmaster.command.entity_dump.completed"), false);
                return 0;
            }
        }
        ,
        TRY_SETUP_SIEGE("try_setup_siege"){

            @Override
            public int execute(CommandContext<CommandSourceStack> ctx) {
                ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
                try {
                    Field field = ServerLevel.class.getDeclaredField("customSpawners");
                    field.setAccessible(true);
                    List customSpawnersList = (List)field.get(level);
                    for (CustomSpawner customSpawner : customSpawnersList) {
                        if (!(customSpawner instanceof VillageSiege)) continue;
                        VillageSiege siege = (VillageSiege)customSpawner;
                        Field siegeStateField = VillageSiege.class.getDeclaredField("siegeState");
                        siegeStateField.setAccessible(true);
                        siegeStateField.set(siege, siegeStateField.getType().getEnumConstants()[1]);
                        Field hasSetupSiegeField = VillageSiege.class.getDeclaredField("hasSetupSiege");
                        hasSetupSiegeField.setAccessible(true);
                        hasSetupSiegeField.setBoolean(siege, false);
                        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"Attempting village siege"));
                    }
                }
                catch (Exception ex) {
                    ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"Exception during siege setup"));
                    Torchmaster.Log.error("Error while setting up siege", (Throwable)ex);
                }
                return 0;
            }
        };

        private final String translationKey;

        private SubCommands(String translationKey) {
            this.translationKey = translationKey;
        }

        public abstract int execute(CommandContext<CommandSourceStack> var1);

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

