/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.panel;

import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelEffectPacket;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import ru.zznty.create_factory_abstractions.api.generic.AbstractionsCapabilities;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackagerAttachedHandler;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_abstractions.generic.support.GenericLogisticsManager;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;
import ru.zznty.create_factory_abstractions.generic.support.PanelRequestedStacks;
import ru.zznty.create_factory_abstractions.generic.support.StackRequest;
import ru.zznty.create_factory_logistics.Config;
import ru.zznty.create_factory_logistics.compat.extra_gauges.AbstractPanelBehaviourStub;

@Mixin(value={FactoryPanelBehaviour.class})
public abstract class FactoryPanelRequestMixin
extends FilteringBehaviour
implements MenuProvider {
    @Shadow(remap=false)
    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    @Shadow(remap=false)
    public RequestPromiseQueue restockerPromises;
    @Shadow(remap=false)
    public boolean satisfied;
    @Shadow(remap=false)
    public boolean promisedSatisfied;
    @Shadow(remap=false)
    public boolean waitingForNetwork;
    @Shadow(remap=false)
    public boolean redstonePowered;
    @Shadow(remap=false)
    private int timer;
    @Shadow(remap=false)
    private int recipeOutput;
    @Shadow(remap=false)
    public String recipeAddress;
    @Shadow(remap=false)
    public List<ItemStack> activeCraftingArrangement;
    @Shadow(remap=false)
    public UUID network;

    public FactoryPanelRequestMixin(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be, slot);
    }

    @Shadow(remap=false)
    public FactoryPanelBlockEntity panelBE() {
        return null;
    }

    @Shadow(remap=false)
    public void resetTimer() {
    }

    @Shadow(remap=false)
    public FactoryPanelPosition getPanelPosition() {
        return null;
    }

    @Shadow(remap=false)
    public int getLevelInStorage() {
        return 0;
    }

    @Shadow(remap=false)
    public int getPromised() {
        return 0;
    }

    @Shadow(remap=false)
    private int getConfigRequestIntervalInTicks() {
        return 0;
    }

    @Shadow
    protected abstract void sendEffect(FactoryPanelPosition var1, boolean var2);

    @Unique
    private void createFactoryLogistics$sendEffect(FactoryPanelPosition fromPos, FactoryPanelPosition toPos, boolean success) {
        AllPackets.sendToNear((Level)this.getWorld(), (BlockPos)this.getPos(), (int)64, (Object)new FactoryPanelEffectPacket(fromPos, toPos, success));
    }

    @Unique
    private void createFactoryLogistics$tryRestock() {
        FactoryPanelBlockEntity panelBE = this.panelBE();
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null) {
            return;
        }
        Optional handler = packager.getCapability(AbstractionsCapabilities.PACKAGER_ATTACHED).resolve();
        if (handler.isEmpty()) {
            return;
        }
        GenericStack stack = GenericStack.of((FactoryPanelBehaviour)((FactoryPanelBehaviour)this));
        IdentifiedInventory identifiedInventory = ((PackagerAttachedHandler)handler.get()).identifiedInventory();
        if (identifiedInventory == null) {
            return;
        }
        int availableOnNetwork = GenericLogisticsManager.getStockOf((UUID)this.network, (GenericStack)stack, (IdentifiedInventory)identifiedInventory);
        if (availableOnNetwork == 0) {
            this.sendEffect(this.getPanelPosition(), false);
            return;
        }
        int inStorage = this.getLevelInStorage();
        int promised = this.getPromised();
        int demand = stack.amount();
        int amountToOrder = Math.max(0, demand - promised - inStorage);
        GenericStack orderedStack = stack.withAmount(Math.min(amountToOrder, availableOnNetwork));
        GenericOrder order = GenericOrder.order(List.of(orderedStack));
        this.sendEffect(this.getPanelPosition(), true);
        if (!GenericLogisticsManager.broadcastPackageRequest((UUID)this.network, (LogisticallyLinkedBehaviour.RequestType)LogisticallyLinkedBehaviour.RequestType.RESTOCK, (GenericOrder)order, (IdentifiedInventory)identifiedInventory, (String)this.recipeAddress)) {
            return;
        }
        this.restockerPromises.add(new RequestPromise(BigGenericStack.of((GenericStack)orderedStack).asStack()));
    }

    @Unique
    private boolean createFactoryLogistics$requestDependent(List<PanelRequestedStacks> toRequest, FactoryPanelConnection sourceConnection, FactoryPanelBehaviour context, Set<FactoryPanelPosition> visited) {
        FactoryPanelBehaviour source = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)sourceConnection);
        if (source == null) {
            return false;
        }
        if (!visited.add(sourceConnection.from)) {
            return source.satisfied || source.promisedSatisfied;
        }
        GenericStack ingredient = GenericStack.of((FactoryPanelBehaviour)source).withAmount(sourceConnection.amount);
        GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)LogisticsManager.getSummaryOfNetwork((UUID)source.network, (boolean)true));
        if (ingredient.isEmpty() || summary.isEmpty()) {
            this.createFactoryLogistics$sendEffect(sourceConnection.from, context.getPanelPosition(), false);
            return false;
        }
        if (summary.getCountOf(ingredient.key()) >= ingredient.amount()) {
            return true;
        }
        if (source.getLevelInStorage() + source.getPromised() >= ingredient.amount()) {
            return false;
        }
        if (Config.factoryGaugeCascadeRequest && !source.targetedBy.isEmpty() && !source.recipeAddress.isBlank()) {
            for (FactoryPanelConnection connection : source.targetedBy.values()) {
                if (this.createFactoryLogistics$requestDependent(toRequest, connection, source, visited)) continue;
                return false;
            }
            for (FactoryPanelConnection connection : source.targetedBy.values()) {
                visited.remove(connection.from);
            }
        } else {
            return false;
        }
        toRequest.add(PanelRequestedStacks.of((FactoryPanelBehaviour)source));
        this.createFactoryLogistics$sendEffect(sourceConnection.from, context.getPanelPosition(), true);
        return true;
    }

    @WrapMethod(method={"tickRequests"}, remap=false)
    private void tickRequests(Operation<Void> original) {
        FactoryPanelBehaviour source = (FactoryPanelBehaviour)this;
        if (AbstractPanelBehaviourStub.is(source)) {
            original.call(new Object[0]);
            return;
        }
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (this.targetedBy.isEmpty() && !panelBE.restocker) {
            return;
        }
        if (this.satisfied || this.promisedSatisfied || this.waitingForNetwork || this.redstonePowered) {
            return;
        }
        if (this.timer > 0) {
            this.timer = org.joml.Math.min((int)this.timer, (int)this.getConfigRequestIntervalInTicks());
            --this.timer;
            return;
        }
        this.resetTimer();
        if (this.recipeAddress.isBlank()) {
            return;
        }
        if (panelBE.restocker) {
            this.createFactoryLogistics$tryRestock();
            return;
        }
        ArrayList<PanelRequestedStacks> toRequest = new ArrayList<PanelRequestedStacks>();
        HashSet<FactoryPanelPosition> visited = new HashSet<FactoryPanelPosition>();
        for (FactoryPanelConnection connection : source.targetedBy.values()) {
            if (this.createFactoryLogistics$requestDependent(toRequest, connection, source, visited)) continue;
            this.sendEffect(connection.from, false);
            return;
        }
        if (visited.size() == this.targetedBy.size()) {
            toRequest.add(PanelRequestedStacks.of((FactoryPanelBehaviour)source));
        }
        HashMap<PanelRequestedStacks, Multimap> requests = new HashMap<PanelRequestedStacks, Multimap>();
        for (PanelRequestedStacks panelRequestedStacks : toRequest) {
            for (Map.Entry<UUID, List<Object>> entry : panelRequestedStacks.ingredients().stream().collect(Collectors.groupingBy(StackRequest::network)).entrySet()) {
                GenericOrder order = GenericOrder.of((PanelRequestedStacks)panelRequestedStacks, entry.getValue());
                Multimap request = GenericLogisticsManager.findPackagersForRequest((UUID)entry.getKey(), (GenericOrder)order, null, (String)panelRequestedStacks.recipeAddress());
                requests.put(panelRequestedStacks, request);
            }
        }
        for (Multimap multimap : requests.values()) {
            for (PackagerBlockEntity packagerBlockEntity : multimap.keySet()) {
                if (!packagerBlockEntity.isTooBusyFor(LogisticallyLinkedBehaviour.RequestType.RESTOCK)) continue;
                return;
            }
        }
        for (Multimap multimap : requests.values()) {
            GenericLogisticsManager.performPackageRequests((Multimap)multimap);
        }
        for (Map.Entry entry : requests.entrySet()) {
            RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(((PanelRequestedStacks)entry.getKey()).resultNetwork());
            if (promises == null || !((Multimap)entry.getValue()).isEmpty()) continue;
            promises.add(new RequestPromise(BigGenericStack.of((GenericStack)((PanelRequestedStacks)entry.getKey()).result()).asStack()));
        }
        panelBE.advancements.awardPlayer(AllAdvancements.FACTORY_GAUGE);
    }

    @ModifyVariable(method={"tickStorageMonitor"}, at=@At(value="STORE"), ordinal=0, remap=false)
    private boolean setSatisfied(boolean value, @Local(ordinal=1) int promised) {
        return value && promised == 0;
    }
}

