/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.packager;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlock;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import ru.zznty.create_factory_abstractions.api.generic.AbstractionsCapabilities;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackageBuilder;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackageMeasureResult;
import ru.zznty.create_factory_abstractions.api.generic.capability.PackagerAttachedHandler;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;
import ru.zznty.create_factory_abstractions.generic.support.GenericPackagerBlockEntity;
import ru.zznty.create_factory_abstractions.generic.support.GenericPromiseQueue;
import ru.zznty.create_factory_abstractions.generic.support.GenericRequest;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkBlockEntity;
import ru.zznty.create_factory_logistics.logistics.packager.GenericPackagerItemHandler;

@Mixin(value={PackagerBlockEntity.class})
public abstract class GenericPackagerBlockEntityMixin
extends SmartBlockEntity
implements GenericPackagerBlockEntity {
    @Shadow(remap=false)
    public InvManipulationBehaviour targetInventory;
    @Shadow(remap=false)
    public String signBasedAddress;
    @Shadow(remap=false)
    public List<BigItemStack> queuedExitingPackages;
    @Shadow(remap=false)
    public ItemStack heldBox;
    @Shadow(remap=false)
    public ItemStack previouslyUnwrapped;
    @Shadow(remap=false)
    public int animationTicks;
    @Shadow(remap=false)
    public int buttonCooldown;
    @Shadow(remap=false)
    public boolean animationInward;
    @Shadow(remap=false)
    private AdvancementBehaviour advancements;
    @Shadow(remap=false)
    private InventorySummary availableItems;

    @Shadow(remap=false)
    public void triggerStockCheck() {
    }

    @Shadow(remap=false)
    private BlockPos getLinkPos() {
        return null;
    }

    @Shadow
    public abstract <T> LazyOptional<T> getCapability(Capability<T> var1, Direction var2);

    public GenericPackagerBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="(Lcom/simibubi/create/content/logistics/packager/PackagerBlockEntity;)Lcom/simibubi/create/content/logistics/packager/PackagerItemHandler;"))
    private PackagerItemHandler createInventory(PackagerBlockEntity blockEntity) {
        return new GenericPackagerItemHandler(blockEntity);
    }

    @Overwrite(remap=false)
    public InventorySummary getAvailableItems(boolean scanInputSlots) {
        Optional handler = this.getCapability(AbstractionsCapabilities.PACKAGER_ATTACHED).resolve();
        if (this.availableItems != null && handler.isPresent() && !((PackagerAttachedHandler)handler.get()).hasChanges()) {
            return this.availableItems;
        }
        GenericInventorySummary available = GenericInventorySummary.empty();
        if (handler.isPresent()) {
            ((PackagerAttachedHandler)handler.get()).collectAvailable(scanInputSlots, available);
            this.createFactoryLogistics$submitNewArrivals(this.availableItems == null ? null : GenericInventorySummary.of((InventorySummary)this.availableItems), available);
        }
        this.availableItems = available.asSummary();
        return this.availableItems;
    }

    @Unique
    private void createFactoryLogistics$submitNewArrivals(GenericInventorySummary before, GenericInventorySummary after) {
        if (before == null || after.isEmpty()) {
            return;
        }
        Set<GenericPromiseQueue> promiseQueues = this.createFactoryLogistics$collectAdjacentQueues();
        if (promiseQueues.isEmpty()) {
            return;
        }
        for (GenericStack stack : after.get()) {
            before.add(stack.withAmount(-stack.amount()));
        }
        for (GenericPromiseQueue queue : promiseQueues) {
            for (GenericStack stack : before.get()) {
                if (stack.amount() >= 0) continue;
                queue.stackEnteredSystem(stack.withAmount(-stack.amount()));
            }
        }
    }

    @Unique
    private Set<GenericPromiseQueue> createFactoryLogistics$collectAdjacentQueues() {
        HashSet<GenericPromiseQueue> promiseQueues = new HashSet<GenericPromiseQueue>();
        Objects.requireNonNull(this.f_58857_);
        Optional handler = this.getCapability(AbstractionsCapabilities.PACKAGER_ATTACHED).resolve();
        if (handler.isEmpty()) {
            return promiseQueues;
        }
        for (Direction d : Iterate.directions) {
            Object object;
            if (!this.f_58857_.m_46749_(this.f_58858_.m_121945_(d))) continue;
            BlockState adjacentState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(d));
            if (adjacentState.m_60713_(((PackagerAttachedHandler)handler.get()).supportedGauge())) {
                if (FactoryPanelBlock.connectedDirection((BlockState)adjacentState) != d || !((object = this.f_58857_.m_7702_(this.f_58858_.m_121945_(d))) instanceof FactoryPanelBlockEntity)) continue;
                FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)object;
                if (!fpbe.restocker) continue;
                object = fpbe.panels.values().iterator();
                while (object.hasNext()) {
                    FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)object.next();
                    if (!behaviour.isActive()) continue;
                    promiseQueues.add((GenericPromiseQueue)behaviour.restockerPromises);
                }
            }
            if (!AllBlocks.STOCK_LINK.has(adjacentState) || NetworkLinkBlockEntity.getConnectedDirection(adjacentState) != d || !((object = this.f_58857_.m_7702_(this.f_58858_.m_121945_(d))) instanceof PackagerLinkBlockEntity)) continue;
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)object;
            UUID freqId = plbe.behaviour.freqId;
            if (!Create.LOGISTICS.hasQueuedPromises(freqId)) continue;
            promiseQueues.add((GenericPromiseQueue)Create.LOGISTICS.getQueuedPromises(freqId));
        }
        return promiseQueues;
    }

    @Overwrite(remap=false)
    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.f_58857_);
        PackageOrderWithCrafts orderContext = PackageItem.getOrderContext((ItemStack)box);
        Direction facing = this.m_58900_().m_61145_((Property)PackagerBlock.f_52588_).orElse(Direction.UP);
        BlockPos target = this.f_58858_.m_121945_(facing.m_122424_());
        BlockState targetState = this.f_58857_.m_8055_(target);
        ItemStack originalBox = box.m_41777_();
        boolean unpacked = this.getCapability(AbstractionsCapabilities.PACKAGER_ATTACHED).map(handler -> handler.unwrap(this.f_58857_, target, targetState, facing, orderContext, box, simulate)).orElse(false);
        if (unpacked && !simulate) {
            this.previouslyUnwrapped = originalBox;
            this.animationInward = true;
            this.animationTicks = 20;
            this.notifyUpdate();
        }
        return unpacked;
    }

    @Overwrite(remap=false)
    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        if (!(queuedRequests != null || this.heldBox.m_41619_() && this.animationTicks == 0 && this.buttonCooldown <= 0)) {
            return;
        }
        if (queuedRequests == null) {
            this.attemptToSendGeneric(null);
            return;
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void attemptToSendGeneric(Collection<GenericRequest> queuedRequests) {
        BlockEntity blockEntity;
        Pair<ItemStack, PackageBuilder> extracted = this.createFactoryLogistics$extractBox(queuedRequests);
        if (((ItemStack)extracted.getFirst()).m_41619_()) {
            return;
        }
        BlockPos linkPos = this.getLinkPos();
        if (linkPos != null && (blockEntity = this.f_58857_.m_7702_(linkPos)) instanceof PackagerLinkBlockEntity) {
            PackagerLinkBlockEntity plbe = (PackagerLinkBlockEntity)blockEntity;
            this.createFactoryLogistics$deductFromAccurateSummary(plbe.behaviour, (PackageBuilder)extracted.getSecond());
        }
        if (!this.heldBox.m_41619_() || this.animationTicks != 0) {
            this.queuedExitingPackages.add(new BigItemStack((ItemStack)extracted.getFirst()));
            return;
        }
        this.heldBox = (ItemStack)extracted.getFirst();
        this.animationInward = false;
        this.animationTicks = 20;
        this.advancements.awardPlayer(AllAdvancements.PACKAGER);
        this.triggerStockCheck();
        this.notifyUpdate();
    }

    @Unique
    public void createFactoryLogistics$deductFromAccurateSummary(LogisticallyLinkedBehaviour behaviour, PackageBuilder content) {
        InventorySummary accurateSummary = (InventorySummary)LogisticsManager.ACCURATE_SUMMARIES.getIfPresent((Object)behaviour.freqId);
        if (accurateSummary == null) {
            return;
        }
        GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)accurateSummary);
        for (GenericStack stack : content.content()) {
            summary.add(stack.withAmount(-Math.min(summary.getCountOf(stack.key()), stack.amount())));
        }
    }

    @Unique
    public Pair<ItemStack, PackageBuilder> createFactoryLogistics$extractBox(Collection<GenericRequest> queuedRequests) {
        ItemStack box;
        boolean requestQueue = queuedRequests != null;
        int linkIndexInOrder = 0;
        boolean finalLinkInOrder = false;
        int packageIndexAtLink = 0;
        boolean finalPackageAtLink = false;
        GenericOrder orderContext = null;
        int fixedOrderId = 0;
        String fixedAddress = null;
        Optional target = this.getCapability(AbstractionsCapabilities.PACKAGER_ATTACHED).resolve();
        if (target.isEmpty()) {
            return Pair.of((Object)ItemStack.f_41583_, null);
        }
        boolean anyItemPresent = false;
        PackageBuilder extractedPackage = ((PackagerAttachedHandler)target.get()).newPackage();
        GenericRequest nextRequest = null;
        Iterator<GenericRequest> requestIterator = null;
        if (requestQueue && !queuedRequests.isEmpty()) {
            requestIterator = queuedRequests.iterator();
            nextRequest = requestIterator.next();
            fixedAddress = nextRequest.address();
            fixedOrderId = nextRequest.orderId();
            linkIndexInOrder = nextRequest.linkIndex();
            finalLinkInOrder = nextRequest.finalLink().booleanValue();
            packageIndexAtLink = nextRequest.packageCounter().getAndIncrement();
            orderContext = nextRequest.context();
        }
        block0: for (int i = 0; i < extractedPackage.slotCount(); ++i) {
            boolean continuePacking = true;
            block1: while (continuePacking) {
                continuePacking = false;
                for (int slot = 0; slot < ((PackagerAttachedHandler)target.get()).slotCount(); ++slot) {
                    int leftovers;
                    boolean bulky;
                    int initialAmount = requestQueue ? Math.min(extractedPackage.maxPerSlot(), nextRequest.getCount()) : extractedPackage.maxPerSlot();
                    GenericStack extracted = ((PackagerAttachedHandler)target.get()).extract(slot, initialAmount, true);
                    if (extracted.isEmpty() || requestQueue && !nextRequest.stack().canStack(extracted)) continue;
                    boolean bl = bulky = extractedPackage.measure(extracted.key()) == PackageMeasureResult.BULKY;
                    if (bulky && anyItemPresent || (leftovers = extractedPackage.add(extracted)) < 0) continue;
                    int transferred = extracted.amount() - leftovers;
                    if (((PackagerAttachedHandler)target.get()).extract(slot, transferred, false).isEmpty()) continue;
                    anyItemPresent = true;
                    if (!requestQueue) {
                        if (!bulky) continue;
                        break block0;
                    }
                    nextRequest.subtract(transferred);
                    if (!nextRequest.isEmpty()) {
                        if (!bulky) continue;
                        break block0;
                    }
                    finalPackageAtLink = true;
                    requestIterator.remove();
                    if (!requestIterator.hasNext()) break block0;
                    int previousCount = nextRequest.packageCounter().intValue();
                    nextRequest = requestIterator.next();
                    if (!fixedAddress.equals(nextRequest.address()) || fixedOrderId != nextRequest.orderId()) break block0;
                    nextRequest.packageCounter().setValue(previousCount);
                    finalPackageAtLink = false;
                    continuePacking = true;
                    if (nextRequest.context() != null) {
                        orderContext = nextRequest.context();
                    }
                    if (!bulky) continue block1;
                    break block0;
                }
            }
        }
        if ((box = extractedPackage.build()).m_41619_()) {
            return Pair.of((Object)ItemStack.f_41583_, null);
        }
        PackageItem.clearAddress((ItemStack)box);
        if (fixedAddress != null) {
            PackageItem.addAddress((ItemStack)box, (String)fixedAddress);
        }
        if (requestQueue) {
            GenericOrder.set((ItemStack)box, (int)fixedOrderId, (int)linkIndexInOrder, (boolean)finalLinkInOrder, (int)packageIndexAtLink, (boolean)finalPackageAtLink, orderContext);
        }
        if (!requestQueue && !this.signBasedAddress.isBlank()) {
            PackageItem.addAddress((ItemStack)box, (String)this.signBasedAddress);
        }
        return Pair.of((Object)box, (Object)extractedPackage);
    }

    @WrapMethod(method={"isSameInventoryFallback"}, remap=false)
    private static boolean isSameInventoryNullCheck(IItemHandler first, IItemHandler second, Operation<Boolean> original) {
        if (first == null || second == null) {
            return false;
        }
        return (Boolean)original.call(new Object[]{first, second});
    }
}

