/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.candlelight.core.block.CookingPanBlock;
import net.satisfy.candlelight.core.registry.EntityTypeRegistry;
import net.satisfy.candlelight.core.world.ImplementedInventory;
import net.satisfy.farm_and_charm.client.gui.handler.RoasterGuiHandler;
import net.satisfy.farm_and_charm.core.item.food.EffectFood;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodHelper;
import net.satisfy.farm_and_charm.core.recipe.RoasterRecipe;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingPanBlockEntity
extends BlockEntity
implements BlockEntityTicker<CookingPanBlockEntity>,
ImplementedInventory,
MenuProvider {
    private static final int MAX_CAPACITY = 8;
    private static final int CONTAINER_SLOT = 6;
    private static final int OUTPUT_SLOT = 7;
    private static final int INGREDIENTS_AREA = 6;
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static final int MAX_COOKING_TIME = 300;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private int cookingTime;
    private boolean isBeingBurned;
    private final ContainerData delegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CookingPanBlockEntity.this.cookingTime;
                case 1 -> {
                    if (CookingPanBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CookingPanBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingPanBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CookingPanBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.COOKING_PAN_BLOCK_ENTITY.get(), pos, state);
    }

    public static int getMaxCookingTime() {
        return 300;
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        int[] nArray;
        switch (side) {
            case UP: {
                nArray = SLOTS_FOR_UP;
                break;
            }
            case DOWN: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 7;
                break;
            }
            default: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 6;
            }
        }
        return nArray;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.cookingTime = nbt.m_128451_("CookingTime");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("CookingTime", this.cookingTime);
    }

    public boolean isBeingBurned() {
        if (this.f_58857_ == null) {
            throw new IllegalStateException("Null world not allowed");
        }
        BlockState belowState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        return belowState.m_204336_(TagRegistry.ALLOWS_COOKING);
    }

    private boolean canCraft(Recipe<?> recipe, RegistryAccess access) {
        if (recipe == null || recipe.m_8043_(access).m_41619_()) {
            return false;
        }
        if (recipe instanceof RoasterRecipe) {
            RoasterRecipe cookingRecipe = (RoasterRecipe)recipe;
            ItemStack outputSlotStack = this.m_8020_(7);
            ItemStack containerSlotStack = this.m_8020_(6);
            boolean isContainerCorrect = containerSlotStack.m_150930_(cookingRecipe.getContainer().m_41720_());
            boolean isOutputSlotCompatible = outputSlotStack.m_41619_() || ItemStack.m_150942_((ItemStack)outputSlotStack, (ItemStack)this.generateOutputItem(recipe, access)) && outputSlotStack.m_41613_() < outputSlotStack.m_41741_();
            return isContainerCorrect && isOutputSlotCompatible;
        }
        return false;
    }

    private void craft(Recipe<?> recipe, RegistryAccess access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = this.generateOutputItem(recipe, access);
        ItemStack outputSlotStack = this.m_8020_(7);
        if (outputSlotStack.m_41619_()) {
            this.m_6836_(7, recipeOutput);
        } else {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
        }
        recipe.m_7527_().forEach(ingredient -> {
            for (int slot = 0; slot < 6; ++slot) {
                ItemStack stack = this.m_8020_(slot);
                if (!ingredient.test(stack)) continue;
                ItemStack remainderStack = stack.m_41720_().m_41470_() ? new ItemStack((ItemLike)Objects.requireNonNull(stack.m_41720_().m_41469_())) : ItemStack.f_41583_;
                stack.m_41774_(1);
                if (remainderStack.m_41619_()) break;
                this.m_6836_(slot, remainderStack);
                break;
            }
        });
        ItemStack containerSlotStack = this.m_8020_(6);
        if (!containerSlotStack.m_41619_()) {
            containerSlotStack.m_41774_(1);
            if (containerSlotStack.m_41619_()) {
                this.m_6836_(6, ItemStack.f_41583_);
            }
        }
    }

    private ItemStack generateOutputItem(Recipe<?> recipe, RegistryAccess access) {
        ItemStack outputStack = recipe.m_8043_(access);
        if (outputStack.m_41720_() instanceof EffectFood) {
            recipe.m_7527_().forEach(ingredient -> {
                for (int slot = 0; slot < 6; ++slot) {
                    ItemStack stack = this.m_8020_(slot);
                    if (!ingredient.test(stack)) continue;
                    EffectFoodHelper.getEffects((ItemStack)stack).forEach(effect -> EffectFoodHelper.addEffect((ItemStack)outputStack, (Pair)effect));
                    break;
                }
            });
        }
        return outputStack;
    }

    public void tick(Level world, BlockPos pos, BlockState state, CookingPanBlockEntity blockEntity) {
        if (world.m_5776_()) {
            return;
        }
        boolean wasBeingBurned = this.isBeingBurned;
        this.isBeingBurned = this.isBeingBurned();
        if (wasBeingBurned != this.isBeingBurned || (Boolean)state.m_61143_((Property)CookingPanBlock.LIT) != this.isBeingBurned) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)CookingPanBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        }
        if (!this.isBeingBurned) {
            return;
        }
        Recipe recipe = world.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.ROASTER_RECIPE_TYPE.get(), (Container)this, world).orElse(null);
        if (this.f_58857_ == null) {
            throw new IllegalStateException("Null world not allowed");
        }
        RegistryAccess access = this.f_58857_.m_9598_();
        if (this.canCraft(recipe, access)) {
            if (++this.cookingTime >= 300) {
                this.cookingTime = 0;
                this.craft(recipe, access);
            }
            if (!((Boolean)state.m_61143_((Property)CookingPanBlock.COOKING)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)CookingPanBlock.COOKING, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else {
            this.cookingTime = 0;
            if (((Boolean)state.m_61143_((Property)CookingPanBlock.COOKING)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)CookingPanBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new RoasterGuiHandler(syncId, inv, (Container)this, this.delegate);
    }
}

