/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.candlelight.core.util.CandlelightIdentifier;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SignedPaperGui
extends Screen {
    public static final Contents EMPTY_PROVIDER = new Contents(){

        @Override
        public int getPageCount() {
            return 0;
        }

        @Override
        public FormattedText getPageUnchecked(int index) {
            return FormattedText.f_130760_;
        }
    };
    public static final ResourceLocation BOOK_TEXTURE = new CandlelightIdentifier("textures/gui/note_paper_gui.png");
    private final Contents contents;
    private int pageIndex;
    private List<FormattedCharSequence> cachedPage = Collections.emptyList();
    private int cachedPageIndex = -1;

    public SignedPaperGui(Contents contents) {
        super(GameNarrator.f_93310_);
        this.contents = contents;
    }

    static List<String> readPages(CompoundTag nbt) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        SignedPaperGui.filterPages(nbt, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void filterPages(CompoundTag nbt, Consumer<String> pageConsumer) {
        IntFunction<Object> intFunction;
        ListTag nbtList = nbt.m_128437_("text", 8).m_6426_();
        if (Minecraft.m_91087_().m_167974_() && nbt.m_128425_("filtered_pages", 10)) {
            CompoundTag nbtCompound = nbt.m_128469_("filtered_pages");
            intFunction = page -> {
                String string = String.valueOf(page);
                return nbtCompound.m_128441_(string) ? nbtCompound.m_128461_(string) : nbtList.m_128778_(page);
            };
        } else {
            Objects.requireNonNull(nbtList);
            intFunction = arg_0 -> ((ListTag)nbtList).m_128778_(arg_0);
        }
        for (int i = 0; i < nbtList.size(); ++i) {
            pageConsumer.accept((String)intFunction.apply(i));
        }
    }

    public boolean setPage(int index) {
        int i = Mth.m_14045_((int)index, (int)0, (int)(this.contents.getPageCount() - 1));
        if (i != this.pageIndex) {
            this.pageIndex = i;
            this.cachedPageIndex = -1;
            return true;
        }
        return false;
    }

    protected boolean jumpToPage(int page) {
        return this.setPage(page);
    }

    protected void m_7856_() {
        this.addCloseButton();
    }

    protected void addCloseButton() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(null);
        }).m_252987_(this.f_96543_ / 2 - 100, 196, 200, 20).m_253136_());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        int i = (this.f_96543_ - 192) / 2;
        guiGraphics.m_280218_(BOOK_TEXTURE, i, 2, 0, 0, 192, 192);
        if (this.cachedPageIndex != this.pageIndex) {
            FormattedText stringVisitable = this.contents.getPage(this.pageIndex);
            this.cachedPage = this.f_96547_.m_92923_(stringVisitable, 114);
        }
        this.cachedPageIndex = this.pageIndex;
        Objects.requireNonNull(this.f_96547_);
        int l = Math.min(14, this.cachedPage.size());
        for (int m = 0; m < l; ++m) {
            FormattedCharSequence orderedText = this.cachedPage.get(m);
            int var10003 = i + 36;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280649_(this.f_96547_, orderedText, var10003, 32 + m * 9, 0, false);
        }
        Style style = this.getTextStyleAt(mouseX, mouseY);
        if (style != null) {
            guiGraphics.m_280304_(this.f_96547_, style, mouseX, mouseY);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Style style;
        if (button == 0 && (style = this.getTextStyleAt(mouseX, mouseY)) != null && this.m_5561_(style)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5561_(Style style) {
        assert (style != null);
        ClickEvent clickEvent = style.m_131182_();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            String string = clickEvent.m_130623_();
            try {
                int i = Integer.parseInt(string) - 1;
                return this.jumpToPage(i);
            }
            catch (Exception var5) {
                return false;
            }
        }
        boolean bl = super.m_5561_(style);
        if (bl && clickEvent.m_130622_() == ClickEvent.Action.RUN_COMMAND) {
            this.closeScreen();
        }
        return bl;
    }

    protected void closeScreen() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(null);
    }

    @Nullable
    public Style getTextStyleAt(double x, double y) {
        if (this.cachedPage.isEmpty()) {
            return null;
        }
        int i = Mth.m_14107_((double)(x - (double)((this.f_96543_ - 192) / 2) - 36.0));
        int j = Mth.m_14107_((double)(y - 2.0 - 30.0));
        if (i >= 0 && j >= 0) {
            Objects.requireNonNull(this.f_96547_);
            int k = Math.min(14, this.cachedPage.size());
            if (i <= 114) {
                Objects.requireNonNull(this.f_96541_.f_91062_);
                if (j < 9 * k + k) {
                    Objects.requireNonNull(this.f_96541_.f_91062_);
                    int l = j / 9;
                    if (l < this.cachedPage.size()) {
                        FormattedCharSequence orderedText = this.cachedPage.get(l);
                        return this.f_96541_.f_91062_.m_92865_().m_92338_(orderedText, i);
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Contents {
        public static Contents create(ItemStack stack) {
            if (stack.m_150930_((Item)ObjectRegistry.NOTE_PAPER_WRITEABLE.get())) {
                return new WrittenPaperContents(stack);
            }
            return stack.m_150930_((Item)ObjectRegistry.NOTE_PAPER_WRITEABLE.get()) ? new WritablePaperContents(stack) : EMPTY_PROVIDER;
        }

        public int getPageCount();

        public FormattedText getPageUnchecked(int var1);

        default public FormattedText getPage(int index) {
            return index >= 0 && index < this.getPageCount() ? this.getPageUnchecked(index) : FormattedText.f_130760_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrittenPaperContents
    implements Contents {
        private final List<String> pages;

        public WrittenPaperContents(ItemStack stack) {
            this.pages = WrittenPaperContents.getPages(stack);
        }

        private static List<String> getPages(ItemStack stack) {
            CompoundTag nbtCompound = stack.m_41783_();
            return WrittenPaperContents.makeSureTagIsValid(nbtCompound) ? SignedPaperGui.readPages(nbtCompound) : ImmutableList.of((Object)Component.Serializer.m_130703_((Component)Component.m_237115_((String)"book.invalid.tag").m_130940_(ChatFormatting.DARK_RED)));
        }

        private static boolean makeSureTagIsValid(CompoundTag nbtCompound) {
            if (nbtCompound == null) {
                return false;
            }
            if (!nbtCompound.m_128425_("text", 9)) {
                return false;
            }
            ListTag listTag = nbtCompound.m_128437_("text", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                String string = listTag.m_128778_(i);
                if (string.length() <= Short.MAX_VALUE) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        public FormattedText getPageUnchecked(int index) {
            String string = this.pages.get(index);
            try {
                MutableComponent stringVisitable = Component.Serializer.m_130701_((String)string);
                if (stringVisitable != null) {
                    return stringVisitable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return FormattedText.m_130775_((String)string);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WritablePaperContents
    implements Contents {
        private final List<String> pages;

        public WritablePaperContents(ItemStack stack) {
            this.pages = WritablePaperContents.getPages(stack);
        }

        private static List<String> getPages(ItemStack stack) {
            CompoundTag nbtCompound = stack.m_41783_();
            return nbtCompound != null ? SignedPaperGui.readPages(nbtCompound) : ImmutableList.of();
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        public FormattedText getPageUnchecked(int index) {
            return FormattedText.m_130775_((String)this.pages.get(index));
        }
    }
}

