/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes.fluid;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import com.tterrag.registrate.fabric.SimpleFlowableFluid;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.math.VecHelper;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;

public class FluidTankScenes {
    public static void storage(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        class_5819 random = class_5819.method_43047();
        scene.title("fluid_tank_storage", "Storing Fluids in Fluid Tanks");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        class_2338 tankPos = util.grid().at(3, 1, 2);
        Selection chocolate = util.select().fromTo(1, 5, 0, 0, 8, 1);
        Selection tank = util.select().fromTo(3, 1, 2, 3, 2, 2);
        Selection largeCog1 = util.select().position(3, 0, 5);
        Selection kinetics1 = util.select().fromTo(2, 1, 5, 2, 1, 3).add(util.select().position(2, 2, 4));
        Selection largeCog2 = util.select().position(6, 0, 1);
        Selection comparatorStuff = util.select().fromTo(2, 1, 1, 2, 1, 0);
        Selection pump = util.select().position(1, 1, 3);
        class_2338 pumpPos = util.grid().at(1, 1, 3);
        Selection spoutstuff = util.select().fromTo(3, 1, 0, 5, 3, 2).substract(tank);
        Selection pipe = util.select().fromTo(1, 1, 2, 1, 1, 5).add(util.select().position(1, 0, 5)).add(util.select().position(2, 1, 2));
        ElementLink tankLink = scene.world().showIndependentSection(tank, class_2350.field_11043);
        scene.world().moveSection(tankLink, util.vector().of(0.0, 0.0, -1.0), 0);
        scene.idle(5);
        ElementLink chocLink = scene.world().showIndependentSection(chocolate, class_2350.field_11043);
        scene.world().moveSection(chocLink, util.vector().of(2.0, -4.0, 3.0), 0);
        scene.idle(10);
        scene.overlay().showOutline(PonderPalette.GREEN, (Object)chocLink, util.select().fromTo(3, 1, 3, 2, 4, 4), 40);
        scene.idle(10);
        scene.overlay().showLine(PonderPalette.GREEN, util.vector().of(3.0, 1.0, 2.0), util.vector().of(2.0, 1.0, 3.0), 30);
        scene.overlay().showLine(PonderPalette.GREEN, util.vector().of(3.0, 3.0, 2.0), util.vector().of(2.0, 5.0, 3.0), 30);
        scene.overlay().showLine(PonderPalette.GREEN, util.vector().of(4.0, 3.0, 2.0), util.vector().of(4.0, 5.0, 3.0), 30);
        scene.overlay().showOutline(PonderPalette.GREEN, (Object)tankLink, util.select().fromTo(3, 1, 1, 3, 2, 1), 40);
        scene.idle(10);
        scene.overlay().showText(40).text("Fluid Tanks can be used to store large amounts of fluid").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 1), class_2350.field_11039));
        scene.idle(50);
        scene.world().hideIndependentSection(chocLink, class_2350.field_11033);
        scene.idle(5);
        FluidStack content = new FluidStack(((SimpleFlowableFluid.Flowing)AllFluids.CHOCOLATE.get()).method_15751(), 1296000L);
        scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)content));
        scene.idle(25);
        scene.world().moveSection(tankLink, util.vector().of(0.0, 0.0, 1.0), 10);
        scene.idle(5);
        scene.world().setKineticSpeed(pump, 0.0f);
        scene.world().showSection(pipe, class_2350.field_11034);
        scene.world().modifyBlock(pumpPos, s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11035), false);
        scene.idle(10);
        scene.world().showSection(largeCog1, class_2350.field_11036);
        scene.world().showSection(kinetics1, class_2350.field_11039);
        scene.idle(10);
        scene.world().setBlock(util.grid().at(1, -1, 5), AllBlocks.FLUID_TANK.getDefaultState(), false);
        scene.world().setKineticSpeed(pump, -32.0f);
        scene.idle(5);
        scene.world().propagatePipeChange(pumpPos);
        scene.world().modifyBlockEntity(util.grid().at(2, 0, 5), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)content));
        scene.idle(20);
        for (i = 0; i < 4; ++i) {
            scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> TransferUtil.extractAnyFluid((Storage)be.getTankInventory(), (long)162000L));
            scene.idle(5);
        }
        scene.overlay().showText(60).text("Pipe networks can push and pull fluids from any side").attachKeyFrame().placeNearTarget().pointAt(util.vector().centerOf(1, 1, 2));
        scene.idle(40);
        scene.world().modifyBlock(pumpPos, s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11043), true);
        scene.world().propagatePipeChange(pumpPos);
        for (i = 0; i < 4; ++i) {
            scene.world().modifyBlockEntity(tankPos, FluidTankBlockEntity.class, be -> TransferUtil.insert((Storage)be.getTankInventory(), (Object)content.getType(), (long)162000L));
            scene.idle(5);
        }
        scene.idle(40);
        scene.world().hideSection(largeCog1, class_2350.field_11033);
        scene.world().hideSection(kinetics1, class_2350.field_11035);
        scene.world().hideSection(pipe, class_2350.field_11039);
        scene.idle(10);
        scene.world().showSection(comparatorStuff, class_2350.field_11035);
        scene.idle(5);
        scene.world().moveSection(tankLink, util.vector().of(-1.0, 0.0, 0.0), 10);
        scene.idle(10);
        scene.world().toggleRedstonePower(comparatorStuff);
        scene.world().modifyBlockEntityNBT(util.select().position(2, 1, 0), NixieTubeBlockEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 15));
        scene.overlay().showText(50).text("The contained fluid can be measured by a Comparator").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(2, 1, 1), class_2350.field_11033).method_1031(0.0, 0.125, 0.0));
        scene.idle(50);
        scene.world().hideSection(comparatorStuff, class_2350.field_11034);
        scene.idle(20);
        class_1799 bucket = new class_1799((class_1935)class_1802.field_8550, 1);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043), Pointing.RIGHT, 40).showing((ScreenElement)AllIcons.I_MTD_CLOSE).withItem(bucket);
        scene.idle(7);
        scene.overlay().showOutlineWithText(util.select().fromTo(2, 1, 2, 2, 2, 2), 70).text("However, in Survival Mode Fluids cannot be added or taken manually").attachKeyFrame().colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11039));
        scene.idle(80);
        scene.world().modifyBlockEntity(util.grid().at(4, 3, 0), SpoutBlockEntity.class, be -> TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)content));
        scene.world().moveSection(tankLink, util.vector().of(0.0, 0.0, 1.0), 7);
        scene.world().multiplyKineticSpeed(spoutstuff, -1.0f);
        scene.world().multiplyKineticSpeed(largeCog2, -1.0f);
        scene.idle(7);
        ElementLink spoutLink = scene.world().showIndependentSection(spoutstuff, class_2350.field_11035);
        ElementLink largeCogLink = scene.world().showIndependentSection(largeCog2, class_2350.field_11036);
        scene.world().moveSection(spoutLink, util.vector().of(-1.0, 0.0, 1.0), 0);
        scene.world().moveSection(largeCogLink, util.vector().of(-1.0, 0.0, 1.0), 0);
        scene.idle(20);
        scene.overlay().showOutline(PonderPalette.GREEN, new Object(), util.select().position(2, 1, 1), 50);
        scene.idle(5);
        scene.overlay().showOutline(PonderPalette.GREEN, new Object(), util.select().position(3, 3, 1), 50);
        scene.idle(5);
        scene.overlay().showText(80).text("You can use Basins, Item Drains and Spouts to drain or fill fluid containing items").attachKeyFrame().colored(PonderPalette.GREEN).placeNearTarget().pointAt(util.vector().topOf(2, 1, 1));
        scene.idle(90);
        class_1799 chocBucket = ((SimpleFlowableFluid.Flowing)AllFluids.CHOCOLATE.get()).method_15774().method_7854();
        scene.world().createItemOnBeltLike(util.grid().at(3, 1, 0), class_2350.field_11039, chocBucket);
        scene.idle(40);
        scene.world().modifyBlockEntityNBT(util.select().position(util.grid().at(4, 3, 0)), SpoutBlockEntity.class, nbt -> nbt.method_10569("ProcessingTicks", 20));
        scene.idle(20);
        scene.world().removeItemsFromBelt(util.grid().at(4, 1, 0));
        scene.world().createItemOnBeltLike(util.grid().at(4, 1, 0), class_2350.field_11036, chocBucket);
        for (int i2 = 0; i2 < 10; ++i2) {
            scene.effects().emitParticles(util.vector().topOf(3, 1, 1).method_1031(0.0, 0.0625, 0.0), scene.effects().simpleParticleEmitter(FluidFX.getFluidParticle(content), VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)random, (float)0.1f)), 1.0f, 1);
        }
    }

    public static void sizes(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("fluid_tank_sizes", "Dimensions of a Fluid tank");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.9f);
        scene.showBasePlate();
        scene.idle(5);
        Selection single = util.select().position(0, 3, 0);
        Selection single2 = util.select().fromTo(1, 2, 1, 0, 2, 0);
        Selection single3 = util.select().fromTo(2, 1, 0, 0, 1, 2);
        ElementLink s1 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s1, util.vector().of(2.0, -2.0, 2.0), 0);
        scene.idle(10);
        scene.overlay().showText(60).text("Fluid Tanks can be combined to increase the total capacity").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(2, 1, 2));
        scene.idle(40);
        ElementLink s2 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s2, util.vector().of(2.0, -2.0, 3.0), 0);
        scene.idle(5);
        ElementLink s3 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s3, util.vector().of(3.0, -2.0, 3.0), 0);
        scene.idle(5);
        ElementLink s4 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s4, util.vector().of(3.0, -2.0, 2.0), 0);
        scene.idle(10);
        scene.world().moveSection(s1, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.world().moveSection(s2, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.world().moveSection(s3, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.world().moveSection(s4, util.vector().of(0.0, -100.0, 0.0), 0);
        ElementLink d = scene.world().showIndependentSectionImmediately(single2);
        scene.world().moveSection(d, util.vector().of(2.0, -1.0, 2.0), 0);
        scene.effects().indicateSuccess(util.grid().at(2, 1, 2));
        scene.effects().indicateSuccess(util.grid().at(3, 1, 2));
        scene.effects().indicateSuccess(util.grid().at(2, 1, 3));
        scene.effects().indicateSuccess(util.grid().at(3, 1, 3));
        scene.world().hideIndependentSection(s1, class_2350.field_11033);
        scene.world().hideIndependentSection(s2, class_2350.field_11033);
        scene.world().hideIndependentSection(s3, class_2350.field_11033);
        scene.world().hideIndependentSection(s4, class_2350.field_11033);
        scene.idle(25);
        scene.overlay().showText(60).text("Their base square can be up to 3 blocks wide...").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(2, 1, 2));
        scene.idle(40);
        s1 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s1, util.vector().of(2.0, -2.0, 4.0), 0);
        scene.idle(3);
        s2 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s2, util.vector().of(3.0, -2.0, 4.0), 0);
        scene.idle(3);
        s3 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s3, util.vector().of(4.0, -2.0, 4.0), 0);
        scene.idle(3);
        s4 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s4, util.vector().of(4.0, -2.0, 3.0), 0);
        scene.idle(3);
        ElementLink s5 = scene.world().showIndependentSection(single, class_2350.field_11033);
        scene.world().moveSection(s5, util.vector().of(4.0, -2.0, 2.0), 0);
        scene.idle(10);
        scene.world().moveSection(d, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.world().moveSection(s1, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.world().moveSection(s2, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.world().moveSection(s3, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.world().moveSection(s4, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.world().moveSection(s5, util.vector().of(0.0, -100.0, 0.0), 0);
        ElementLink t = scene.world().showIndependentSectionImmediately(single3);
        scene.world().moveSection(t, util.vector().of(2.0, 0.0, 2.0), 0);
        for (int i = 2; i < 5; ++i) {
            for (int j = 2; j < 5; ++j) {
                scene.effects().indicateSuccess(util.grid().at(i, 1, j));
            }
        }
        scene.world().hideIndependentSection(d, class_2350.field_11033);
        scene.world().hideIndependentSection(s1, class_2350.field_11033);
        scene.world().hideIndependentSection(s2, class_2350.field_11033);
        scene.world().hideIndependentSection(s3, class_2350.field_11033);
        scene.world().hideIndependentSection(s4, class_2350.field_11033);
        scene.world().hideIndependentSection(s5, class_2350.field_11033);
        scene.idle(25);
        scene.world().hideIndependentSection(t, class_2350.field_11033);
        scene.idle(10);
        Selection full1 = util.select().fromTo(5, 1, 0, 5, 6, 0);
        Selection full2 = util.select().fromTo(4, 1, 1, 3, 6, 2);
        Selection full3 = util.select().fromTo(0, 6, 5, 2, 1, 3);
        scene.world().showSection(full1, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(full2, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(full3, class_2350.field_11033);
        scene.idle(10);
        class_243 blockSurface = util.vector().blockSurface(util.grid().at(3, 3, 1), class_2350.field_11039);
        scene.overlay().showText(60).text("...and grow in height by more than 30 additional layers").attachKeyFrame().placeNearTarget().pointAt(blockSurface);
        scene.idle(70);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(3, 3, 1), class_2350.field_11043), Pointing.RIGHT, 60).rightClick().withItem(AllItems.WRENCH.asStack());
        scene.idle(7);
        scene.world().modifyBlocks(full2, s -> (class_2680)s.method_11657(FluidTankBlock.SHAPE, (Comparable)((Object)FluidTankBlock.Shape.PLAIN)), false);
        scene.idle(30);
        scene.overlay().showText(60).text("Using a Wrench, a tanks' window can be toggled").attachKeyFrame().placeNearTarget().pointAt(blockSurface);
        scene.idle(50);
    }

    public static void creative(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("creative_fluid_tank", "Creative Fluid Tanks");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Selection largeCog = util.select().position(5, 0, 2);
        Selection cTank = util.select().fromTo(3, 1, 1, 3, 2, 1);
        Selection tank = util.select().fromTo(1, 1, 3, 1, 3, 3);
        Selection pipes = util.select().fromTo(3, 1, 2, 2, 1, 3);
        Selection cog = util.select().position(4, 1, 2);
        class_2338 cTankPos = util.grid().at(3, 1, 1);
        class_2338 pumpPos = util.grid().at(3, 1, 2);
        ElementLink cTankLink = scene.world().showIndependentSection(cTank, class_2350.field_11033);
        scene.world().moveSection(cTankLink, util.vector().of(-1.0, 0.0, 1.0), 0);
        scene.overlay().showText(70).text("Creative Fluid Tanks can be used to provide a bottomless supply of fluid").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11039));
        scene.idle(80);
        class_1799 bucket = new class_1799((class_1935)class_1802.field_8187);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043), Pointing.RIGHT, 40).rightClick().withItem(bucket);
        scene.idle(7);
        scene.world().modifyBlockEntity(cTankPos, CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack((class_3611)class_3612.field_15908, 81000L)));
        scene.idle(5);
        scene.overlay().showText(50).text("Right-Click with a fluid containing item to configure it").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11039));
        scene.idle(60);
        scene.world().moveSection(cTankLink, util.vector().of(1.0, 0.0, -1.0), 6);
        scene.idle(7);
        scene.world().showSection(tank, class_2350.field_11033);
        scene.idle(5);
        scene.rotateCameraY(-30.0f);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.world().showSection(cog, class_2350.field_11043);
        scene.world().showSection(pipes, class_2350.field_11043);
        scene.world().modifyBlock(pumpPos, s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11035), false);
        scene.world().propagatePipeChange(pumpPos);
        scene.idle(40);
        scene.overlay().showText(70).text("Pipe Networks can now endlessly draw the assigned fluid from the tank").attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(3, 1, 2), class_2350.field_11039));
        scene.idle(120);
        scene.world().modifyBlock(pumpPos, s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11043), true);
        scene.world().propagatePipeChange(pumpPos);
        scene.idle(40);
        scene.overlay().showText(70).text("Any Fluids pushed back into a Creative Fluid Tank will be voided").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 1, 2), class_2350.field_11039));
        scene.idle(40);
    }
}

