/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.display;

import com.google.gson.JsonElement;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayBlock;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import com.simibubi.create.content.trains.display.FlapDisplaySection;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.DyeHelper;
import com.simibubi.create.foundation.utility.DynamicComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class FlapDisplayBlockEntity
extends KineticBlockEntity {
    public List<FlapDisplayLayout> lines;
    public boolean isController;
    public boolean isRunning;
    public int xSize;
    public int ySize;
    public class_1767[] colour;
    public boolean[] glowingLines;
    public boolean[] manualLines;

    public FlapDisplayBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.isController = false;
        this.xSize = 1;
        this.ySize = 1;
        this.colour = new class_1767[2];
        this.manualLines = new boolean[2];
        this.glowingLines = new boolean[2];
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.updateControllerStatus();
    }

    public void updateControllerStatus() {
        if (this.field_11863.field_9236) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof FlapDisplayBlock)) {
            return;
        }
        class_2350 leftDirection = ((class_2350)blockState.method_11654(FlapDisplayBlock.HORIZONTAL_FACING)).method_10170();
        boolean shouldBeController = (Boolean)blockState.method_11654((class_2769)FlapDisplayBlock.UP) == false && this.field_11863.method_8320(this.field_11867.method_10093(leftDirection)) != blockState;
        int newXSize = 1;
        int newYSize = 1;
        if (shouldBeController) {
            for (int xOffset = 1; xOffset < 32 && this.field_11863.method_8320(this.field_11867.method_10079(leftDirection.method_10153(), xOffset)) == blockState; ++xOffset) {
                ++newXSize;
            }
            for (int yOffset = 0; yOffset < 32 && this.field_11863.method_8320(this.field_11867.method_10079(class_2350.field_11033, yOffset)).method_28500((class_2769)FlapDisplayBlock.DOWN).orElse(false).booleanValue(); ++yOffset) {
                ++newYSize;
            }
        }
        if (this.isController == shouldBeController && newXSize == this.xSize && newYSize == this.ySize) {
            return;
        }
        this.isController = shouldBeController;
        this.xSize = newXSize;
        this.ySize = newYSize;
        this.colour = Arrays.copyOf(this.colour, this.ySize * 2);
        this.glowingLines = Arrays.copyOf(this.glowingLines, this.ySize * 2);
        this.manualLines = new boolean[this.ySize * 2];
        this.lines = null;
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.isRunning = super.isSpeedRequirementFulfilled();
        if (!(this.field_11863.field_9236 && this.isRunning || this.isVirtual())) {
            return;
        }
        int activeFlaps = 0;
        boolean instant = Math.abs(this.getSpeed()) > 128.0f;
        for (FlapDisplayLayout line : this.lines) {
            for (FlapDisplaySection section : line.getSections()) {
                activeFlaps += section.tick(instant);
            }
        }
        if (activeFlaps == 0) {
            return;
        }
        float volume = class_3532.method_15363((float)((float)activeFlaps / 20.0f), (float)0.25f, (float)1.5f);
        float bgVolume = class_3532.method_15363((float)((float)activeFlaps / 40.0f), (float)0.25f, (float)1.0f);
        class_2338 middle = this.field_11867.method_10079(this.getDirection().method_10170(), this.xSize / 2).method_10079(class_2350.field_11033, this.ySize / 2);
        AllSoundEvents.SCROLL_VALUE.playAt(this.field_11863, (class_2382)middle, volume, 0.56f, false);
        this.field_11863.method_8486((double)middle.method_10263(), (double)middle.method_10264(), (double)middle.method_10260(), class_3417.field_26951, class_3419.field_15245, 0.35f * bgVolume, 1.95f, false);
    }

    @Override
    protected boolean isNoisy() {
        return false;
    }

    @Override
    public boolean isSpeedRequirementFulfilled() {
        return this.isRunning;
    }

    public void applyTextManually(int lineIndex, String rawComponentText) {
        List<FlapDisplayLayout> lines = this.getLines();
        if (lineIndex >= lines.size()) {
            return;
        }
        FlapDisplayLayout layout = lines.get(lineIndex);
        if (!layout.isLayout("Default")) {
            layout.loadDefault(this.getMaxCharCount());
        }
        List<FlapDisplaySection> sections = layout.getSections();
        FlapDisplaySection flapDisplaySection = sections.get(0);
        if (rawComponentText == null) {
            this.manualLines[lineIndex] = false;
            flapDisplaySection.setText(class_5244.field_39003);
            this.notifyUpdate();
            return;
        }
        JsonElement json = DynamicComponent.getJsonFromString(rawComponentText);
        if (json == null) {
            return;
        }
        this.manualLines[lineIndex] = true;
        class_5250 text = this.isVirtual() ? class_2561.class_2562.method_10877((String)rawComponentText) : DynamicComponent.parseCustomText(this.field_11863, this.field_11867, json);
        flapDisplaySection.setText((class_2561)text);
        if (this.isVirtual()) {
            flapDisplaySection.refresh(true);
        } else {
            this.notifyUpdate();
        }
    }

    public void setColour(int lineIndex, class_1767 color) {
        this.colour[lineIndex] = color == class_1767.field_7952 ? null : color;
        this.notifyUpdate();
    }

    public void setGlowing(int lineIndex) {
        this.glowingLines[lineIndex] = true;
        this.notifyUpdate();
    }

    public List<FlapDisplayLayout> getLines() {
        if (this.lines == null) {
            this.initDefaultSections();
        }
        return this.lines;
    }

    public void initDefaultSections() {
        this.lines = new ArrayList<FlapDisplayLayout>();
        for (int i = 0; i < this.ySize * 2; ++i) {
            this.lines.add(new FlapDisplayLayout(this.getMaxCharCount()));
        }
    }

    public int getMaxCharCount() {
        return this.getMaxCharCount(0);
    }

    public int getMaxCharCount(int gaps) {
        return (int)(((float)this.xSize * 16.0f - 2.0f - 4.0f * (float)gaps) / 3.5f);
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        int j;
        super.write(tag, clientPacket);
        tag.method_10556("Controller", this.isController);
        tag.method_10569("XSize", this.xSize);
        tag.method_10569("YSize", this.ySize);
        for (j = 0; j < this.manualLines.length; ++j) {
            if (!this.manualLines[j]) continue;
            NBTHelper.putMarker((class_2487)tag, (String)("CustomLine" + j));
        }
        for (j = 0; j < this.glowingLines.length; ++j) {
            if (!this.glowingLines[j]) continue;
            NBTHelper.putMarker((class_2487)tag, (String)("GlowingLine" + j));
        }
        for (j = 0; j < this.colour.length; ++j) {
            if (this.colour[j] == null) continue;
            NBTHelper.writeEnum((class_2487)tag, (String)("Dye" + j), (Enum)this.colour[j]);
        }
        List<FlapDisplayLayout> lines = this.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            tag.method_10566("Display" + i, (class_2520)lines.get(i).write());
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        int i;
        super.read(tag, clientPacket);
        boolean wasActive = this.isController;
        int prevX = this.xSize;
        int prevY = this.ySize;
        this.isController = tag.method_10577("Controller");
        this.xSize = tag.method_10550("XSize");
        this.ySize = tag.method_10550("YSize");
        this.manualLines = new boolean[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.manualLines[i] = tag.method_10545("CustomLine" + i);
        }
        this.glowingLines = new boolean[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.glowingLines[i] = tag.method_10545("GlowingLine" + i);
        }
        this.colour = new class_1767[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.colour[i] = tag.method_10545("Dye" + i) ? (class_1767)NBTHelper.readEnum((class_2487)tag, (String)("Dye" + i), class_1767.class) : null;
        }
        if (clientPacket && wasActive != this.isController || prevX != this.xSize || prevY != this.ySize) {
            this.invalidateRenderBoundingBox();
            this.lines = null;
        }
        List<FlapDisplayLayout> lines = this.getLines();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            lines.get(i2).read(tag.method_10562("Display" + i2));
        }
    }

    public int getLineIndexAt(double yCoord) {
        return (int)class_3532.method_15350((double)Math.floor(2.0 * ((double)this.field_11867.method_10264() - yCoord + 1.0)), (double)0.0, (double)(this.ySize * 2));
    }

    public FlapDisplayBlockEntity getController() {
        if (this.isController) {
            return this;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof FlapDisplayBlock)) {
            return null;
        }
        class_2338.class_2339 pos = this.method_11016().method_25503();
        class_2350 side = ((class_2350)blockState.method_11654(FlapDisplayBlock.HORIZONTAL_FACING)).method_10170();
        for (int i = 0; i < 64; ++i) {
            class_2680 other = this.field_11863.method_8320((class_2338)pos);
            if (other.method_28500((class_2769)FlapDisplayBlock.UP).orElse(false).booleanValue()) {
                pos.method_10098(class_2350.field_11036);
                continue;
            }
            if (!this.field_11863.method_8320(pos.method_10093(side)).method_28500((class_2769)FlapDisplayBlock.UP).orElse(true).booleanValue()) {
                pos.method_10098(side);
                continue;
            }
            class_2586 found = this.field_11863.method_8321((class_2338)pos);
            if (!(found instanceof FlapDisplayBlockEntity)) break;
            FlapDisplayBlockEntity flap = (FlapDisplayBlockEntity)found;
            if (!flap.isController) break;
            return flap;
        }
        return null;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        class_238 aabb = new class_238(this.field_11867);
        if (!this.isController) {
            return aabb;
        }
        class_2382 normal = this.getDirection().method_10170().method_10163();
        return aabb.method_1012((double)(normal.method_10263() * this.xSize), (double)(-this.ySize), (double)(normal.method_10260() * this.xSize));
    }

    public class_2350 getDirection() {
        return this.method_11010().method_28500(FlapDisplayBlock.HORIZONTAL_FACING).orElse(class_2350.field_11035).method_10153();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public int getLineColor(int line) {
        class_1767 color = this.colour[line];
        return color == null ? -2898246 : (Integer)DyeHelper.getDyeColors(color).getFirst() | 0xFF000000;
    }

    public boolean isLineGlowing(int line) {
        return this.glowingLines[line];
    }
}

