/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.tableCloth;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.redstoneRequester.AutoRequestData;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.ShopUpdatePacket;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlock;
import com.simibubi.create.content.logistics.tableCloth.TableClothFilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.RemoveBlockEntityPacket;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;

public class TableClothBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public AbstractComputerBehaviour computerBehaviour;
    public AutoRequestData requestData;
    public List<class_1799> manuallyAddedItems = new ArrayList<class_1799>();
    public UUID owner = null;
    public class_2350 facing;
    public boolean sideOccluded;
    public FilteringBehaviour priceTag;
    private List<class_1799> renderedItemsForShop;

    public TableClothBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.requestData = new AutoRequestData();
        this.facing = class_2350.field_11035;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.priceTag = new TableClothFilteringBehaviour(this);
        behaviours.add(this.priceTag);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    public List<class_1799> getItemsForRender() {
        if (this.isShop()) {
            if (this.renderedItemsForShop == null) {
                this.renderedItemsForShop = this.requestData.encodedRequest.stacks().stream().map(b -> b.stack).limit(4L).toList();
            }
            return this.renderedItemsForShop;
        }
        return this.manuallyAddedItems;
    }

    public void invalidateItemsForRender() {
        this.renderedItemsForShop = null;
    }

    public void notifyShopUpdate() {
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ShopUpdatePacket(this.field_11867), (class_2586)this);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        class_2338 relativePos = this.field_11867.method_10093(this.facing);
        this.sideOccluded = AllTags.AllBlockTags.TABLE_CLOTHS.matches(this.field_11863.method_8320(relativePos)) || class_2248.method_9501((class_265)this.field_11863.method_8320(relativePos.method_10074()).method_26201((class_1922)this.field_11863, relativePos.method_10074()), (class_2350)this.facing.method_10153());
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(1.0);
    }

    public boolean isShop() {
        return !this.requestData.encodedRequest.isEmpty();
    }

    public class_1269 use(class_1657 player, class_3965 ray) {
        if (this.isShop()) {
            return this.useShop(player);
        }
        class_1799 heldItem = player.method_5998(class_1268.field_5808);
        if (heldItem.method_7960()) {
            if (this.manuallyAddedItems.isEmpty()) {
                return class_1269.field_5812;
            }
            player.method_6122(class_1268.field_5808, this.manuallyAddedItems.remove(this.manuallyAddedItems.size() - 1));
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14770, class_3419.field_15245, 0.5f, 1.0f);
            if (this.manuallyAddedItems.isEmpty() && !this.computerBehaviour.hasAttachedComputer()) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)TableClothBlock.HAS_BE, (Comparable)Boolean.valueOf(false)), 3);
                AllPackets.getChannel().sendToClientsTracking((S2CPacket)new RemoveBlockEntityPacket(this.field_11867), (class_2586)this);
            } else {
                this.notifyUpdate();
            }
            return class_1269.field_5812;
        }
        if (this.manuallyAddedItems.size() >= 4) {
            return class_1269.field_5812;
        }
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14667, class_3419.field_15245, 0.5f, 1.0f);
        this.manuallyAddedItems.add(heldItem.method_46651(1));
        this.facing = player.method_5735().method_10153();
        heldItem.method_7934(1);
        if (heldItem.method_7960()) {
            player.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        this.notifyUpdate();
        return class_1269.field_5812;
    }

    public boolean targetsPriceTag(class_1657 player, class_3965 ray) {
        return this.priceTag != null && this.priceTag.mayInteract(player) && this.priceTag.getSlotPositioning().testHit((class_1936)this.field_11863, this.field_11867, this.method_11010(), ray.method_17784().method_1020(class_243.method_24954((class_2382)this.field_11867)));
    }

    public class_1269 useShop(class_1657 player) {
        StockTickerBlockEntity stbe;
        class_1799 itemInHand = player.method_5998(class_1268.field_5808);
        class_1799 prevListItem = class_1799.field_8037;
        boolean addOntoList = false;
        for (int i = 0; i < 9; ++i) {
            class_1799 item = player.method_31548().method_5438(i);
            if (!AllItems.SHOPPING_LIST.isIn(item)) continue;
            prevListItem = item;
            addOntoList = true;
            player.method_31548().method_5447(i, class_1799.field_8037);
        }
        if (AllItems.SHOPPING_LIST.isIn(itemInHand)) {
            prevListItem = itemInHand;
            addOntoList = true;
        }
        if (!itemInHand.method_7960() && !addOntoList) {
            CreateLang.translate("stock_keeper.shopping_list_empty_hand", new Object[0]).sendStatus(player);
            AllSoundEvents.DENY.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            return class_1269.field_5812;
        }
        if (this.getPaymentItem().method_7960()) {
            CreateLang.translate("stock_keeper.no_price_set", new Object[0]).sendStatus(player);
            AllSoundEvents.DENY.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            return class_1269.field_5812;
        }
        UUID tickerID = null;
        class_2338 tickerPos = this.requestData.targetOffset.method_10081((class_2382)this.field_11867);
        class_2586 class_25862 = this.field_11863.method_8321(tickerPos);
        if (class_25862 instanceof StockTickerBlockEntity && (stbe = (StockTickerBlockEntity)class_25862).isKeeperPresent()) {
            tickerID = stbe.behaviour.freqId;
        }
        int stockLevel = this.getStockLevelForTrade(ShoppingListItem.getList(prevListItem));
        if (tickerID == null) {
            CreateLang.translate("stock_keeper.keeper_missing", new Object[0]).style(class_124.field_1061).sendStatus(player);
            AllSoundEvents.DENY.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            return class_1269.field_5812;
        }
        if (stockLevel == 0) {
            CreateLang.translate("stock_keeper.out_of_stock", new Object[0]).style(class_124.field_1061).sendStatus(player);
            AllSoundEvents.DENY.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            if (!prevListItem.method_7960()) {
                if (player.method_5998(class_1268.field_5808).method_7960()) {
                    player.method_6122(class_1268.field_5808, prevListItem);
                } else {
                    player.method_31548().method_7398(prevListItem);
                }
            }
            return class_1269.field_5812;
        }
        Object list = new ShoppingListItem.ShoppingList(new ArrayList<IntAttached<class_2338>>(), this.owner, tickerID);
        if (addOntoList) {
            ShoppingListItem.ShoppingList prevList = ShoppingListItem.getList(prevListItem);
            if (this.owner.equals(prevList.shopOwner()) && tickerID.equals(prevList.shopNetwork())) {
                list = prevList;
            } else {
                addOntoList = false;
            }
        }
        if (((ShoppingListItem.ShoppingList)list).getPurchases(this.field_11867) >= stockLevel) {
            for (IntAttached intAttached : ((ShoppingListItem.ShoppingList)list).purchases()) {
                if (!this.field_11867.equals(intAttached.getValue())) continue;
                intAttached.setFirst((Object)Math.min(stockLevel, (Integer)intAttached.getFirst()));
            }
            CreateLang.translate("stock_keeper.limited_stock", new Object[0]).style(class_124.field_1061).sendStatus(player);
        } else {
            AllSoundEvents.CONFIRM_2.playOnServer(this.field_11863, (class_2382)this.field_11867, 0.5f, 1.0f);
            ((ShoppingListItem.ShoppingList)list).addPurchases(this.field_11867, 1);
            if (!addOntoList) {
                CreateLang.translate("stock_keeper.use_list_to_add_purchases", new Object[0]).color(0xEEEEEE).sendStatus(player);
            }
            if (!addOntoList) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_17481, class_3419.field_15245, 1.0f, 1.5f);
            }
        }
        class_1799 newListItem = ShoppingListItem.saveList(AllItems.SHOPPING_LIST.asStack(), (ShoppingListItem.ShoppingList)list, this.requestData.encodedTargetAdress);
        if (player.method_5998(class_1268.field_5808).method_7960()) {
            player.method_6122(class_1268.field_5808, newListItem);
        } else {
            player.method_31548().method_7398(newListItem);
        }
        return class_1269.field_5812;
    }

    public int getStockLevelForTrade(@Nullable ShoppingListItem.ShoppingList otherPurchases) {
        class_2338 tickerPos = this.requestData.targetOffset.method_10081((class_2382)this.field_11867);
        class_2586 class_25862 = this.field_11863.method_8321(tickerPos);
        if (!(class_25862 instanceof StockTickerBlockEntity)) {
            return 0;
        }
        StockTickerBlockEntity stbe = (StockTickerBlockEntity)class_25862;
        InventorySummary recentSummary = null;
        if (this.field_11863.method_8608()) {
            if (stbe.getTicksSinceLastUpdate() > 15) {
                stbe.refreshClientStockSnapshot();
            }
            recentSummary = stbe.getLastClientsideStockSnapshotAsSummary();
        } else {
            recentSummary = stbe.getRecentSummary();
        }
        if (recentSummary == null) {
            return 0;
        }
        InventorySummary modifierSummary = new InventorySummary();
        if (otherPurchases != null) {
            modifierSummary = (InventorySummary)otherPurchases.bakeEntries((class_1936)this.field_11863, this.field_11867).getFirst();
        }
        int smallestQuotient = Integer.MAX_VALUE;
        for (BigItemStack entry : this.requestData.encodedRequest.stacks()) {
            if (entry.count <= 0) continue;
            smallestQuotient = Math.min(smallestQuotient, (recentSummary.getCountOf(entry.stack) - modifierSummary.getCountOf(entry.stack)) / entry.count);
        }
        return smallestQuotient;
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10566("Items", (class_2520)NBTHelper.writeItemList(this.manuallyAddedItems));
        tag.method_10569("Facing", this.facing.method_10161());
        this.requestData.write(tag);
        if (this.owner != null) {
            tag.method_25927("OwnerUUID", this.owner);
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.manuallyAddedItems = NBTHelper.readItemList((class_2499)tag.method_10554("Items", 10));
        this.requestData = AutoRequestData.read(tag);
        this.owner = tag.method_10545("OwnerUUID") ? tag.method_25926("OwnerUUID") : null;
        this.facing = class_2350.method_10139((int)class_3532.method_15387((int)tag.method_10550("Facing"), (int)4));
    }

    @Override
    public void destroy() {
        super.destroy();
        this.manuallyAddedItems.forEach(stack -> class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)stack));
        this.manuallyAddedItems.clear();
    }

    public class_1799 getPaymentItem() {
        return this.priceTag.getFilter();
    }

    public int getPaymentAmount() {
        return this.priceTag.getFilter().method_7960() ? 1 : this.priceTag.count;
    }

    @Override
    public void transform(class_2586 blockEntity, StructureTransform transform) {
        this.facing = transform.mirrorFacing(this.facing);
        if (transform.rotationAxis == class_2350.class_2351.field_11052) {
            this.facing = transform.rotateFacing(this.facing);
        }
        this.notifyUpdate();
    }
}

