/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagePort;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlock;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public abstract class PackagePortTarget {
    public class_2338 relativePos;
    private String typeKey;

    public PackagePortTarget(String typeKey, class_2338 relativePos) {
        this.typeKey = typeKey;
        this.relativePos = relativePos;
    }

    public abstract boolean export(class_1936 var1, class_2338 var2, class_1799 var3, boolean var4);

    public void setup(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
    }

    public void register(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
    }

    public void deregister(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
    }

    public abstract class_243 getExactTargetLocation(PackagePortBlockEntity var1, class_1936 var2, class_2338 var3);

    public abstract class_1799 getIcon();

    public abstract boolean canSupport(class_2586 var1);

    public boolean depositImmediately() {
        return false;
    }

    public class_2487 write() {
        class_2487 compoundTag = new class_2487();
        this.writeInternal(compoundTag);
        compoundTag.method_10582("Type", this.typeKey);
        compoundTag.method_10566("RelativePos", (class_2520)class_2512.method_10692((class_2338)this.relativePos));
        return compoundTag;
    }

    public static PackagePortTarget read(class_2487 tag) {
        PackagePortTarget target;
        if (tag.method_33133()) {
            return null;
        }
        class_2338 relativePos = class_2512.method_10691((class_2487)tag.method_10562("RelativePos"));
        switch (tag.method_10558("Type")) {
            case "ChainConveyor": {
                PackagePortTarget packagePortTarget = new ChainConveyorFrogportTarget(relativePos, 0.0f, null);
                break;
            }
            case "TrainStation": {
                PackagePortTarget packagePortTarget = new TrainStationFrogportTarget(relativePos);
                break;
            }
            default: {
                PackagePortTarget packagePortTarget = target = null;
            }
        }
        if (target == null) {
            return null;
        }
        target.readInternal(tag);
        return target;
    }

    protected abstract void writeInternal(class_2487 var1);

    protected abstract void readInternal(class_2487 var1);

    public class_2586 be(class_1936 level, class_2338 portPos) {
        class_1937 l;
        if (level instanceof class_1937 && !(l = (class_1937)level).method_8477(portPos.method_10081((class_2382)this.relativePos))) {
            return null;
        }
        return level.method_8321(portPos.method_10081((class_2382)this.relativePos));
    }

    public static class ChainConveyorFrogportTarget
    extends PackagePortTarget {
        public float chainPos;
        public class_2338 connection;
        public boolean flipped;

        public ChainConveyorFrogportTarget(class_2338 relativePos, float chainPos, @Nullable class_2338 connection) {
            super("ChainConveyor", relativePos);
            this.chainPos = chainPos;
            this.connection = connection;
        }

        @Override
        public void setup(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            class_2586 class_25862 = this.be(level, portPos);
            if (class_25862 instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)class_25862;
                this.flipped = clbe.getSpeed() < 0.0f;
            }
        }

        @Override
        public class_1799 getIcon() {
            return AllBlocks.CHAIN_CONVEYOR.asStack();
        }

        @Override
        public boolean export(class_1936 level, class_2338 portPos, class_1799 box, boolean simulate) {
            class_2586 class_25862 = this.be(level, portPos);
            if (!(class_25862 instanceof ChainConveyorBlockEntity)) {
                return false;
            }
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)class_25862;
            if (this.connection != null && !clbe.connections.contains(this.connection)) {
                return false;
            }
            if (simulate) {
                return clbe.getSpeed() != 0.0f && clbe.canAcceptPackagesFor(this.connection);
            }
            ChainConveyorPackage box2 = new ChainConveyorPackage(this.chainPos, box.method_7972());
            if (this.connection == null) {
                return clbe.addLoopingPackage(box2);
            }
            return clbe.addTravellingPackage(box2, this.connection);
        }

        @Override
        public void register(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            class_2586 class_25862 = this.be(level, portPos);
            if (!(class_25862 instanceof ChainConveyorBlockEntity)) {
                return;
            }
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)class_25862;
            ChainConveyorBlockEntity actualBe = clbe;
            if (this.connection != null && clbe.getSpeed() < 0.0f != this.flipped) {
                this.deregister(ppbe, level, portPos);
                actualBe = (ChainConveyorBlockEntity)((ChainConveyorBlock)AllBlocks.CHAIN_CONVEYOR.get()).getBlockEntity((class_1922)level, clbe.method_11016().method_10081((class_2382)this.connection));
                if (actualBe == null) {
                    return;
                }
                clbe.prepareStats();
                ChainConveyorBlockEntity.ConnectionStats stats = clbe.connectionStats.get(this.connection);
                if (stats != null) {
                    this.chainPos = stats.chainLength() - this.chainPos;
                }
                this.connection = this.connection.method_35830(-1);
                this.flipped = !this.flipped;
                this.relativePos = actualBe.method_11016().method_10059((class_2382)portPos);
                ppbe.notifyUpdate();
            }
            if (this.connection != null && !actualBe.connections.contains(this.connection)) {
                return;
            }
            String portFilter = ppbe.getFilterString();
            if (portFilter == null) {
                return;
            }
            actualBe.routingTable.receivePortInfo(portFilter, this.connection == null ? class_2338.field_10980 : this.connection);
            Map<class_2338, ChainConveyorBlockEntity.ConnectedPort> portMap = this.connection == null ? actualBe.loopPorts : actualBe.travelPorts;
            portMap.put(this.relativePos.method_35830(-1), new ChainConveyorBlockEntity.ConnectedPort(this.chainPos, this.connection, portFilter));
        }

        @Override
        public void deregister(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            class_2586 class_25862 = this.be(level, portPos);
            if (!(class_25862 instanceof ChainConveyorBlockEntity)) {
                return;
            }
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)class_25862;
            clbe.loopPorts.remove(this.relativePos.method_35830(-1));
            clbe.travelPorts.remove(this.relativePos.method_35830(-1));
            String portFilter = ppbe.getFilterString();
            if (portFilter == null) {
                return;
            }
            clbe.routingTable.entriesByDistance.removeIf(e -> e.endOfRoute() && e.port().equals(portFilter));
            clbe.routingTable.changed = true;
        }

        @Override
        protected void writeInternal(class_2487 tag) {
            tag.method_10548("ChainPos", this.chainPos);
            if (this.connection != null) {
                tag.method_10566("Connection", (class_2520)class_2512.method_10692((class_2338)this.connection));
                tag.method_10556("Flipped", this.flipped);
            }
        }

        @Override
        protected void readInternal(class_2487 tag) {
            this.chainPos = tag.method_10583("ChainPos");
            if (tag.method_10545("Connection")) {
                this.connection = class_2512.method_10691((class_2487)tag.method_10562("Connection"));
                this.flipped = tag.method_10577("Flipped");
            }
        }

        @Override
        public class_243 getExactTargetLocation(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            class_2586 class_25862 = this.be(level, portPos);
            if (!(class_25862 instanceof ChainConveyorBlockEntity)) {
                return class_243.field_1353;
            }
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)class_25862;
            return clbe.getPackagePosition(this.chainPos, this.connection);
        }

        @Override
        public boolean canSupport(class_2586 be) {
            return AllBlockEntityTypes.PACKAGE_FROGPORT.is(be);
        }
    }

    public static class TrainStationFrogportTarget
    extends PackagePortTarget {
        public TrainStationFrogportTarget(class_2338 relativePos) {
            super("TrainStation", relativePos);
        }

        @Override
        public class_1799 getIcon() {
            return AllBlocks.TRACK_STATION.asStack();
        }

        @Override
        public boolean export(class_1936 level, class_2338 portPos, class_1799 box, boolean simulate) {
            return false;
        }

        @Override
        public class_243 getExactTargetLocation(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            return class_243.method_24953((class_2382)portPos.method_10081((class_2382)this.relativePos));
        }

        @Override
        public void register(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            class_2586 class_25862 = this.be(level, portPos);
            if (class_25862 instanceof StationBlockEntity) {
                StationBlockEntity sbe = (StationBlockEntity)class_25862;
                sbe.attachPackagePort(ppbe);
            }
        }

        @Override
        public void deregister(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            class_2586 class_25862 = this.be(level, portPos);
            if (class_25862 instanceof StationBlockEntity) {
                StationBlockEntity sbe = (StationBlockEntity)class_25862;
                sbe.removePackagePort(ppbe);
            }
        }

        @Override
        public boolean depositImmediately() {
            return true;
        }

        @Override
        protected void writeInternal(class_2487 tag) {
        }

        @Override
        protected void readInternal(class_2487 tag) {
        }

        @Override
        public boolean canSupport(class_2586 be) {
            return AllBlockEntityTypes.PACKAGE_POSTBOX.is(be);
        }
    }
}

