/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3419;

public class FactoryPanelBlockEntity
extends SmartBlockEntity {
    public EnumMap<FactoryPanelBlock.PanelSlot, FactoryPanelBehaviour> panels;
    public boolean redraw;
    public boolean restocker = false;
    public class_265 lastShape;
    public AdvancementBehaviour advancements;

    public FactoryPanelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014(8.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.panels = new EnumMap(FactoryPanelBlock.PanelSlot.class);
        this.redraw = true;
        for (FactoryPanelBlock.PanelSlot slot : FactoryPanelBlock.PanelSlot.values()) {
            FactoryPanelBehaviour e = new FactoryPanelBehaviour(this, slot);
            this.panels.put(slot, e);
            behaviours.add(e);
        }
        this.advancements = new AdvancementBehaviour(this, AllAdvancements.FACTORY_GAUGE);
        behaviours.add(this.advancements);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.activePanels() == 0) {
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
        }
        if (AllBlocks.FACTORY_GAUGE.has(this.method_11010())) {
            boolean shouldBeRestocker = AllBlocks.PACKAGER.has(this.field_11863.method_8320(this.field_11867.method_10093(FactoryPanelBlock.connectedDirection(this.method_11010()).method_10153())));
            if (this.restocker == shouldBeRestocker) {
                return;
            }
            this.restocker = shouldBeRestocker;
            this.redraw = true;
            this.sendData();
        }
    }

    @Nullable
    public PackagerBlockEntity getRestockedPackager() {
        class_2680 state = this.method_11010();
        if (!this.restocker || !AllBlocks.FACTORY_GAUGE.has(state)) {
            return null;
        }
        class_2338 packagerPos = this.field_11867.method_10093(FactoryPanelBlock.connectedDirection(state).method_10153());
        if (!this.field_11863.method_8477(packagerPos)) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(packagerPos);
        if (be == null || !(be instanceof PackagerBlockEntity)) {
            return null;
        }
        PackagerBlockEntity pbe = (PackagerBlockEntity)be;
        if (pbe instanceof RepackagerBlockEntity) {
            return null;
        }
        return pbe;
    }

    public int activePanels() {
        int result = 0;
        for (FactoryPanelBehaviour panelBehaviour : this.panels.values()) {
            if (!panelBehaviour.isActive()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void remove() {
        for (FactoryPanelBehaviour panelBehaviour : this.panels.values()) {
            if (!panelBehaviour.isActive()) continue;
            panelBehaviour.disconnectAll();
        }
        super.remove();
    }

    @Override
    public void destroy() {
        super.destroy();
        int panelCount = this.activePanels();
        if (panelCount > 1) {
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)AllBlocks.FACTORY_GAUGE.asStack(panelCount - 1));
        }
    }

    public boolean addPanel(FactoryPanelBlock.PanelSlot slot, UUID frequency) {
        FactoryPanelBehaviour behaviour = this.panels.get((Object)slot);
        if (behaviour != null && !behaviour.isActive()) {
            behaviour.enable();
            if (frequency != null) {
                behaviour.setNetwork(frequency);
            }
            this.redraw = true;
            this.lastShape = null;
            if (this.activePanels() > 1) {
                class_2498 soundType = this.method_11010().method_26231();
                this.field_11863.method_8396(null, this.field_11867, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean removePanel(FactoryPanelBlock.PanelSlot slot) {
        FactoryPanelBehaviour behaviour = this.panels.get((Object)slot);
        if (behaviour != null && behaviour.isActive()) {
            behaviour.disable();
            this.redraw = true;
            this.lastShape = null;
            if (this.activePanels() > 0) {
                class_2498 soundType = this.method_11010().method_26231();
                this.field_11863.method_8396(null, this.field_11867, soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public class_265 getShape() {
        if (this.lastShape != null) {
            return this.lastShape;
        }
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(this.method_11010()) + 90.0f;
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(this.method_11010());
        class_2350 connectedDirection = FactoryPanelBlock.connectedDirection(this.method_11010());
        class_243 inflateAxes = VecHelper.axisAlingedPlaneOf((class_2350)connectedDirection);
        this.lastShape = class_259.method_1073();
        for (FactoryPanelBehaviour behaviour : this.panels.values()) {
            if (!behaviour.isActive()) continue;
            FactoryPanelPosition panelPosition = behaviour.getPanelPosition();
            class_243 vec = new class_243(0.25 + (double)panelPosition.slot().xOffset * 0.5, 0.0625, 0.25 + (double)panelPosition.slot().yOffset * 0.5);
            vec = VecHelper.rotateCentered((class_243)vec, (double)180.0, (class_2350.class_2351)class_2350.class_2351.field_11052);
            vec = VecHelper.rotateCentered((class_243)vec, (double)xRot, (class_2350.class_2351)class_2350.class_2351.field_11048);
            vec = VecHelper.rotateCentered((class_243)vec, (double)yRot, (class_2350.class_2351)class_2350.class_2351.field_11052);
            class_238 bb = new class_238(vec, vec).method_1014(0.0625).method_1009(inflateAxes.field_1352 * 3.0 / 16.0, inflateAxes.field_1351 * 3.0 / 16.0, inflateAxes.field_1350 * 3.0 / 16.0);
            this.lastShape = class_259.method_1084((class_265)this.lastShape, (class_265)class_259.method_1078((class_238)bb));
        }
        return this.lastShape;
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.restocker = tag.method_10577("Restocker");
        if (clientPacket && tag.method_10545("Redraw")) {
            this.lastShape = null;
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
        }
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("Restocker", this.restocker);
        if (clientPacket && this.redraw) {
            NBTHelper.putMarker((class_2487)tag, (String)"Redraw");
            this.redraw = false;
        }
    }

    @Nullable
    public Object getRenderData() {
        FactoryPanelBlock.PanelType type = this.restocker ? FactoryPanelBlock.PanelType.PACKAGER : FactoryPanelBlock.PanelType.NETWORK;
        EnumMap<FactoryPanelBlock.PanelSlot, FactoryPanelBlock.PanelState> states = new EnumMap<FactoryPanelBlock.PanelSlot, FactoryPanelBlock.PanelState>(FactoryPanelBlock.PanelSlot.class);
        this.panels.forEach((slot, behavior) -> {
            if (behavior.isActive()) {
                states.put((FactoryPanelBlock.PanelSlot)((Object)slot), behavior.count == 0 ? FactoryPanelBlock.PanelState.PASSIVE : FactoryPanelBlock.PanelState.ACTIVE);
            }
        });
        return new RenderData(type, states);
    }

    public record RenderData(FactoryPanelBlock.PanelType type, Map<FactoryPanelBlock.PanelSlot, FactoryPanelBlock.PanelState> states) {
    }
}

