/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.OrientedRotatingVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BearingVisual<B extends KineticBlockEntity>
extends OrientedRotatingVisual<B>
implements SimpleDynamicVisual {
    final OrientedInstance topInstance;
    final class_7833 rotationAxis;
    final Quaternionf blockOrientation;

    public BearingVisual(VisualizationContext context, B blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, class_2350.field_11035, ((class_2350)blockEntity.method_11010().method_11654((class_2769)class_2741.field_12525)).method_10153(), Models.partial((PartialModel)AllPartialModels.SHAFT_HALF));
        class_2350 facing = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12525);
        this.rotationAxis = class_7833.method_46356((Vector3f)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.rotationAxis()).method_23955());
        this.blockOrientation = BearingVisual.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingBlockEntity)blockEntity).isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        this.topInstance = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)top)).createInstance();
        this.topInstance.position((class_2382)this.getVisualPosition()).rotation((Quaternionfc)this.blockOrientation).setChanged();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float interpolatedAngle = ((IBearingBlockEntity)((Object)((KineticBlockEntity)this.blockEntity))).getInterpolatedAngle(ctx.partialTick() - 1.0f);
        Quaternionf rot = this.rotationAxis.rotationDegrees(interpolatedAngle);
        rot.mul((Quaternionfc)this.blockOrientation);
        this.topInstance.rotation((Quaternionfc)rot).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.topInstance});
    }

    @Override
    protected void _delete() {
        super._delete();
        this.topInstance.delete();
    }

    static Quaternionf getBlockStateOrientation(class_2350 facing) {
        Quaternionf orientation = facing.method_10166().method_10179() ? class_7833.field_40716.rotationDegrees(AngleHelper.horizontalAngle((class_2350)facing.method_10153())) : new Quaternionf();
        orientation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f - AngleHelper.verticalAngle((class_2350)facing)));
        return orientation;
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.topInstance);
    }
}

