/*
 * Decompiled with CFR 0.152.
 */
package com.dowar.mods.create_mixed_casing.mixins;

import com.dowar.mods.create_mixed_casing.config.Configs;
import com.dowar.mods.create_mixed_casing.mixins.ItemAppRecipeAccessor;
import com.dowar.mods.create_mixed_casing.util.RedirectHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ManualApplicationRecipe.class})
public abstract class ManualAppRecipeMixin {
    @Unique
    private static final List<String> BELT_PROCESS_WHITELIST = List.of((String[])ModList.get().getMods().stream().map(IModInfo::getModId).toArray(String[]::new));

    @Inject(method={"manualApplicationRecipesApplyInWorld"}, at={@At(value="HEAD")}, remap=false)
    private static void captureContext(PlayerInteractEvent.RightClickBlock event, CallbackInfo ci) {
        RedirectHelper.setEvent(event);
    }

    @ModifyArg(method={"manualApplicationRecipesApplyInWorld"}, at=@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V"), remap=false)
    private static Consumer<ItemStack> replaceForEachConsumer(Consumer<ItemStack> originalConsumer) {
        if (!((Boolean)Configs.server().ApplicationRecipeOutputInInventory.get()).booleanValue()) {
            return originalConsumer;
        }
        PlayerInteractEvent.RightClickBlock event = RedirectHelper.getEvent();
        return stack -> {
            boolean success = event.getEntity().m_150109_().m_36054_(stack);
            if (!success) {
                Block.m_49840_((Level)event.getLevel(), (BlockPos)event.getPos(), (ItemStack)stack);
            }
        };
    }

    @Inject(method={"testBlock(Lnet/minecraft/world/level/block/state/BlockState;)Z"}, at={@At(value="HEAD")}, remap=false)
    private void onTestBlock(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        PlayerInteractEvent.RightClickBlock event = RedirectHelper.getEvent();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        UseOnContext context = new UseOnContext(event.getEntity(), event.getHand(), event.getHitVec());
        Player player = context.m_43723_();
        ItemStack heldItem = player.m_21120_(context.m_43724_());
        if (heldItem.m_41619_()) {
            return;
        }
        if (state.m_60795_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        ProcessingRecipe recipe = (ProcessingRecipe)this;
        boolean ingredient1 = false;
        boolean ingredient2 = false;
        boolean fake_item = false;
        boolean is_large = false;
        boolean is_vertical = false;
        if (level.m_7702_(pos) instanceof GearboxBlockEntity) {
            if (!((Boolean)Configs.server().processApplicationRecipeOnGearbox.get()).booleanValue()) {
                return;
            }
            casing = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).m_135815_();
            if (((String)casing).equals("gearbox")) {
                casing = "andesite_gearbox";
            }
            if (((String)casing).equals("vertical_gearbox")) {
                casing = "vertical_andesite_gearbox";
            }
            if (((String)casing).endsWith("_gearbox")) {
                casing = ((String)casing).substring(0, ((String)casing).length() - "_gearbox".length());
            }
            if (((String)casing).endsWith("_block")) {
                casing = ((String)casing).substring(0, ((String)casing).length() - "_block".length());
            }
            if (((String)casing).startsWith("vertical_")) {
                casing = ((String)casing).substring(0, "vertical_".length());
                is_vertical = true;
            }
            Block found_casing = Blocks.f_50016_;
            for (String namespace : List.of("create", "create_mixed_casing", "createcasing")) {
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)((String)casing + "_casing"));
                ResourceLocation id2 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)((String)casing + "_block"));
                if (BuiltInRegistries.f_256975_.m_7804_(id)) {
                    found_casing = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
                    break;
                }
                if (!BuiltInRegistries.f_256975_.m_7804_(id2)) continue;
                found_casing = (Block)BuiltInRegistries.f_256975_.m_7745_(id2);
                break;
            }
            if (found_casing == Blocks.f_50016_) {
                return;
            }
            ingredient1 = ((Ingredient)recipe.m_7527_().get(0)).test(found_casing.m_5456_().m_7968_());
            ingredient2 = ((Ingredient)recipe.m_7527_().get(1)).test(heldItem);
        } else {
            casing = state.m_60734_();
            if (casing instanceof EncasedBlock) {
                EncasedBlock encased = (EncasedBlock)casing;
                if (!((Boolean)Configs.server().processApplicationRecipeOnEncased.get()).booleanValue()) {
                    return;
                }
                if (encased instanceof EncasedCogwheelBlock && (cogwheel = (EncasedCogwheelBlock)encased).isLargeCog()) {
                    is_large = true;
                }
                ingredient1 = ((Ingredient)recipe.m_7527_().get(0)).test(encased.getCasing().m_5456_().m_7968_());
                ingredient2 = ((Ingredient)recipe.m_7527_().get(1)).test(heldItem);
            } else {
                cogwheel = level.m_7702_(pos);
                if (cogwheel instanceof CopycatBlockEntity) {
                    CopycatBlockEntity copycat = (CopycatBlockEntity)cogwheel;
                    if (!((Boolean)Configs.server().processApplicationRecipeInCopycat.get()).booleanValue()) {
                        return;
                    }
                    ingredient1 = ((Ingredient)recipe.m_7527_().get(0)).test(copycat.getConsumedItem());
                    ingredient2 = ((Ingredient)recipe.m_7527_().get(1)).test(heldItem);
                } else {
                    cogwheel = state.m_60734_();
                    if (cogwheel instanceof BeltBlock) {
                        BeltBlock belt = (BeltBlock)cogwheel;
                        if (!((Boolean)Configs.server().processApplicationRecipeOnBelt.get()).booleanValue()) {
                            return;
                        }
                        casing = ((BeltBlockEntity)belt.getBlockEntity((BlockGetter)level, (BlockPos)pos)).casing.name().toLowerCase();
                        String casing_name = (String)casing + "_casing";
                        String casing_name2 = (String)casing + "_block";
                        Object found_casing = Blocks.f_50016_;
                        for (String namespace : BELT_PROCESS_WHITELIST) {
                            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)casing_name);
                            ResourceLocation id2 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)casing_name2);
                            if (BuiltInRegistries.f_256975_.m_7804_(id)) {
                                found_casing = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
                                break;
                            }
                            if (!BuiltInRegistries.f_256975_.m_7804_(id2)) continue;
                            found_casing = (Block)BuiltInRegistries.f_256975_.m_7745_(id2);
                            break;
                        }
                        if (found_casing == Blocks.f_50016_) {
                            return;
                        }
                        ingredient1 = ((Ingredient)recipe.m_7527_().get(0)).test(found_casing.m_5456_().m_7968_());
                        ingredient2 = ((Ingredient)recipe.m_7527_().get(1)).test(heldItem);
                        fake_item = true;
                    }
                }
            }
        }
        if (ingredient1 && ingredient2) {
            boolean keepHeld;
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            if (level.f_46443_) {
                return;
            }
            ItemStack block_result = ((ProcessingOutput)recipe.getRollableResults().get(0)).getStack();
            if (level.m_7702_(pos) instanceof GearboxBlockEntity) {
                if (!((Boolean)Configs.server().processApplicationRecipeOnGearbox.get()).booleanValue()) {
                    return;
                }
                casing_id = BuiltInRegistries.f_256975_.m_7981_((Object)Block.m_49814_((Item)block_result.m_41720_())).m_135815_();
                if (((String)casing_id).endsWith("_casing")) {
                    casing_id = ((String)casing_id).substring(0, ((String)casing_id).length() - "_casing".length());
                }
                if (((String)casing_id).endsWith("_block")) {
                    casing_id = ((String)casing_id).substring(0, ((String)casing_id).length() - "_block".length());
                }
                if (is_vertical) {
                    casing_id = "vertical_" + (String)casing_id;
                }
                casing_id = (String)casing_id + "_gearbox";
                Block found_casing = Blocks.f_50016_;
                for (String namespace : List.of("create", "create_mixed_casing", "createcasing")) {
                    ResourceLocation id;
                    if (namespace.equals("create") && ((String)casing_id).equals("andesite_gearbox")) {
                        casing_id = "gearbox";
                    }
                    if (namespace.equals("create") && ((String)casing_id).equals("vertical_andesite_gearbox")) {
                        casing_id = "vertical_gearbox";
                    }
                    if (!BuiltInRegistries.f_256975_.m_7804_(id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)casing_id))) continue;
                    found_casing = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
                    break;
                }
                if (found_casing == Blocks.f_50016_) {
                    return;
                }
                new_state = BlockHelper.copyProperties((BlockState)state, (BlockState)found_casing.m_49966_());
                level.m_7731_(pos, new_state, 3);
            } else {
                casing_id = state.m_60734_();
                if (casing_id instanceof EncasedBlock) {
                    EncasedBlock encased_id = (EncasedBlock)casing_id;
                    if (!((Boolean)Configs.server().processApplicationRecipeOnEncased.get()).booleanValue()) {
                        return;
                    }
                    type = ManualAppRecipeMixin.getBlock(encased_id, is_large);
                    if (type == Blocks.f_50016_) {
                        return;
                    }
                    Block found = Blocks.f_50016_;
                    for (Block block : EncasingRegistry.getVariants((Block)type)) {
                        EncasedBlock encased;
                        if (!(block instanceof EncasedBlock) || (encased = (EncasedBlock)block).getCasing().m_5456_() != block_result.m_41720_()) continue;
                        found = (Block)encased;
                    }
                    if (found == Blocks.f_50016_) {
                        return;
                    }
                    new_state = BlockHelper.copyProperties((BlockState)state, (BlockState)found.m_49966_());
                    level.m_7731_(pos, new_state, 3);
                    fake_item = true;
                } else {
                    type = level.m_7702_(pos);
                    if (type instanceof CopycatBlockEntity) {
                        CopycatBlockEntity copycat = (CopycatBlockEntity)type;
                        if (!((Boolean)Configs.server().processApplicationRecipeInCopycat.get()).booleanValue()) {
                            return;
                        }
                        copycat.setConsumedItem(block_result);
                        copycat.setMaterial(Block.m_49814_((Item)block_result.m_41720_()).m_49966_());
                    } else {
                        type = state.m_60734_();
                        if (type instanceof BeltBlock) {
                            BeltBlockEntity.CasingType casing;
                            BeltBlock belt = (BeltBlock)type;
                            if (!((Boolean)Configs.server().processApplicationRecipeOnBelt.get()).booleanValue()) {
                                return;
                            }
                            casing_id = BuiltInRegistries.f_256975_.m_7981_((Object)Block.m_49814_((Item)block_result.m_41720_())).m_135815_();
                            if (((String)casing_id).endsWith("_casing")) {
                                casing_id = ((String)casing_id).substring(0, ((String)casing_id).length() - "_casing".length());
                            }
                            if (((String)casing_id).endsWith("_block")) {
                                casing_id = ((String)casing_id).substring(0, ((String)casing_id).length() - "_block".length());
                            }
                            try {
                                casing = BeltBlockEntity.CasingType.valueOf((String)((String)casing_id).toUpperCase());
                            }
                            catch (IllegalArgumentException e) {
                                try {
                                    casing = BeltBlockEntity.CasingType.valueOf((String)casing_id);
                                }
                                catch (IllegalArgumentException ex) {
                                    return;
                                }
                            }
                            BeltBlockEntity.CasingType finalCasing = casing;
                            belt.withBlockEntityDo((BlockGetter)level, pos, be -> be.setCasingType(finalCasing));
                        }
                    }
                }
            }
            level.m_5594_(null, pos, SoundEvents.f_144117_, SoundSource.PLAYERS, 1.0f, 1.45f);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            boolean creative = player != null && player.m_7500_();
            boolean unbreakable = heldItem.m_41763_();
            boolean bl = keepHeld = ((ItemAppRecipeAccessor)((Object)this)).shouldKeepHeldItem() || creative || fake_item;
            if (!unbreakable && !keepHeld) {
                if (heldItem.m_41763_()) {
                    heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(context.m_43724_() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
                } else {
                    heldItem.m_41774_(1);
                }
            }
            if (!fake_item) {
                if (((Boolean)Configs.server().ApplicationRecipeOutputInInventory.get()).booleanValue()) {
                    recipe.rollResults().forEach(stack -> {
                        boolean success = player.m_150109_().m_36054_(stack);
                        if (!success) {
                            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                        }
                    });
                } else {
                    recipe.rollResults().forEach(stack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
                }
            }
        }
    }

    @NotNull
    private static Block getBlock(EncasedBlock encased_id, boolean is_large) {
        Block type;
        if (encased_id instanceof EncasedShaftBlock) {
            EncasedShaftBlock shaft = (EncasedShaftBlock)encased_id;
            type = AllBlocks.SHAFT.getDefaultState().m_60734_();
        } else if (encased_id instanceof EncasedPipeBlock) {
            EncasedPipeBlock pipe = (EncasedPipeBlock)encased_id;
            type = AllBlocks.FLUID_PIPE.getDefaultState().m_60734_();
        } else if (encased_id instanceof EncasedCogwheelBlock) {
            EncasedCogwheelBlock cog = (EncasedCogwheelBlock)encased_id;
            type = is_large ? AllBlocks.LARGE_COGWHEEL.getDefaultState().m_60734_() : AllBlocks.COGWHEEL.getDefaultState().m_60734_();
        } else {
            type = Blocks.f_50016_;
        }
        return type;
    }

    @Inject(method={"manualApplicationRecipesApplyInWorld"}, at={@At(value="RETURN")}, remap=false)
    private static void clearContext(CallbackInfo ci) {
        RedirectHelper.clear();
    }
}

