/*
 * Decompiled with CFR 0.152.
 */
package com.dowar.mods.create_mixed_casing.item;

import com.dowar.mods.create_mixed_casing.config.Configs;
import com.dowar.mods.create_mixed_casing.item.MixedWrenchItemHelper;
import com.dowar.mods.create_mixed_casing.util.MixedRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@Mod.EventBusSubscriber(modid="create_mixed_casing", value={Dist.CLIENT})
public class MixedWrenchItemOverlay {
    private static Class<?> irisClass;
    private static Method shaderPack;
    private static boolean shaderEnabled;

    private static void setupIrisSupport() {
        try {
            irisClass = Class.forName("net.irisshaders.iris.Iris");
            shaderPack = irisClass.getDeclaredMethod("getCurrentPack", new Class[0]);
            shaderPack.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to locate Iris shader pack getter", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isIrisShadersEnabled() {
        if (irisClass != null && shaderPack != null) {
            try {
                Optional pack = (Optional)shaderPack.invoke(null, new Object[0]);
                shaderEnabled = pack.isPresent();
                return shaderEnabled;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke shader pack getter", e);
            }
        }
        return shaderEnabled;
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!Configs.server().wrenchEncasingBehavior.booleanValue()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hit = (BlockHitResult)hitResult;
        if (mc.f_91074_.m_21205_().m_41720_() != AllItems.WRENCH.m_5456_()) {
            return;
        }
        if (mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        BlockPos hit_block = hit.m_82425_();
        Camera cam = mc.f_91063_.m_109153_();
        Vec3 cam_pos = cam.m_90583_();
        Quaternionf rot = cam.m_253121_();
        BlockState state = mc.f_91073_.m_8055_(hit_block);
        Block block = state.m_60734_();
        Direction face = hit.m_82434_();
        Item off_hand = mc.f_91074_.m_21206_().m_41720_();
        if (!MixedWrenchItemOverlay.can_be_encased(off_hand)) {
            return;
        }
        if (!(block instanceof EncasedPipeBlock) & !(block instanceof CasingBlock)) {
            return;
        }
        ArrayList<RenderedBlock> block_to_render = new ArrayList<RenderedBlock>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        if (Configs.client().wrenchPipeOverlayMode.booleanValue()) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
        } else {
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
        }
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        ms.m_252781_(rot.invert());
        ms.m_85837_(-cam_pos.f_82479_, -cam_pos.f_82480_, -cam_pos.f_82481_);
        ms.m_85841_(1.0f, 1.0f, 1.0f);
        if (Configs.client().wrenchPipeOverlayMode.booleanValue()) {
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-1.0f, (float)-1.0f);
        }
        MixedWrenchItemOverlay.find_encased(mc, (Level)mc.f_91073_, hit_block, face, visited, 0, block_to_render);
        if (!Configs.client().wrenchPipeOverlayMode.booleanValue()) {
            block_to_render.sort(Comparator.comparingDouble(rp -> -Vec3.m_82512_((Vec3i)rp.pos).m_82557_(cam_pos)));
        }
        if (block instanceof EncasedPipeBlock || block instanceof CasingBlock) {
            MultiBufferSource.BufferSource buffers_block = mc.m_91269_().m_110104_();
            if (!Configs.client().wrenchPipeOverlayMode.booleanValue()) {
                ms.m_85836_();
                ms.m_252880_((float)hit_block.m_123341_(), (float)hit_block.m_123342_(), (float)hit_block.m_123343_());
                MixedWrenchItemOverlay.render_block_model(buffers_block, MixedRenderType.BLOCK_TEXTURE_OVERLAY_TRANSPARENT, state, hit_block, ms, mc);
                MixedWrenchItemOverlay.render_pipe_preview_model(MixedRenderType.BLOCK_COLOR_OVERLAY, state, hit_block, ms, mc);
                ms.m_85849_();
            }
            for (RenderedBlock rp2 : block_to_render) {
                if (MixedWrenchItemOverlay.should_hide(rp2.pos, face, mc).booleanValue()) continue;
                ms.m_85836_();
                ms.m_252880_((float)rp2.pos.m_123341_(), (float)rp2.pos.m_123342_(), (float)rp2.pos.m_123343_());
                MixedWrenchItemOverlay.move_render_on_face(face, ms);
                if (rp2.state.m_60734_() == AllBlocks.FLUID_PIPE.get()) {
                    MixedWrenchItemOverlay.render_pipe_model(buffers_block, MixedRenderType.BLOCK_TEXTURE_OVERLAY, rp2.state, rp2.pos, ms, mc);
                }
                ms.m_85849_();
            }
            ms.m_85836_();
            ms.m_252880_((float)hit_block.m_123341_(), (float)hit_block.m_123342_(), (float)hit_block.m_123343_());
            MixedWrenchItemOverlay.move_render_on_face_2D(face, ms);
            if (state.m_60734_() instanceof EncasedPipeBlock || state.m_60734_() instanceof CasingBlock && off_hand == AllBlocks.FLUID_PIPE.m_5456_()) {
                MixedWrenchItemOverlay.render_pipe_preview_model(MixedRenderType.BLOCK_COLOR_OVERLAY, state, hit_block, ms, mc);
            }
            if (!Configs.client().wrenchPipeOverlayMode.booleanValue()) {
                MixedWrenchItemOverlay.render_block_model(buffers_block, MixedRenderType.BLOCK_TEXTURE_OVERLAY_TRANSPARENT, state, hit_block, ms, mc);
            }
            ms.m_85849_();
            buffers_block.m_109911_();
        }
        ms.m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.disablePolygonOffset();
    }

    private static void find_encased(Minecraft mc, Level world, BlockPos pos, Direction face, Set<BlockPos> visited, int depth, ArrayList<RenderedBlock> out) {
        if (depth > (Integer)Configs.client().wrenchOverlayRadius.get()) {
            return;
        }
        if (!visited.add(pos)) {
            return;
        }
        BlockState state = mc.f_91073_.m_8055_(pos);
        if (!(state.m_60734_() instanceof EncasedBlock) && !(state.m_60734_() instanceof CasingBlock)) {
            return;
        }
        if (state.m_60734_() instanceof EncasedPipeBlock) {
            out.add(new RenderedBlock(pos, (BlockState)MixedWrenchItemOverlay.build_pipe_state(state)));
        }
        if (state.m_60734_() instanceof EncasedCogwheelBlock) {
            out.add(new RenderedBlock(pos, (BlockState)MixedWrenchItemOverlay.build_cogwheel_state(state)));
        }
        for (Direction dir : Direction.values()) {
            if (Configs.client().wrenchPipeOverlayMode.booleanValue() && (face == dir || face.m_122424_() == dir)) continue;
            BlockPos neighborPos = pos.m_121945_(dir);
            MixedWrenchItemOverlay.find_encased(mc, world, neighborPos, face, visited, depth + 1, out);
        }
    }

    private static void move_render_on_face(Direction face, PoseStack ms) {
        if (!Configs.client().wrenchPipeOverlayMode.booleanValue()) {
            return;
        }
        if (face == Direction.SOUTH) {
            ms.m_85837_(0.0, 0.0, 1.001);
            ms.m_85841_(1.0f, 1.0f, 0.001f);
        }
        if (face == Direction.NORTH) {
            ms.m_85837_(0.0, 0.0, -0.001);
            ms.m_85841_(1.0f, 1.0f, 0.001f);
        }
        if (face == Direction.EAST) {
            ms.m_85837_(1.001, 0.0, 0.0);
            ms.m_85841_(0.001f, 1.0f, 1.0f);
        }
        if (face == Direction.WEST) {
            ms.m_85837_(-0.001, 0.0, 0.0);
            ms.m_85841_(0.001f, 1.0f, 1.0f);
        }
        if (face == Direction.UP) {
            ms.m_85837_(0.0, 1.001, 0.0);
            ms.m_85841_(1.0f, 0.001f, 1.0f);
        }
        if (face == Direction.DOWN) {
            ms.m_85837_(0.0, -0.001, 0.0);
            ms.m_85841_(1.0f, 0.001f, 1.0f);
        }
    }

    private static void move_render_on_face(Direction face, PoseStack ms, float scale_x, float scale_y, float scale_z) {
        if (!Configs.client().wrenchPipeOverlayMode.booleanValue()) {
            return;
        }
        if (face == Direction.SOUTH) {
            ms.m_85837_(0.0, 0.0, (double)scale_z + 0.001);
            ms.m_85841_(scale_x, scale_y, 0.001f);
        }
        if (face == Direction.NORTH) {
            ms.m_85837_(0.0, 0.0, -0.001);
            ms.m_85841_(scale_x, scale_y, 0.001f);
        }
        if (face == Direction.EAST) {
            ms.m_85837_((double)scale_x + 0.001, 0.0, 0.0);
            ms.m_85841_(0.001f, scale_y, scale_z);
        }
        if (face == Direction.WEST) {
            ms.m_85837_(-0.001, 0.0, 0.0);
            ms.m_85841_(0.001f, scale_y, scale_z);
        }
        if (face == Direction.UP) {
            ms.m_85837_(0.0, (double)scale_y + 0.001, 0.0);
            ms.m_85841_(scale_x, 0.001f, scale_z);
        }
        if (face == Direction.DOWN) {
            ms.m_85837_(0.0, -0.001, 0.0);
            ms.m_85841_(scale_x, 0.001f, scale_z);
        }
    }

    private static void move_render_on_face_2D(Direction face, PoseStack ms) {
        if (!Configs.client().wrenchPipeOverlayMode.booleanValue()) {
            return;
        }
        if (face == Direction.SOUTH) {
            ms.m_85837_(0.0, 0.0, 1.001);
            ms.m_85841_(1.0f, 1.0f, 0.0f);
        }
        if (face == Direction.NORTH) {
            ms.m_85837_(0.0, 0.0, -0.001);
            ms.m_85841_(1.0f, 1.0f, 0.0f);
        }
        if (face == Direction.EAST) {
            ms.m_85837_(1.001, 0.0, 0.0);
            ms.m_85841_(0.0f, 1.0f, 1.0f);
        }
        if (face == Direction.WEST) {
            ms.m_85837_(-0.001, 0.0, 0.0);
            ms.m_85841_(0.0f, 1.0f, 1.0f);
        }
        if (face == Direction.UP) {
            ms.m_85837_(0.0, 1.001, 0.0);
            ms.m_85841_(1.0f, 0.0f, 1.0f);
        }
        if (face == Direction.DOWN) {
            ms.m_85837_(0.0, -0.001, 0.0);
            ms.m_85841_(1.0f, 0.0f, 1.0f);
        }
    }

    private static Boolean should_hide(BlockPos pos, Direction face, Minecraft mc) {
        if (!Configs.client().wrenchPipeOverlayMode.booleanValue()) {
            return false;
        }
        if (face == Direction.SOUTH && mc.f_91073_.m_8055_(pos.m_122019_()).m_60831_((BlockGetter)mc.f_91073_, pos)) {
            return true;
        }
        if (face == Direction.NORTH && mc.f_91073_.m_8055_(pos.m_122012_()).m_60831_((BlockGetter)mc.f_91073_, pos)) {
            return true;
        }
        if (face == Direction.EAST && mc.f_91073_.m_8055_(pos.m_122029_()).m_60831_((BlockGetter)mc.f_91073_, pos)) {
            return true;
        }
        if (face == Direction.WEST && mc.f_91073_.m_8055_(pos.m_122024_()).m_60831_((BlockGetter)mc.f_91073_, pos)) {
            return true;
        }
        if (face == Direction.UP && mc.f_91073_.m_8055_(pos.m_7494_()).m_60831_((BlockGetter)mc.f_91073_, pos)) {
            return true;
        }
        if (face == Direction.DOWN && mc.f_91073_.m_8055_(pos.m_7495_()).m_60831_((BlockGetter)mc.f_91073_, pos)) {
            return true;
        }
        return false;
    }

    private static BlockBehaviour.BlockStateBase build_pipe_state(BlockState state) {
        BlockState pipe = AllBlocks.FLUID_PIPE.getDefaultState();
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61367_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)));
        return pipe;
    }

    private static BlockBehaviour.BlockStateBase build_cogwheel_state(BlockState state) {
        BlockState cogwheel = AllBlocks.COGWHEEL.getDefaultState();
        cogwheel = (BlockState)cogwheel.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)));
        return cogwheel;
    }

    public static void render_pipe_model(MultiBufferSource.BufferSource buffers_block, RenderType render_type, BlockState state, BlockPos hit_block, PoseStack ms, Minecraft mc) {
        BlockState pipe = (BlockState)AllBlocks.FLUID_PIPE.getDefaultState().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61367_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)));
        ModelData data = mc.m_91289_().m_110910_(pipe).getModelData((BlockAndTintGetter)mc.f_91073_, hit_block, pipe, ModelData.EMPTY);
        mc.m_91289_().renderSingleBlock(pipe, ms, (MultiBufferSource)buffers_block, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_, data, render_type);
    }

    public static void render_cogwheel_model(MultiBufferSource.BufferSource buffers_block, RenderType render_type, BlockState state, BlockPos hit_block, PoseStack ms, Minecraft mc, Direction face) {
        ItemStack cogwheel = AllBlocks.COGWHEEL.asStack();
        ItemStack shaft = AllBlocks.SHAFT.asStack();
        ms.m_85837_(0.5, 0.5, 0.5);
    }

    public static void render_pipe_preview_model(RenderType render_type, BlockState state, BlockPos hit_block, PoseStack ms, Minecraft mc) {
        BlockState pipe = AllBlocks.FLUID_PIPE.getDefaultState();
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(false));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.valueOf(false));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false));
        pipe = (BlockState)pipe.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false));
        BlockHitResult hit = (BlockHitResult)mc.f_91077_;
        pipe = MixedWrenchItemHelper.handleClick(pipe, hit_block, hit);
        ModelData data = mc.m_91289_().m_110910_(pipe).getModelData(MixedWrenchItemOverlay.getBlockAndTintGetter(hit_block, pipe), hit_block, pipe, ModelData.EMPTY);
        MultiBufferSource.BufferSource buffers_block = mc.m_91269_().m_110104_();
        mc.m_91289_().renderSingleBlock(pipe, ms, (MultiBufferSource)buffers_block, LightTexture.m_109885_((int)0, (int)0), OverlayTexture.f_118083_, data, render_type);
        buffers_block.m_109912_(render_type);
    }

    @NotNull
    private static BlockAndTintGetter getBlockAndTintGetter(final BlockPos pos, final BlockState state) {
        return new BlockAndTintGetter(){
            Level real_world;
            {
                this.real_world = Minecraft.m_91087_().f_91073_;
            }

            public int m_141928_() {
                return this.real_world.m_141928_();
            }

            public int m_141937_() {
                return this.real_world.m_141937_();
            }

            public float m_7717_(@NotNull Direction direction, boolean b) {
                return this.real_world.m_7717_(direction, b);
            }

            @NotNull
            public LevelLightEngine m_5518_() {
                return this.real_world.m_5518_();
            }

            public int m_6171_(@NotNull BlockPos blockPos, @NotNull ColorResolver colorResolver) {
                return this.real_world.m_6171_(blockPos, colorResolver);
            }

            @NotNull
            public FluidState m_6425_(@NotNull BlockPos blockPos) {
                return this.real_world.m_6425_(blockPos);
            }

            @Nullable
            public BlockEntity m_7702_(@NotNull BlockPos blockPos) {
                EntityBlock test = (EntityBlock)state.m_60734_();
                return blockPos.equals((Object)pos) ? test.m_142194_(pos, state) : this.real_world.m_7702_(blockPos);
            }

            @NotNull
            public BlockState m_8055_(@NotNull BlockPos blockPos) {
                return blockPos.equals((Object)pos) ? state : this.real_world.m_8055_(blockPos);
            }
        };
    }

    public static void render_block_model(MultiBufferSource.BufferSource buffers_block, RenderType render_type, BlockState state, BlockPos hit_block, PoseStack ms, Minecraft mc) {
        ModelData data;
        Block block = state.m_60734_();
        if (block instanceof EncasedBlock) {
            EncasedBlock encased = (EncasedBlock)block;
            BlockState casing = encased.getCasing().m_49966_();
            data = mc.m_91289_().m_110910_(casing).getModelData((BlockAndTintGetter)mc.f_91073_, hit_block, casing, ModelData.EMPTY);
        } else {
            data = mc.m_91289_().m_110910_(state).getModelData((BlockAndTintGetter)mc.f_91073_, hit_block, state, ModelData.EMPTY);
        }
        mc.m_91289_().renderSingleBlock(state, ms, (MultiBufferSource)buffers_block, LightTexture.m_109885_((int)0, (int)15), OverlayTexture.f_118083_, data, render_type);
    }

    public static void render_sprite_overlay(RenderType render_type, BlockState state, BlockPos hit_block, PoseStack ms, Minecraft mc, Color color, float size, boolean side_check) {
        ResourceLocation spriteLoc = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/bedrock");
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(spriteLoc);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)spriteLoc);
        float u = sprite.m_118409_();
        float v = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        Matrix4f mat = ms.m_85850_().m_252922_();
        float border = 0.5f;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        int overlay = OverlayTexture.f_118083_;
        int light = LightTexture.m_109885_((int)0, (int)15);
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        VertexConsumer vb = buffers.m_6299_(render_type);
        buffers.m_109912_(render_type);
        ms.m_85837_(-0.5, -0.5, -0.5);
    }

    public static void render_gear_overlay(RenderType render_type, BlockState state, BlockPos hit_block, PoseStack ms, Minecraft mc, Color color, float size, Direction face) {
        Matrix4f mat = ms.m_85850_().m_252922_();
        float border = 0.0f;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        int overlay = OverlayTexture.f_118083_;
        int light = LightTexture.m_109885_((int)0, (int)15);
        BlockState cogwheel = AllBlocks.COGWHEEL.getDefaultState();
        BlockHitResult hit = (BlockHitResult)mc.f_91077_;
        cogwheel = MixedWrenchItemHelper.handleClickCogwheel(cogwheel, hit_block, hit);
        ResourceLocation spriteLoc = ResourceLocation.m_135820_((String)"create:block/axis");
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        VertexConsumer vb = buffers.m_6299_(render_type);
        ms.m_85837_(0.5, 0.5, 0.5);
        if (face == Direction.WEST || face == Direction.EAST) {
            if (cogwheel.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Z) {
                ms.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            if (cogwheel.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.X) {
                spriteLoc = ResourceLocation.m_135820_((String)"create:block/axis_top");
            }
        } else if (face == Direction.UP || face == Direction.DOWN) {
            if (cogwheel.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Z) {
                ms.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
            if (cogwheel.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y) {
                spriteLoc = ResourceLocation.m_135820_((String)"create:block/axis_top");
            }
        } else {
            if (cogwheel.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.X) {
                ms.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            if (cogwheel.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Z) {
                spriteLoc = ResourceLocation.m_135820_((String)"create:block/axis_top");
            }
        }
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(spriteLoc);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)spriteLoc);
        float u = sprite.m_118409_();
        float v = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        buffers.m_109912_(render_type);
        ms.m_85837_(-0.5, -0.5, -0.5);
    }

    public static void render_pipe_overlay(RenderType render_type, BlockState state, BlockPos hit_block, PoseStack ms, Minecraft mc, Color color, float size, boolean side_check) {
        Matrix4f mat = ms.m_85850_().m_252922_();
        float border = 0.5f;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        float u = 0.0f;
        float v = 0.0f;
        int overlay = OverlayTexture.f_118083_;
        int light = LightTexture.m_109885_((int)0, (int)15);
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        VertexConsumer vb = buffers.m_6299_(render_type);
        ms.m_85837_(0.5, 0.5, 0.5);
        buffers.m_109912_(render_type);
        ms.m_85837_(-0.5, -0.5, -0.5);
    }

    private static boolean can_be_encased(Item item) {
        return item == AllBlocks.FLUID_PIPE.m_5456_();
    }

    static {
        shaderEnabled = false;
        MixedWrenchItemOverlay.setupIrisSupport();
    }

    private record RenderedBlock(BlockPos pos, BlockState state) {
    }
}

