/*
 * Decompiled with CFR 0.152.
 */
package com.dowar.mods.create_mixed_casing.item;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MixedWrenchItemHelper {
    private static final Map<Direction, BooleanProperty> DIR_TO_PROP = Map.ofEntries(Map.entry(Direction.UP, BlockStateProperties.f_61366_), Map.entry(Direction.DOWN, BlockStateProperties.f_61367_), Map.entry(Direction.NORTH, BlockStateProperties.f_61368_), Map.entry(Direction.SOUTH, BlockStateProperties.f_61370_), Map.entry(Direction.EAST, BlockStateProperties.f_61369_), Map.entry(Direction.WEST, BlockStateProperties.f_61371_));
    private static final Map<Direction, EnumMap<Region, Direction[]>> FACE_REGION_MAP = new EnumMap<Direction, EnumMap<Region, Direction[]>>(Direction.class);

    public static BlockState toggleProperty(BlockState state, Direction ... dirs) {
        if (dirs == null || dirs.length == 0) {
            return state;
        }
        if (dirs.length == 1) {
            return MixedWrenchItemHelper.toggleProperty(state, dirs[0]);
        }
        boolean allOn = true;
        for (Direction d : dirs) {
            BooleanProperty prop = DIR_TO_PROP.get(d);
            if (prop != null && ((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
            allOn = false;
            break;
        }
        boolean newVal = !allOn;
        for (Direction d : dirs) {
            BooleanProperty prop = DIR_TO_PROP.get(d);
            if (prop == null) continue;
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(newVal));
        }
        return state;
    }

    public static BlockState toggleProperty(BlockState state, Direction dir) {
        BooleanProperty prop = DIR_TO_PROP.get(dir);
        if (prop == null) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)prop) == false));
    }

    public static BlockState handleClick(BlockState state, BlockPos hitBlock, BlockHitResult hit) {
        double v;
        double u;
        Direction face = hit.m_82434_();
        Vec3 location = hit.m_82450_();
        double lx = location.f_82479_ - (double)hitBlock.m_123341_();
        double ly = location.f_82480_ - (double)hitBlock.m_123342_();
        double lz = location.f_82481_ - (double)hitBlock.m_123343_();
        switch (face) {
            case UP: {
                u = lx;
                v = lz;
                break;
            }
            case DOWN: {
                u = lx;
                v = 1.0 - lz;
                break;
            }
            case NORTH: {
                u = lx;
                v = ly;
                break;
            }
            case SOUTH: {
                u = 1.0 - lx;
                v = ly;
                break;
            }
            case EAST: {
                u = lz;
                v = ly;
                break;
            }
            case WEST: {
                u = 1.0 - lz;
                v = ly;
                break;
            }
            default: {
                return state;
            }
        }
        Region region = Region.fromUV(u, v);
        Direction[] dirs = (Direction[])FACE_REGION_MAP.getOrDefault(face, new EnumMap(Region.class)).get((Object)region);
        if (dirs == null || dirs.length == 0) {
            return state;
        }
        return MixedWrenchItemHelper.toggleProperty(state, dirs);
    }

    public static BlockState handleClickCogwheel(BlockState state, BlockPos hitBlock, BlockHitResult hit) {
        double v;
        double u;
        Direction face = hit.m_82434_();
        Vec3 location = hit.m_82450_();
        double lx = location.f_82479_ - (double)hitBlock.m_123341_();
        double ly = location.f_82480_ - (double)hitBlock.m_123342_();
        double lz = location.f_82481_ - (double)hitBlock.m_123343_();
        switch (face) {
            case UP: {
                u = lx;
                v = lz;
                break;
            }
            case DOWN: {
                u = lx;
                v = 1.0 - lz;
                break;
            }
            case NORTH: {
                u = lx;
                v = ly;
                break;
            }
            case SOUTH: {
                u = 1.0 - lx;
                v = ly;
                break;
            }
            case EAST: {
                u = lz;
                v = ly;
                break;
            }
            case WEST: {
                u = 1.0 - lz;
                v = ly;
                break;
            }
            default: {
                return state;
            }
        }
        Region region = Region.fromUV(u, v);
        Direction.Axis current = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)(switch (face) {
            case Direction.UP, Direction.DOWN -> {
                switch (region) {
                    case CENTER: {
                        yield Direction.Axis.Y;
                    }
                    case N: 
                    case S: {
                        yield Direction.Axis.Z;
                    }
                    case W: 
                    case E: {
                        yield Direction.Axis.X;
                    }
                    case NW: 
                    case NE: 
                    case SW: 
                    case SE: {
                        yield Direction.Axis.Y;
                    }
                }
                yield current;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                switch (region) {
                    case CENTER: {
                        yield Direction.Axis.Z;
                    }
                    case N: 
                    case S: {
                        yield Direction.Axis.Y;
                    }
                    case W: 
                    case E: {
                        yield Direction.Axis.X;
                    }
                    case NW: 
                    case NE: 
                    case SW: 
                    case SE: {
                        yield Direction.Axis.Z;
                    }
                }
                yield current;
            }
            case Direction.EAST, Direction.WEST -> {
                switch (region) {
                    case CENTER: {
                        yield Direction.Axis.X;
                    }
                    case N: 
                    case S: {
                        yield Direction.Axis.Y;
                    }
                    case W: 
                    case E: {
                        yield Direction.Axis.Z;
                    }
                    case NW: 
                    case NE: 
                    case SW: 
                    case SE: {
                        yield Direction.Axis.X;
                    }
                }
                yield current;
            }
            default -> current;
        }));
    }

    private static Direction.Axis cycleAxis(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Direction.Axis.Y;
            case Direction.Axis.Y -> Direction.Axis.Z;
            case Direction.Axis.Z -> Direction.Axis.X;
        };
    }

    static {
        EnumMap<Region, Direction[]> upMap = new EnumMap<Region, Direction[]>(Region.class);
        upMap.put(Region.CENTER, new Direction[]{Direction.UP});
        upMap.put(Region.N, new Direction[]{Direction.NORTH});
        upMap.put(Region.S, new Direction[]{Direction.SOUTH});
        upMap.put(Region.W, new Direction[]{Direction.WEST});
        upMap.put(Region.E, new Direction[]{Direction.EAST});
        upMap.put(Region.NW, new Direction[]{Direction.WEST, Direction.NORTH});
        upMap.put(Region.NE, new Direction[]{Direction.EAST, Direction.NORTH});
        upMap.put(Region.SW, new Direction[]{Direction.WEST, Direction.SOUTH});
        upMap.put(Region.SE, new Direction[]{Direction.EAST, Direction.SOUTH});
        FACE_REGION_MAP.put(Direction.UP, upMap);
        EnumMap<Region, Direction[]> downMap = new EnumMap<Region, Direction[]>(Region.class);
        downMap.put(Region.CENTER, new Direction[]{Direction.DOWN});
        downMap.put(Region.N, new Direction[]{Direction.SOUTH});
        downMap.put(Region.S, new Direction[]{Direction.NORTH});
        downMap.put(Region.W, new Direction[]{Direction.WEST});
        downMap.put(Region.E, new Direction[]{Direction.EAST});
        downMap.put(Region.NW, new Direction[]{Direction.WEST, Direction.SOUTH});
        downMap.put(Region.NE, new Direction[]{Direction.EAST, Direction.SOUTH});
        downMap.put(Region.SW, new Direction[]{Direction.WEST, Direction.NORTH});
        downMap.put(Region.SE, new Direction[]{Direction.EAST, Direction.NORTH});
        FACE_REGION_MAP.put(Direction.DOWN, downMap);
        for (Direction side : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            EnumMap<Region, Direction[]> map = new EnumMap<Region, Direction[]>(Region.class);
            map.put(Region.CENTER, new Direction[]{side});
            map.put(Region.N, new Direction[]{Direction.DOWN});
            map.put(Region.S, new Direction[]{Direction.UP});
            map.put(Region.W, new Direction[]{side.m_122428_()});
            map.put(Region.E, new Direction[]{side.m_122427_()});
            map.put(Region.NW, new Direction[]{Direction.DOWN, side.m_122428_()});
            map.put(Region.NE, new Direction[]{Direction.DOWN, side.m_122427_()});
            map.put(Region.SW, new Direction[]{Direction.UP, side.m_122428_()});
            map.put(Region.SE, new Direction[]{Direction.UP, side.m_122427_()});
            FACE_REGION_MAP.put(side, map);
        }
    }

    private static enum Region {
        CENTER,
        N,
        S,
        W,
        E,
        NW,
        NE,
        SW,
        SE;


        static Region fromUV(double u, double v) {
            int row;
            int col;
            double wOuter;
            double wCenter = 0.5;
            double u0 = wOuter = (1.0 - wCenter) / 2.0;
            double u1 = wOuter + wCenter;
            double v0 = wOuter;
            double v1 = wOuter + wCenter;
            int n = u < u0 ? 0 : (col = u < u1 ? 1 : 2);
            int n2 = v < v0 ? 0 : (row = v < v1 ? 1 : 2);
            if (row == 1 && col == 1) {
                return CENTER;
            }
            if (row == 0 && col == 1) {
                return N;
            }
            if (row == 2 && col == 1) {
                return S;
            }
            if (row == 1 && col == 0) {
                return W;
            }
            if (row == 1 && col == 2) {
                return E;
            }
            if (row == 0 && col == 0) {
                return NW;
            }
            if (row == 0 && col == 2) {
                return NE;
            }
            if (row == 2 && col == 0) {
                return SW;
            }
            if (row == 2 && col == 2) {
                return SE;
            }
            return CENTER;
        }
    }
}

