/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.world;

import com.github.alexthe666.citadel.server.tick.ServerTickRateTracker;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class CitadelServerData
extends SavedData {
    private static final String IDENTIFIER = "citadel_world_data";
    private final MinecraftServer server;
    private ServerTickRateTracker tickRateTracker = null;

    public CitadelServerData(MinecraftServer server) {
        this.server = server;
    }

    public CitadelServerData(MinecraftServer server, CompoundTag tag) {
        this(server);
        this.tickRateTracker = tag.m_128441_("TickRateTracker") ? new ServerTickRateTracker(server, tag.m_128469_("TickRateTracker")) : new ServerTickRateTracker(server);
    }

    @NotNull
    public static CitadelServerData get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129880_(Level.f_46428_).m_8895_();
        CitadelServerData data = (CitadelServerData)storage.m_164861_(tag -> new CitadelServerData(server, (CompoundTag)tag), () -> new CitadelServerData(server), IDENTIFIER);
        data.m_77762_();
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        if (this.tickRateTracker != null) {
            tag.m_128365_("TickRateTracker", (Tag)this.tickRateTracker.toTag());
        }
        return tag;
    }

    public ServerTickRateTracker getOrCreateTickRateTracker() {
        if (this.tickRateTracker == null) {
            this.tickRateTracker = new ServerTickRateTracker(this.server);
        }
        return this.tickRateTracker;
    }
}

