/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.ui.screens;

import java.util.function.Consumer;
import java.util.function.Function;
import net.adeptstack.registry.TrainUtilitiesBuilderTransformers;
import net.adeptstack.ui.controls.BlockButton;
import net.adeptstack.utils.TrainSlidingDoorProperties;
import net.adeptstack.utils.screenUtils.ToolTipUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.IntegerProperty;

public class ChangeDoorSoundScreen
extends Screen {
    public static final int NO_VARIANT_SELECTED = -1;
    private static final ResourceLocation texture = new ResourceLocation("trainutilities", "textures/gui/selection_screen.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int WINDOW_WIDTH = 218;
    private static final int WINDOW_HEIGHT = 66;
    private static final int WINDOW_TOP_PART_HEIGHT = 21;
    private static final int WINDOW_BUTTON_AREA_Y = 21;
    private static final int WINDOW_BOTTOM_PART_Y = 41;
    private static final int WINDOW_BOTTOM_PART_HEIGHT = 45;
    private static final int MARGIN_LEFT = 8;
    private static final int MARGIN_RIGHT = 8;
    private static final int PREVIEW_ICON_SIZE = 32;
    private static final int DEFAULT_BUTTON_WIDTH = 70;
    private static final int MAX_BUTTONS_PER_ROW = 10;
    private final int maxValues;
    private final int maxRows;
    private final int startValue;
    private final Function<Integer, TextureResult> textureGetter;
    private final Consumer<Integer> onDone;
    private int guiLeft;
    private int guiTop;
    private TextureResult preview;
    private int selectedVariant = -1;

    public <T extends IntegerProperty> ChangeDoorSoundScreen(int variant, T property, Function<Integer, TextureResult> textureGetter, Consumer<Integer> onDone, String id) {
        super((Component)Component.m_237115_((String)id));
        this.maxValues = property.m_6908_().size();
        this.startValue = property.m_61702_().mapToInt(x -> (Integer)x.f_61713_()).min().orElse(0);
        this.maxRows = (int)Math.ceil((double)this.maxValues / 10.0);
        this.textureGetter = textureGetter;
        this.onDone = onDone;
        this.selectedVariant = variant;
        if (variant != -1) {
            this.preview = textureGetter.apply(variant);
        }
    }

    protected void onDone() {
        this.onDone.accept(this.selectedVariant);
    }

    private void onListen(boolean open) {
        if (Minecraft.m_91087_().f_91074_ != null && this.selectedVariant != 1) {
            TrainSlidingDoorProperties tsdp = TrainUtilitiesBuilderTransformers.GetSlidingDoorProperties(this.selectedVariant);
            if (open) {
                Minecraft.m_91087_().m_91106_().m_120405_();
                Minecraft.m_91087_().f_91074_.m_9236_().m_247517_((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20183_(), tsdp.GetOpen(), SoundSource.MASTER);
            } else {
                Minecraft.m_91087_().m_91106_().m_120405_();
                Minecraft.m_91087_().f_91074_.m_9236_().m_247517_((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20183_(), tsdp.GetClose(), SoundSource.MASTER);
            }
        }
    }

    public void m_7379_() {
        super.m_7379_();
        Minecraft.m_91087_().m_91106_().m_120405_();
    }

    public int getSelectedVariantId() {
        return this.selectedVariant;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 109;
        this.guiTop = this.f_96544_ / 2 - (66 + this.maxRows * 20) / 2;
        int i = 0;
        int count = 0;
        while (count < this.maxValues) {
            for (int k = 0; k < 10 && count < this.maxValues; ++k) {
                int n = count++;
                TextureResult result = this.textureGetter.apply(this.startValue + n);
                this.m_142416_((GuiEventListener)new BlockButton(this.guiLeft + 8 + 1 + k * 20, this.guiTop + 21 + i * 20, b -> {
                    this.selectedVariant = this.startValue + n;
                    this.preview = result;
                    this.onListen(false);
                }, result.location(), result.textureWidth(), result.textureHeight(), ToolTipUtils.GetSoundName(this.startValue + n)));
            }
            ++i;
        }
        this.m_142416_((GuiEventListener)new Button.Builder(CommonComponents.f_130656_, btn -> this.m_7379_()).m_252794_(this.guiLeft + 218 - 8 - 70, this.guiTop + 21 + this.maxRows * 20 + 45 - 28).m_253046_(70, 20).m_253136_());
        this.m_142416_((GuiEventListener)new Button.Builder(CommonComponents.f_130655_, btn -> {
            this.onDone();
            this.m_7379_();
        }).m_252794_(this.guiLeft + 218 - 8 - 140 - 4, this.guiTop + 21 + this.maxRows * 20 + 45 - 28).m_253046_(70, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280411_(texture, this.guiLeft, this.guiTop, 218, 21, 0.0f, 0.0f, 218, 21, 256, 256);
        for (int i = 0; i < this.maxRows; ++i) {
            guiGraphics.m_280411_(texture, this.guiLeft, this.guiTop + 21 + i * 20, 218, 20, 0.0f, 21.0f, 218, 20, 256, 256);
        }
        guiGraphics.m_280411_(texture, this.guiLeft, this.guiTop + 21 + this.maxRows * 20, 218, 45, 0.0f, 41.0f, 218, 45, 256, 256);
        if (this.preview != null) {
            guiGraphics.m_280411_(this.preview.location(), this.guiLeft + 8, this.guiTop + 21 + this.maxRows * 20 + 4, 32, 32, 0.0f, 0.0f, this.preview.textureWidth(), this.preview.textureHeight(), this.preview.textureWidth(), this.preview.textureHeight());
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.guiTop + 6, -12566464, false);
    }

    public record TextureResult(ResourceLocation location, int textureWidth, int textureHeight) {
    }
}

