/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.stack;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;

public class StackUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);
    public static final UpgradeGroup UPGRADE_GROUP = new UpgradeGroup("stack_upgrades", TranslationHelper.INSTANCE.translUpgradeGroup("stack_upgrades"));
    private final double stackSizeMultiplier;

    public StackUpgradeItem(double stackSizeMultiplier, IUpgradeCountLimitConfig upgradeTypeLimitConfig) {
        super(upgradeTypeLimitConfig);
        this.stackSizeMultiplier = stackSizeMultiplier;
    }

    public static int getInventorySlotLimit(IStorageWrapper storageWrapper) {
        return StackUpgradeItem.getInventorySlotLimit(storageWrapper, 1.0);
    }

    private static int getInventorySlotLimit(IStorageWrapper storageWrapper, double skipMultiplier) {
        double multiplier = storageWrapper.getBaseStackSizeMultiplier();
        boolean multiplierSkipped = false;
        for (Wrapper stackWrapper : storageWrapper.getUpgradeHandler().getTypeWrappers(TYPE)) {
            if (!multiplierSkipped && stackWrapper.getStackSizeMultiplier() == skipMultiplier) {
                multiplierSkipped = true;
                continue;
            }
            if (2.147483647E9 / stackWrapper.getStackSizeMultiplier() < multiplier) {
                return Integer.MAX_VALUE;
            }
            multiplier *= stackWrapper.getStackSizeMultiplier();
        }
        return 3.3554431984375E7 < multiplier ? Integer.MAX_VALUE : (int)(multiplier * 64.0);
    }

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    @Override
    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return List.of();
    }

    public double getStackSizeMultiplier() {
        return this.stackSizeMultiplier;
    }

    @Override
    public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide) {
        if (isClientSide) {
            return new UpgradeSlotChangeResult.Success();
        }
        double multiplierWhenRemoved = (double)StackUpgradeItem.getInventorySlotLimit(storageWrapper, this.stackSizeMultiplier) / 64.0;
        return this.isMultiplierHighEnough(storageWrapper, multiplierWhenRemoved, -1);
    }

    @Override
    public UpgradeSlotChangeResult checkExtraInsertConditions(ItemStack upgradeStack, IStorageWrapper storageWrapper, boolean isClientSide, int upgradeSlot, @Nullable IUpgradeItem<?> upgradeInSlot) {
        if (isClientSide) {
            return new UpgradeSlotChangeResult.Success();
        }
        double multiplierWhenAdded = (double)StackUpgradeItem.getInventorySlotLimit(storageWrapper) / 64.0 * this.stackSizeMultiplier;
        UpgradeSlotChangeResult result = this.isMultiplierHighEnough(storageWrapper, multiplierWhenAdded, upgradeSlot);
        if (!result.isSuccessful()) {
            return result;
        }
        return super.checkExtraInsertConditions(upgradeStack, storageWrapper, isClientSide, upgradeInSlot);
    }

    @Override
    public UpgradeSlotChangeResult canSwapUpgradeFor(ItemStack upgradeStackToPut, int upgradeSlot, IStorageWrapper storageWrapper, boolean isClientSide) {
        if (isClientSide) {
            return new UpgradeSlotChangeResult.Success();
        }
        UpgradeSlotChangeResult result = super.canSwapUpgradeFor(upgradeStackToPut, upgradeSlot, storageWrapper, isClientSide);
        if (!result.isSuccessful()) {
            return result;
        }
        if (isClientSide) {
            return new UpgradeSlotChangeResult.Success();
        }
        Item item = upgradeStackToPut.m_41720_();
        if (!(item instanceof StackUpgradeItem)) {
            return this.canRemoveUpgradeFrom(storageWrapper, isClientSide);
        }
        StackUpgradeItem otherStackUpgradeItem = (StackUpgradeItem)item;
        if (otherStackUpgradeItem.stackSizeMultiplier >= this.stackSizeMultiplier) {
            return new UpgradeSlotChangeResult.Success();
        }
        double multiplierWhenRemoved = (double)StackUpgradeItem.getInventorySlotLimit(storageWrapper, this.stackSizeMultiplier) / 64.0;
        return this.isMultiplierHighEnough(storageWrapper, multiplierWhenRemoved * otherStackUpgradeItem.stackSizeMultiplier, -1);
    }

    private UpgradeSlotChangeResult isMultiplierHighEnough(IStorageWrapper storageWrapper, double multiplier, int ignoreUpgradeSlot) {
        HashSet<Integer> slotsOverMultiplier = new HashSet<Integer>();
        for (int slot = 0; slot < storageWrapper.getInventoryHandler().getSlots(); ++slot) {
            double stackMultiplierNeeded;
            ItemStack stack = storageWrapper.getInventoryHandler().getSlotStack(slot);
            if (stack.m_41613_() <= 1 || !((stackMultiplierNeeded = (double)stack.m_41613_() / (double)stack.m_41741_()) > multiplier)) continue;
            slotsOverMultiplier.add(slot);
        }
        HashSet<Integer> errorUpgradeSlots = new HashSet<Integer>();
        HashSet<Integer> errorInventoryParts = new HashSet<Integer>();
        for (Map.Entry<Integer, IUpgradeWrapper> entry : storageWrapper.getUpgradeHandler().getSlotWrappers().entrySet()) {
            IStackableContentsUpgrade stackableContentsUpgrade;
            Integer slot = entry.getKey();
            IUpgradeWrapper wrapper = entry.getValue();
            if (slot == ignoreUpgradeSlot || !(wrapper instanceof IStackableContentsUpgrade) || !((double)(stackableContentsUpgrade = (IStackableContentsUpgrade)((Object)wrapper)).getMinimumMultiplierRequired() > multiplier)) continue;
            errorUpgradeSlots.add(slot);
            errorInventoryParts.add(slot);
        }
        if (!slotsOverMultiplier.isEmpty() || !errorInventoryParts.isEmpty()) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("remove.stack_low_multiplier", multiplier), errorUpgradeSlots, slotsOverMultiplier, errorInventoryParts);
        }
        return new UpgradeSlotChangeResult.Success();
    }

    @Override
    public UpgradeGroup getUpgradeGroup() {
        return UPGRADE_GROUP;
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, StackUpgradeItem> {
        protected Wrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
        }

        public double getStackSizeMultiplier() {
            return ((StackUpgradeItem)this.upgradeItem).getStackSizeMultiplier();
        }

        @Override
        public boolean hideSettingsTab() {
            return true;
        }

        @Override
        public boolean canBeDisabled() {
            return false;
        }
    }
}

