/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.feeding;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.HungerLevel;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FeedingUpgradeWrapper
extends UpgradeWrapperBase<FeedingUpgradeWrapper, FeedingUpgradeItem>
implements ITickableUpgrade,
IFilteredUpgrade {
    private static final int COOLDOWN = 100;
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    private static final int FEEDING_RANGE = 3;
    private final FilterLogic filterLogic;

    public FeedingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((FeedingUpgradeItem)this.upgradeItem).getFilterSlotCount(), ItemStack::m_41614_);
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level) || entity != null && !(entity instanceof Player)) {
            return;
        }
        boolean hungryPlayer = false;
        if (entity == null) {
            AtomicBoolean stillHungryPlayer = new AtomicBoolean(false);
            level.m_142425_((EntityTypeTest)EntityType.f_20532_, new AABB(pos).m_82400_(3.0), p -> true).forEach(p -> stillHungryPlayer.set(stillHungryPlayer.get() || this.feedPlayerAndGetHungry((Player)p, level)));
            hungryPlayer = stillHungryPlayer.get();
        } else if (this.feedPlayerAndGetHungry((Player)entity, level)) {
            hungryPlayer = true;
        }
        if (hungryPlayer) {
            this.setCooldown(level, 10);
            return;
        }
        this.setCooldown(level, 100);
    }

    private boolean feedPlayerAndGetHungry(Player player, Level level) {
        int hungerLevel = 20 - player.m_36324_().m_38702_();
        if (hungerLevel == 0) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.m_36324_().m_38702_() < 20;
    }

    private boolean tryFeedingFoodFromStorage(Level level, int hungerLevel, Player player) {
        ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        return InventoryHelper.iterate((IItemHandler)inventory, (slot, stack) -> this.tryFeedingStack(level, hungerLevel, player, (Integer)slot, (ItemStack)stack, inventory), () -> false, ret -> ret);
    }

    private boolean tryFeedingStack(Level level, int hungerLevel, Player player, Integer slot, ItemStack stack, ITrackedContentsItemHandler inventory) {
        boolean isHurt;
        boolean bl = isHurt = player.m_21223_() < player.m_21233_() - 0.1f;
        if (FeedingUpgradeWrapper.isEdible(stack, (LivingEntity)player) && this.filterLogic.matchesFilter(stack) && (this.isHungryEnoughForFood(hungerLevel, stack, player) || this.shouldFeedImmediatelyWhenHurt() && hungerLevel > 0 && isHurt)) {
            ItemStack mainHandItem = player.m_21205_();
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)stack);
            ItemStack singleItemCopy = stack.m_41777_();
            singleItemCopy.m_41764_(1);
            if (singleItemCopy.m_41682_(level, player, InteractionHand.MAIN_HAND).m_19089_() == InteractionResult.CONSUME) {
                ItemStack insertResult;
                stack.m_41774_(1);
                inventory.setStackInSlot(slot, stack);
                ItemStack resultItem = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)singleItemCopy.m_41777_(), (int)0, (ItemStack)singleItemCopy.m_41720_().m_5922_(singleItemCopy, level, (LivingEntity)player));
                if (!resultItem.m_41619_() && !(insertResult = inventory.insertItem(resultItem, false)).m_41619_()) {
                    player.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(playerInventory -> InventoryHelper.insertOrDropItem(player, insertResult, playerInventory));
                }
                player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)mainHandItem);
                return true;
            }
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)mainHandItem);
        }
        return false;
    }

    private static boolean isEdible(ItemStack stack, LivingEntity player) {
        if (!stack.m_41614_()) {
            return false;
        }
        FoodProperties foodProperties = stack.m_41720_().getFoodProperties(stack, player);
        return foodProperties != null && foodProperties.m_38744_() >= 1;
    }

    private boolean isHungryEnoughForFood(int hungerLevel, ItemStack stack, Player player) {
        FoodProperties foodProperties = stack.m_41720_().getFoodProperties(stack, (LivingEntity)player);
        if (foodProperties == null) {
            return false;
        }
        HungerLevel feedAtHungerLevel = this.getFeedAtHungerLevel();
        if (feedAtHungerLevel == HungerLevel.ANY) {
            return true;
        }
        int nutrition = foodProperties.m_38744_();
        return (feedAtHungerLevel == HungerLevel.HALF ? nutrition / 2 : nutrition) <= hungerLevel;
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public HungerLevel getFeedAtHungerLevel() {
        return NBTHelper.getEnumConstant(this.upgrade, "feedAtHungerLevel", HungerLevel::fromName).orElse(HungerLevel.HALF);
    }

    public void setFeedAtHungerLevel(HungerLevel hungerLevel) {
        NBTHelper.setEnumConstant(this.upgrade, "feedAtHungerLevel", hungerLevel);
        this.save();
    }

    public boolean shouldFeedImmediatelyWhenHurt() {
        return NBTHelper.getBoolean(this.upgrade, "feedImmediatelyWhenHurt").orElse(true);
    }

    public void setFeedImmediatelyWhenHurt(boolean feedImmediatelyWhenHurt) {
        NBTHelper.setBoolean(this.upgrade, "feedImmediatelyWhenHurt", feedImmediatelyWhenHurt);
        this.save();
    }
}

