/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;

public class TextDataRenderer {
    @Deprecated
    public static String drawText(GuiGraphics graphics, int x, int y, int boxWidth, int boxHeight, TextData[] data, int mouseX, int mouseY, Font fr, BookScreen parent) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        String action = TextDataRenderer.drawText(graphics, x, y, boxWidth, boxHeight, data, mouseX, mouseY, fr, tooltip);
        if (tooltip.size() > 0) {
            graphics.m_280677_(fr, tooltip, Optional.empty(), mouseX, mouseY);
        }
        return action;
    }

    public static String drawText(GuiGraphics graphics, int x, int y, int boxWidth, int boxHeight, TextData[] data, int mouseX, int mouseY, Font fr, List<Component> tooltip) {
        String action = "";
        int atX = x;
        int atY = y;
        float prevScale = 1.0f;
        for (TextData item : data) {
            boolean mouseInside;
            int box1W = 9999;
            Objects.requireNonNull(fr);
            int box1H = y + 9;
            int box2Y = 9999;
            int box3X = 9999;
            int box3Y = 9999;
            if (item == null || item.text == null || item.text.isEmpty()) continue;
            if (item.text.equals("\n")) {
                atX = x;
                Objects.requireNonNull(fr);
                atY += 9;
                continue;
            }
            if (item.paragraph) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + (float)(9 * 2) * prevScale);
            }
            prevScale = item.scale;
            Object modifiers = "";
            if (item.useOldColor) {
                ChatFormatting colFormat = ChatFormatting.m_126657_((String)item.color);
                if (colFormat != null) {
                    modifiers = (String)modifiers + colFormat;
                } else {
                    modifiers = (String)modifiers + "unknown color";
                    Mantle.logger.error("Failed to parse color: " + item.color + " for text rendering.");
                }
            }
            if (item.bold) {
                modifiers = (String)modifiers + ChatFormatting.BOLD;
            }
            if (item.italic) {
                modifiers = (String)modifiers + ChatFormatting.ITALIC;
            }
            if (item.underlined) {
                modifiers = (String)modifiers + ChatFormatting.UNDERLINE;
            }
            if (item.strikethrough) {
                modifiers = (String)modifiers + ChatFormatting.STRIKETHROUGH;
            }
            if (item.obfuscated) {
                modifiers = (String)modifiers + ChatFormatting.OBFUSCATED;
            }
            String text = TextDataRenderer.translateString(item.text);
            String[] split = TextDataRenderer.cropStringBySize(text, (String)modifiers, boxWidth, boxHeight - (atY - y), boxWidth - (atX - x), fr, item.scale);
            int box1X = atX;
            int box1Y = atY;
            int box2X = x;
            int box2W = x + boxWidth;
            for (int i = 0; i < split.length; ++i) {
                if (i == split.length - 1) {
                    box3X = atX;
                    box3Y = atY;
                }
                String s = split[i];
                TextDataRenderer.drawScaledString(graphics, fr, (String)modifiers + s, atX, atY, item.rgbColor, item.dropshadow, item.scale);
                if (i < split.length - 1) {
                    Objects.requireNonNull(fr);
                    atY += 9;
                    atX = x;
                }
                if (i != 0) continue;
                box2Y = atY;
                box1W = atX == x ? x + boxWidth : atX;
            }
            int box2H = atY;
            if ((atX = (int)((float)atX + (float)fr.m_92895_(split[split.length - 1]) * item.scale)) - x >= boxWidth) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + 9.0f * item.scale);
            }
            int box3W = atX;
            float f = atY;
            Objects.requireNonNull(fr);
            int box3H = (int)(f + 9.0f * item.scale);
            boolean bl = mouseInside = mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H;
            if (item.tooltip != null && item.tooltip.length > 0) {
                if (BookScreen.debug) {
                    graphics.m_280024_(box1X, box1Y, box1W, box1H, -16711936, -16711936);
                    graphics.m_280024_(box2X, box2Y, box2W, box2H, -65536, -65536);
                    graphics.m_280024_(box3X, box3Y, box3W, box3H, -16776961, -16776961);
                    graphics.m_280024_(mouseX, mouseY, mouseX + 5, mouseY + 5, -65281, -256);
                }
                if (mouseInside) {
                    tooltip.addAll(Arrays.asList(item.tooltip));
                }
            }
            if (item.action != null && !item.action.isEmpty() && mouseInside) {
                action = item.action;
            }
            if (atY >= y + boxHeight) {
                graphics.m_280056_(fr, "...", atX, atY, 0, item.dropshadow);
                break;
            }
            y = atY;
        }
        if (BookScreen.debug && !action.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237113_((String)("Action: " + action)).m_130940_(ChatFormatting.GRAY));
        }
        return action;
    }

    public static String translateString(String s) {
        s = s.replace("$$(", "$\u0000(").replace(")$$", ")\u0000$");
        while (s.contains("$(") && s.contains(")$") && s.indexOf("$(") < s.indexOf(")$")) {
            String loc = s.substring(s.indexOf("$(") + 2, s.indexOf(")$"));
            s = s.replace("$(" + loc + ")$", I18n.m_118938_((String)loc, (Object[])new Object[0]));
        }
        if (s.indexOf("$(") > s.indexOf(")$") || s.contains(")$")) {
            Mantle.logger.error("[Books] [TextDataRenderer] Detected unbalanced localization symbols \"$(\" and \")$\" in string: \"" + s + "\".");
        }
        return s.replace("$\u0000(", "$(").replace(")\u0000$", ")$");
    }

    public static String[] cropStringBySize(String s, String modifiers, int width, int height, Font fr, float scale) {
        return TextDataRenderer.cropStringBySize(s, modifiers, width, height, width, fr, scale);
    }

    public static String[] cropStringBySize(String s, String modifiers, int width, int height, int firstWidth, Font fr, float scale) {
        int curWidth = 0;
        Objects.requireNonNull(fr);
        int curHeight = (int)(9.0f * scale);
        for (int i = 0; i < ((String)s).length(); ++i) {
            curWidth = (int)((float)curWidth + (float)fr.m_92895_(modifiers + ((String)s).charAt(i)) * scale);
            if (((String)s).charAt(i) != '\n') {
                Objects.requireNonNull(fr);
                if (!(curHeight == (int)(9.0f * scale) ? curWidth > firstWidth : curWidth > width)) continue;
            }
            int oldI = i;
            if (((String)s).charAt(i) != '\n') {
                while (i >= 0 && ((String)s).charAt(i) != ' ') {
                    --i;
                }
                if (i <= 0) {
                    i = oldI;
                }
            } else {
                ++oldI;
            }
            s = ((String)s).substring(0, i) + "\r" + StringUtils.stripStart((String)((String)s).substring(i + (i == oldI ? 0 : 1)), (String)" ");
            ++i;
            curWidth = 0;
            float f = curHeight;
            Objects.requireNonNull(fr);
            curHeight = (int)(f + 9.0f * scale);
            if (curHeight < height) continue;
            return ((String)s).substring(0, i).split("\r");
        }
        return ((String)s).split("\r");
    }

    public static int getLinesForString(String s, String modifiers, int width, String prefix, Font fr) {
        return TextDataRenderer.cropStringBySize(s, modifiers, width, Short.MAX_VALUE, width - fr.m_92895_(prefix), fr, 1.0f).length;
    }

    public static void drawScaledString(GuiGraphics graphics, Font font, String text, float x, float y, int color, boolean dropShadow, float scale) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        graphics.m_280056_(font, text, 0, 0, color, dropShadow);
        poseStack.m_85849_();
    }
}

