/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.client;

import com.corosus.watut.particle.ParticleRotating;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDescription;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class CustomParticleEngine
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter PARTICLE_LISTER = FileToIdConverter.m_246568_((String)"particles");
    private static final ResourceLocation PARTICLES_ATLAS_INFO = new ResourceLocation("particles");
    private static final int MAX_PARTICLES_PER_LAYER = 16384;
    private static final List<ParticleRenderType> RENDER_ORDER = ImmutableList.of((Object)ParticleRenderType.f_107429_, (Object)ParticleRenderType.f_107430_, (Object)ParticleRenderType.f_107432_, (Object)ParticleRenderType.f_107431_, (Object)ParticleRenderType.f_107433_);
    protected ClientLevel level;
    private final Map<ParticleRenderType, Queue<Particle>> particles = Maps.newTreeMap(CustomParticleEngine.makeParticleRenderTypeComparator(RENDER_ORDER));
    private final Queue<TrackingEmitter> trackingEmitters = Queues.newArrayDeque();
    private final TextureManager textureManager;
    private final RandomSource random = RandomSource.m_216327_();
    private final Map<ResourceLocation, ParticleProvider<?>> providers = new HashMap();
    private final Queue<Particle> particlesToAdd = Queues.newArrayDeque();
    private final Map<ResourceLocation, MutableSpriteSet> spriteSets = Maps.newHashMap();
    public final TextureAtlas textureAtlas;
    private final Object2IntOpenHashMap<ParticleGroup> trackedParticleCounts = new Object2IntOpenHashMap();

    public CustomParticleEngine(ClientLevel p_107299_, TextureManager p_107300_) {
        this.textureAtlas = new TextureAtlas(TextureAtlas.f_118260_);
        this.level = p_107299_;
        this.textureManager = p_107300_;
    }

    public static Comparator<ParticleRenderType> makeParticleRenderTypeComparator(List<ParticleRenderType> renderOrder) {
        Comparator<ParticleRenderType> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((ParticleRenderType)typeOne, (ParticleRenderType)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier p_107305_, ResourceManager p_107306_, ProfilerFiller p_107307_, ProfilerFiller p_107308_, Executor p_107309_, Executor p_107310_) {
        CompletionStage completablefuture = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.m_247457_(p_107306_), p_107309_).thenCompose(p_247914_ -> {
            ArrayList list = new ArrayList(p_247914_.size());
            p_247914_.forEach((p_247903_, p_247904_) -> {
                ResourceLocation resourcelocation = PARTICLE_LISTER.m_245273_(p_247903_);
                list.add(CompletableFuture.supplyAsync(() -> {
                    record ParticleDefinition(ResourceLocation id, Optional<List<ResourceLocation>> sprites) {
                    }
                    return new ParticleDefinition(resourcelocation, this.loadParticleDescription(resourcelocation, (Resource)p_247904_));
                }, p_107309_));
            });
            return Util.m_137567_(list);
        });
        CompletionStage completablefuture1 = SpriteLoader.m_245483_((TextureAtlas)this.textureAtlas).m_260881_(p_107306_, PARTICLES_ATLAS_INFO, 0, p_107309_).thenCompose(SpriteLoader.Preparations::m_246429_);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{completablefuture1, completablefuture}).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)p_107305_).m_6769_(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$6(p_107308_, (CompletableFuture)completablefuture1, (CompletableFuture)completablefuture, arg_0), p_107310_);
    }

    public void close() {
        this.textureAtlas.m_118329_();
    }

    private Optional<List<ResourceLocation>> loadParticleDescription(ResourceLocation p_250648_, Resource p_248793_) {
        Optional<List<ResourceLocation>> optional;
        block9: {
            if (!this.spriteSets.containsKey(p_250648_)) {
                LOGGER.debug("Redundant texture list for particle: {}", (Object)p_250648_);
                return Optional.empty();
            }
            BufferedReader reader = p_248793_.m_215508_();
            try {
                ParticleDescription particledescription = ParticleDescription.m_107285_((JsonObject)GsonHelper.m_13859_((Reader)reader));
                optional = Optional.of(particledescription.m_107282_());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load description for particle " + p_250648_, ioexception);
                }
            }
            ((Reader)reader).close();
        }
        return optional;
    }

    public void add(Particle p_107345_) {
        Optional optional = p_107345_.m_142654_();
        if (optional.isPresent()) {
            if (this.hasSpaceInParticleLimit((ParticleGroup)optional.get())) {
                this.particlesToAdd.add(p_107345_);
                this.updateCount((ParticleGroup)optional.get(), 1);
            }
        } else {
            this.particlesToAdd.add(p_107345_);
        }
    }

    public void tick() {
        this.particles.forEach((p_288249_, p_288250_) -> {
            this.level.m_46473_().m_6180_(p_288249_.toString());
            this.tickParticleList((Collection<Particle>)p_288250_);
            this.level.m_46473_().m_7238_();
        });
        if (!this.trackingEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (TrackingEmitter trackingemitter : this.trackingEmitters) {
                trackingemitter.m_5989_();
                if (trackingemitter.m_107276_()) continue;
                list.add(trackingemitter);
            }
            this.trackingEmitters.removeAll(list);
        }
        if (!this.particlesToAdd.isEmpty()) {
            Particle particle;
            while ((particle = this.particlesToAdd.poll()) != null) {
                this.particles.computeIfAbsent(particle.m_7556_(), p_107347_ -> EvictingQueue.create((int)16384)).add(particle);
            }
        }
    }

    private void tickParticleList(Collection<Particle> p_107385_) {
        if (!p_107385_.isEmpty()) {
            Iterator<Particle> iterator = p_107385_.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                this.tickParticle(particle);
                if (particle.m_107276_()) continue;
                particle.m_142654_().ifPresent(p_172289_ -> this.updateCount((ParticleGroup)p_172289_, -1));
                iterator.remove();
            }
        }
    }

    private void updateCount(ParticleGroup p_172282_, int p_172283_) {
        this.trackedParticleCounts.addTo((Object)p_172282_, p_172283_);
    }

    private void tickParticle(Particle p_107394_) {
        try {
            p_107394_.m_5989_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Particle being ticked");
            crashreportcategory.m_128165_("Particle", () -> ((Particle)p_107394_).toString());
            crashreportcategory.m_128165_("Particle Type", p_107394_.m_7556_()::toString);
            throw new ReportedException(crashreport);
        }
    }

    @Deprecated
    public void render(PoseStack p_107337_, MultiBufferSource.BufferSource p_107338_, LightTexture p_107339_, Camera p_107340_, float p_107341_) {
        this.render(p_107337_, p_107338_, p_107339_, p_107340_, p_107341_, null);
    }

    public void render(PoseStack p_107337_, MultiBufferSource.BufferSource p_107338_, LightTexture p_107339_, Camera p_107340_, float p_107341_, Frustum clippingHelper) {
        p_107339_.m_109896_();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252931_(p_107337_.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        this.render(p_107337_, p_107338_, p_107339_, p_107340_, p_107341_, clippingHelper, false);
        this.render(p_107337_, p_107338_, p_107339_, p_107340_, p_107341_, clippingHelper, true);
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        p_107339_.m_109891_();
    }

    public void render(PoseStack p_107337_, MultiBufferSource.BufferSource p_107338_, LightTexture p_107339_, Camera p_107340_, float p_107341_, Frustum clippingHelper, boolean pickupParticleMode) {
        for (ParticleRenderType particlerendertype : this.particles.keySet()) {
            Iterable iterable;
            if (!pickupParticleMode ? particlerendertype == ParticleRotating.TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL : particlerendertype != ParticleRotating.TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL) continue;
            if (particlerendertype == ParticleRenderType.f_107434_ || (iterable = (Iterable)this.particles.get(particlerendertype)) == null) continue;
            RenderSystem.setShader(GameRenderer::m_172829_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            particlerendertype.m_6505_(bufferbuilder, this.textureManager);
            for (Particle particle : iterable) {
                try {
                    particle.m_5744_((VertexConsumer)bufferbuilder, p_107340_, p_107341_);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.m_127514_("Particle being rendered");
                    crashreportcategory.m_128165_("Particle", () -> ((Particle)particle).toString());
                    crashreportcategory.m_128165_("Particle Type", particlerendertype::toString);
                    throw new ReportedException(crashreport);
                }
            }
            particlerendertype.m_6294_(tesselator);
        }
    }

    public void setLevel(ClientLevel p_107343_) {
        this.level = p_107343_;
        this.clearParticles();
        this.trackingEmitters.clear();
    }

    public String countParticles() {
        return String.valueOf(this.particles.values().stream().mapToInt(Collection::size).sum());
    }

    private boolean hasSpaceInParticleLimit(ParticleGroup p_172280_) {
        return this.trackedParticleCounts.getInt((Object)p_172280_) < p_172280_.m_175819_();
    }

    private void clearParticles() {
        this.particles.clear();
        this.particlesToAdd.clear();
        this.trackingEmitters.clear();
        this.trackedParticleCounts.clear();
    }

    private /* synthetic */ void lambda$reload$6(ProfilerFiller p_107308_, CompletableFuture completablefuture1, CompletableFuture completablefuture, Void p_247900_) {
        this.clearParticles();
        p_107308_.m_7242_();
        p_107308_.m_6180_("upload");
        SpriteLoader.Preparations spriteloader$preparations = (SpriteLoader.Preparations)completablefuture1.join();
        this.textureAtlas.m_247065_(spriteloader$preparations);
        p_107308_.m_6182_("bindSpriteSets");
        HashSet set = new HashSet();
        TextureAtlasSprite textureatlassprite = spriteloader$preparations.f_243912_();
        ((List)completablefuture.join()).forEach(p_247911_ -> {
            Optional<List<ResourceLocation>> optional = p_247911_.sprites();
            if (!optional.isEmpty()) {
                ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
                for (ResourceLocation resourcelocation : optional.get()) {
                    TextureAtlasSprite textureatlassprite1 = (TextureAtlasSprite)spriteloader$preparations.f_243807_().get(resourcelocation);
                    if (textureatlassprite1 == null) {
                        set.add(resourcelocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(textureatlassprite1);
                }
                if (list.isEmpty()) {
                    list.add(textureatlassprite);
                }
                this.spriteSets.get(p_247911_.id()).rebind(list);
            }
        });
        if (!set.isEmpty()) {
            LOGGER.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(ResourceLocation::toString).collect(Collectors.joining(",")));
        }
        p_107308_.m_7238_();
        p_107308_.m_7241_();
    }

    static class MutableSpriteSet
    implements SpriteSet {
        private List<TextureAtlasSprite> sprites;

        MutableSpriteSet() {
        }

        public TextureAtlasSprite m_5819_(int p_107413_, int p_107414_) {
            return this.sprites.get(p_107413_ * (this.sprites.size() - 1) / p_107414_);
        }

        public TextureAtlasSprite m_213979_(RandomSource p_233889_) {
            return this.sprites.get(p_233889_.m_188503_(this.sprites.size()));
        }

        public void rebind(List<TextureAtlasSprite> p_107416_) {
            this.sprites = ImmutableList.copyOf(p_107416_);
        }
    }

    @FunctionalInterface
    public static interface SpriteParticleRegistration<T extends ParticleOptions> {
        public ParticleProvider<T> create(SpriteSet var1);
    }
}

