/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.ribs.vintagedelight.block.entity.ModBlockEntities;
import net.ribs.vintagedelight.item.ModTags;
import net.ribs.vintagedelight.recipe.FermentingRecipe;
import net.ribs.vintagedelight.screen.FermentingJarMenu;
import org.jetbrains.annotations.Nullable;

public class FermentingJarBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            FermentingJarBlockEntity.this.m_6596_();
            if (!FermentingJarBlockEntity.this.f_58857_.m_5776_()) {
                FermentingJarBlockEntity.this.f_58857_.m_7260_(FermentingJarBlockEntity.this.m_58899_(), FermentingJarBlockEntity.this.m_58900_(), FermentingJarBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    public static final int FIRST_INGREDIENT_SLOT = 0;
    public static final int LAST_INPUT_SLOT = 5;
    public static final int CONTAINER_SLOT = 6;
    public static final int FIRST_OUTPUT_SLOT = 7;
    public static final int SECOND_OUTPUT_SLOT = 8;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 78;
    private final SimpleContainer inputInventory = new SimpleContainer(7);

    public FermentingJarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FERMENTING_JAR_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> FermentingJarBlockEntity.this.progress;
                    case 1 -> FermentingJarBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        FermentingJarBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        FermentingJarBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public List<ItemStack> getRenderStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i <= 5; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        if (7 < this.itemHandler.getSlots() && !this.itemHandler.getStackInSlot(7).m_41619_()) {
            stacks.add(this.itemHandler.getStackInSlot(7));
        }
        return stacks;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> new OutputItemHandler(this.itemHandler)).cast();
            }
            return LazyOptional.of(() -> new ConditionalItemHandler(this.itemHandler)).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.vintagedelight.fermenting_jar");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FermentingJarMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("fermenting_jar.progress", this.progress);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("fermenting_jar.progress");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.f_46443_) {
            for (int i = 0; i <= 6; ++i) {
                this.inputInventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
            }
            Optional recipeOpt = this.f_58857_.m_7465_().m_44015_((RecipeType)FermentingRecipe.Type.INSTANCE, (Container)this.inputInventory, this.f_58857_);
            if (recipeOpt.isPresent()) {
                FermentingRecipe recipe = (FermentingRecipe)recipeOpt.get();
                ItemStack result = recipe.m_8043_(this.f_58857_.m_9598_());
                ItemStack secondaryResult = recipe.getSecondaryResultItem();
                this.maxProgress = recipe.getProcessingTime();
                if (this.canOutput(result, secondaryResult)) {
                    this.increaseCraftingProgress();
                    if (this.hasProgressFinished()) {
                        this.craftItem(recipe);
                        this.resetProgress();
                    }
                } else {
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
            }
        }
    }

    private boolean canOutput(ItemStack result, ItemStack secondaryResult) {
        boolean canOutputPrimary = result.m_41619_() || this.canInsertItemIntoOutputSlot(result.m_41720_(), 7) && this.canInsertAmountIntoOutputSlot(result.m_41613_(), 7);
        boolean canOutputSecondary = secondaryResult.m_41619_() || this.canInsertItemIntoOutputSlot(secondaryResult.m_41720_(), 8) && this.canInsertAmountIntoOutputSlot(secondaryResult.m_41613_(), 8);
        return canOutputPrimary && canOutputSecondary;
    }

    private void craftItem(FermentingRecipe recipe) {
        ItemStack secondaryResult;
        ItemStack result = recipe.m_8043_(this.f_58857_.m_9598_());
        if (this.canOutput(result, secondaryResult = recipe.getSecondaryResultItem())) {
            if (!result.m_41619_()) {
                this.itemHandler.insertItem(7, result.m_41777_(), false);
            }
            if (!secondaryResult.m_41619_()) {
                this.itemHandler.insertItem(8, secondaryResult.m_41777_(), false);
            }
            for (Ingredient ingredient : recipe.m_7527_()) {
                this.consumeIngredient(ingredient);
            }
            this.itemHandler.extractItem(6, 1, false);
        }
    }

    private void consumeIngredient(Ingredient ingredient) {
        for (int i = 0; i <= 5; ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (!ingredient.test(stackInSlot)) continue;
            this.itemHandler.extractItem(i, 1, false);
            break;
        }
    }

    private boolean canInsertItemIntoOutputSlot(Item item, int slot) {
        int maxStackSize;
        ItemStack existingStack = this.itemHandler.getStackInSlot(slot);
        if (existingStack.m_41619_()) {
            return true;
        }
        if (!existingStack.m_150930_(item)) {
            return false;
        }
        int itemCount = existingStack.m_41613_();
        return itemCount < (maxStackSize = existingStack.m_41741_());
    }

    private boolean canInsertAmountIntoOutputSlot(int count, int slot) {
        int maxStackSize;
        ItemStack existingStack = this.itemHandler.getStackInSlot(slot);
        if (existingStack.m_41619_()) {
            return true;
        }
        int existingCount = existingStack.m_41613_();
        return existingCount + count <= (maxStackSize = existingStack.m_41741_());
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    private class ConditionalItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler wrappedHandler;

        public ConditionalItemHandler(ItemStackHandler wrappedHandler) {
            this.wrappedHandler = wrappedHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.wrappedHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.wrappedHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.wrappedHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 7 || slot == 8) {
                return stack;
            }
            if (slot == 6 && !stack.m_204117_(ModTags.CONTAINER_ITEMS)) {
                return stack;
            }
            return this.wrappedHandler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrappedHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrappedHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 7 || slot == 8) {
                return false;
            }
            if (slot == 6) {
                return stack.m_204117_(ModTags.CONTAINER_ITEMS);
            }
            return this.wrappedHandler.isItemValid(slot, stack);
        }
    }

    private class OutputItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public OutputItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandler.extractItem(slot + 7, amount, simulate);
        }

        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot + 7);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot + 7);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }
}

