/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.behaviour.slidingDoor;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.decoration.slidingDoor.DoorControl;
import com.simibubi.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.lang.ref.WeakReference;
import net.adeptstack.blocks.doors.slidingDoor.TrainSlidingDoorBlock;
import net.adeptstack.blocks.doors.slidingDoor.TrainSlidingDoorBlockEntity;
import net.adeptstack.registry.TrainUtilitiesBuilderTransformers;
import net.adeptstack.utils.TrainSlidingDoorProperties;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class TrainSlidingDoorMovementBehaviour
implements MovementBehaviour {
    TrainSlidingDoorProperties tsdp;
    String type;

    public TrainSlidingDoorMovementBehaviour(String type) {
        this.type = type;
    }

    public void tick(MovementContext context) {
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null) {
            return;
        }
        boolean open = TrainSlidingDoorBlockEntity.isOpen(structureBlockInfo.f_74676_());
        if (!context.world.m_5776_()) {
            this.tickOpen(context, open);
            if (!context.world.m_5776_()) {
                if (open && !this.shouldOpen(context)) {
                    int ticksOpen = context.data.m_128451_("OpenTicks");
                    context.data.m_128405_("OpenTicks", ++ticksOpen);
                    if (ticksOpen > 180) {
                        this.tickClose(context, true);
                        context.data.m_128405_("OpenTicks", 0);
                    }
                } else {
                    context.data.m_128405_("OpenTicks", 0);
                }
            }
        }
        int sound = TrainSlidingDoorBlockEntity.getDoorSoundValue(structureBlockInfo.f_74676_());
        this.tsdp = TrainUtilitiesBuilderTransformers.GetSlidingDoorProperties(sound);
        BlockEntity blockEntity = context.contraption.getBlockEntityClientSide(context.localPos);
        if (!(blockEntity instanceof TrainSlidingDoorBlockEntity)) {
            return;
        }
        TrainSlidingDoorBlockEntity sdbe = (TrainSlidingDoorBlockEntity)blockEntity;
        boolean wasSettled = sdbe.animation.settled();
        sdbe.animation.chase(open ? 1.0 : 0.0, (double)this.tsdp.GetSpeed(), LerpedFloat.Chaser.LINEAR);
        sdbe.animation.tickChaser();
        if (TrainSlidingDoorBlock.isDoubleDoor((DoorHingeSide)structureBlockInfo.f_74676_().m_61143_((Property)TrainSlidingDoorBlock.f_52728_), context.localPos, (Direction)context.state.m_61143_((Property)TrainSlidingDoorBlock.f_52726_), context)) {
            if (structureBlockInfo.f_74676_().m_61143_((Property)TrainSlidingDoorBlock.f_52728_) == DoorHingeSide.RIGHT) {
                if (wasSettled && !sdbe.animation.settled() && !open && sound != 1) {
                    context.world.m_7785_(context.position.f_82479_, context.position.f_82480_, context.position.f_82481_, this.tsdp.GetClose(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                if (wasSettled && !sdbe.animation.settled() && open && sound != 1) {
                    context.world.m_7785_(context.position.f_82479_, context.position.f_82480_, context.position.f_82481_, this.tsdp.GetOpen(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        } else {
            if (wasSettled && !sdbe.animation.settled() && !open && sound != 1) {
                context.world.m_7785_(context.position.f_82479_, context.position.f_82480_, context.position.f_82481_, this.tsdp.GetClose(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (wasSettled && !sdbe.animation.settled() && open && sound != 1) {
                context.world.m_7785_(context.position.f_82479_, context.position.f_82480_, context.position.f_82481_, this.tsdp.GetOpen(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    protected void tickOpen(MovementContext context, boolean currentlyOpen) {
        boolean shouldOpen = this.shouldOpen(context);
        if (!this.shouldUpdate(context, shouldOpen)) {
            return;
        }
        if (currentlyOpen == shouldOpen) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        if (info == null || !info.f_74676_().m_61138_((Property)DoorBlock.f_52727_)) {
            return;
        }
        this.toggleDoor(pos, contraption, info);
    }

    protected void tickClose(MovementContext context, boolean currentlyClose) {
        boolean shouldClose;
        boolean bl = shouldClose = !this.shouldOpen(context);
        if (!this.shouldUpdate(context, shouldClose)) {
            return;
        }
        if (currentlyClose == shouldClose) {
            return;
        }
        BlockPos pos = context.localPos;
        Contraption contraption = context.contraption;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        if (info == null || !info.f_74676_().m_61138_((Property)DoorBlock.f_52727_)) {
            return;
        }
        this.closeDoor(pos, contraption, info);
    }

    private void closeDoor(BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState = (BlockState)info.f_74676_().m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false));
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
        BlockPos otherPos = newState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(otherPos);
        if (info != null && info.f_74676_().m_61138_((Property)DoorBlock.f_52727_)) {
            newState = (BlockState)info.f_74676_().m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false));
            contraption.entity.setBlock(otherPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
            contraption.invalidateColliders();
        }
        contraption.invalidateColliders();
    }

    private void toggleDoor(BlockPos pos, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        BlockState newState = (BlockState)info.f_74676_().m_61122_((Property)DoorBlock.f_52727_);
        contraption.entity.setBlock(pos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
        BlockPos otherPos = newState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(otherPos);
        if (info != null && info.f_74676_().m_61138_((Property)DoorBlock.f_52727_)) {
            newState = (BlockState)info.f_74676_().m_61122_((Property)DoorBlock.f_52727_);
            contraption.entity.setBlock(otherPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
            contraption.invalidateColliders();
        }
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldOpen) {
        if (context.firstMovement && shouldOpen) {
            return false;
        }
        if (!context.data.m_128441_("Open")) {
            context.data.m_128379_("Open", shouldOpen);
            return true;
        }
        boolean wasOpen = context.data.m_128471_("Open");
        context.data.m_128379_("Open", shouldOpen);
        return wasOpen != shouldOpen;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean shouldOpen(MovementContext context) {
        if (context.disabled) {
            return false;
        }
        contraption = context.contraption;
        if (context.motion.m_82553_() < 0.0078125 && !contraption.entity.isStalled()) ** GOTO lbl-1000
        if (contraption instanceof ElevatorContraption) {
            ec = (ElevatorContraption)contraption;
            ** if (!ec.arrived) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl12
        }
lbl-1000:
        // 2 sources

        {
            v0 = canOpen = false;
        }
lbl12:
        // 2 sources

        if (!canOpen) {
            context.temporaryData = null;
            return false;
        }
        var6_5 = context.temporaryData;
        if (var6_5 instanceof WeakReference && (var6_5 = (wr = (WeakReference)var6_5).get()) instanceof DoorControlBehaviour) {
            dcb = (DoorControlBehaviour)var6_5;
            if (dcb.blockEntity != null && !dcb.blockEntity.m_58901_()) {
                return this.shouldOpenAt(dcb, context);
            }
        }
        context.temporaryData = null;
        doorControls = null;
        if (contraption instanceof ElevatorContraption) {
            ec = (ElevatorContraption)contraption;
            doorControls = this.getElevatorDoorControl(ec, context);
        }
        if ((var6_5 = context.contraption.entity) instanceof CarriageContraptionEntity) {
            cce = (CarriageContraptionEntity)var6_5;
            doorControls = this.getTrainStationDoorControl(cce, context);
        }
        if (doorControls == null) {
            return false;
        }
        context.temporaryData = new WeakReference<DoorControlBehaviour>(doorControls);
        return this.shouldOpenAt(doorControls, context);
    }

    protected boolean shouldOpenAt(DoorControlBehaviour controller, MovementContext context) {
        if (controller.mode == DoorControl.ALL) {
            return true;
        }
        if (controller.mode == DoorControl.NONE) {
            return false;
        }
        return controller.mode.matches(this.getDoorFacing(context));
    }

    protected DoorControlBehaviour getElevatorDoorControl(ElevatorContraption ec, MovementContext context) {
        Integer currentTargetY = ec.getCurrentTargetY(context.world);
        if (currentTargetY == null) {
            return null;
        }
        ElevatorColumn.ColumnCoords columnCoords = ec.getGlobalColumn();
        if (columnCoords == null) {
            return null;
        }
        ElevatorColumn elevatorColumn = ElevatorColumn.get((LevelAccessor)context.world, (ElevatorColumn.ColumnCoords)columnCoords);
        if (elevatorColumn == null) {
            return null;
        }
        return (DoorControlBehaviour)BlockEntityBehaviour.get((BlockGetter)context.world, (BlockPos)elevatorColumn.contactAt(currentTargetY.intValue()), (BehaviourType)DoorControlBehaviour.TYPE);
    }

    protected DoorControlBehaviour getTrainStationDoorControl(CarriageContraptionEntity cce, MovementContext context) {
        Carriage carriage = cce.getCarriage();
        if (carriage == null || carriage.train == null) {
            return null;
        }
        GlobalStation currentStation = carriage.train.getCurrentStation();
        if (currentStation == null) {
            return null;
        }
        BlockPos stationPos = currentStation.getBlockEntityPos();
        ResourceKey stationDim = currentStation.getBlockEntityDimension();
        MinecraftServer server = context.world.m_7654_();
        if (server == null) {
            return null;
        }
        ServerLevel stationLevel = server.m_129880_(stationDim);
        if (stationLevel == null || !stationLevel.m_46749_(stationPos)) {
            return null;
        }
        return (DoorControlBehaviour)BlockEntityBehaviour.get((BlockGetter)stationLevel, (BlockPos)stationPos, (BehaviourType)DoorControlBehaviour.TYPE);
    }

    protected Direction getDoorFacing(MovementContext context) {
        Direction stateFacing = (Direction)context.state.m_61143_((Property)DoorBlock.f_52726_);
        Direction originalFacing = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)stateFacing.m_122434_());
        Vec3 centerOfContraption = context.contraption.bounds.m_82399_();
        Vec3 diff = Vec3.m_82512_((Vec3i)context.localPos).m_82549_(Vec3.m_82528_((Vec3i)stateFacing.m_122436_()).m_82490_((double)-0.45f)).m_82546_(centerOfContraption);
        if (originalFacing.m_122434_().m_6150_(diff.f_82479_, diff.f_82480_, diff.f_82481_) < 0.0) {
            originalFacing = originalFacing.m_122424_();
        }
        Vec3 directionVec = Vec3.m_82528_((Vec3i)originalFacing.m_122436_());
        directionVec = (Vec3)context.rotation.apply(directionVec);
        return Direction.m_122366_((double)directionVec.f_82479_, (double)directionVec.f_82480_, (double)directionVec.f_82481_);
    }

    public boolean mustTickWhileDisabled() {
        return true;
    }
}

