/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.datagen.provider.recipe.create;

import com.mrh0.createaddition.index.CAItems;
import com.simibubi.create.api.data.recipe.FillingRecipeGen;
import ho.artisan.tgears.index.TGBlocks;
import ho.artisan.tgears.index.TGItems;
import ho.artisan.tgears.index.TGTagKeys;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.block.FoliageType;

public final class TGFillingProvider
extends FillingRecipeGen {
    public TGFillingProvider(PackOutput output) {
        super(output, "tgears");
        this.createRecipes();
    }

    private void createRecipes() {
        this.create("blazing_chocolate_glazed_berries", b -> b.require(TGTagKeys.Fluids.BLAZING_CHOCOLATE, 250).require((ItemLike)Items.f_42780_).output(TGItems.BLAZING_CHOCOLATE_BERRIES));
        this.create("silktouch_drill", b -> b.require(TinkerFluids.moltenRoseGold.getTag(), 360).require(TGBlocks.TINKER_DRILL).output(TGBlocks.TINKER_SILKTOUCH_DRILL));
        this.cakeRecipe("earth", (Fluid)TinkerFluids.slime.get((Enum)SlimeType.EARTH), new ItemStack((ItemLike)TinkerGadgets.cake.get((Enum)FoliageType.EARTH)));
        this.cakeRecipe("sky", (Fluid)TinkerFluids.slime.get((Enum)SlimeType.SKY), new ItemStack((ItemLike)TinkerGadgets.cake.get((Enum)FoliageType.SKY)));
        this.cakeRecipe("ender", (Fluid)TinkerFluids.slime.get((Enum)SlimeType.ENDER), new ItemStack((ItemLike)TinkerGadgets.cake.get((Enum)FoliageType.ENDER)));
        this.cakeRecipe("ichor", TinkerFluids.ichor.get(), new ItemStack((ItemLike)TinkerGadgets.cake.get((Enum)FoliageType.ICHOR)));
        this.handRecipe("brass", "molten_brass", 360, new ItemStack(TGItems.HAND_CAST_WITH_BRASS_HAND));
        this.handRecipe("blazing_chocolate", "blazing_chocolate", 500, new ItemStack(TGItems.HAND_CAST_WITH_BLAZING_CHOCOLATE_HAND));
        this.handRecipe("chocolate", "chocolate", 500, new ItemStack(TGItems.HAND_CAST_WITH_CHOCOLATE_HAND));
        this.propellerRecipe("iron", "molten_iron", 360, new ItemStack(TGItems.PROPELLER_CAST_WITH_PROPELLER));
        this.propellerRecipe("cobalt", "molten_cobalt", 360, new ItemStack(TGItems.PROPELLER_CAST_WITH_COBALT_PROPELLER));
        this.whiskRecipe("iron", "molten_iron", 450, new ItemStack(TGItems.WHISK_CAST_WITH_WHISK));
    }

    private void cakeRecipe(String id, Fluid fluid, ItemStack output) {
        this.create("cake/" + id, b -> b.require(fluid, 1000).require((ItemLike)CAItems.CAKE_BASE).output(output).withCondition((ICondition)new ModLoadedCondition("createaddition")));
    }

    private void handRecipe(String id, String fluid, int amount, ItemStack output) {
        this.create("hand/" + id, b -> b.require(FluidTags.create((ResourceLocation)new ResourceLocation("forge", fluid)), amount).require(TGItems.HAND_CAST_WITH_PART).output(output));
    }

    private void propellerRecipe(String id, String fluid, int amount, ItemStack output) {
        this.create("propeller/" + id, b -> b.require(FluidTags.create((ResourceLocation)new ResourceLocation("forge", fluid)), amount).require(TGItems.PROPELLER_CAST_WITH_PART).output(output));
    }

    private void whiskRecipe(String id, String fluid, int amount, ItemStack output) {
        this.create("whisk/" + id, b -> b.require(FluidTags.create((ResourceLocation)new ResourceLocation("forge", fluid)), amount).require(TGItems.WHISK_CAST_WITH_PART).output(output));
    }
}

