/*
 * Decompiled with CFR 0.152.
 */
package ho.artisan.tgears.common.block.module;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.tools.item.IModifiable;

public class TinkerItemModule
extends ItemStackHandler
implements ITinkerableContainer {
    private final int separation;
    private final Supplier<Boolean> lockedSupplier;
    private final List<Consumer<TinkerItemModule>> listeners;

    public TinkerItemModule(int inputSlots, int outputSlots, Supplier<Boolean> lockedSupplier) {
        super(inputSlots + outputSlots);
        this.separation = inputSlots;
        this.lockedSupplier = lockedSupplier;
        this.listeners = new ArrayList<Consumer<TinkerItemModule>>();
    }

    public void addListener(Consumer<TinkerItemModule> listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (Consumer<TinkerItemModule> listener : this.listeners) {
            listener.accept(this);
        }
    }

    public int getInputSlots() {
        return this.separation;
    }

    public int getOutputSlots() {
        return this.getSlots() - this.separation;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.notifyListeners();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (slot >= this.separation) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.lockedSupplier.get().booleanValue()) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public boolean isTinkerable() {
        return this.getTinkerableStack().m_41720_() instanceof IModifiable;
    }

    public ItemStack getTinkerableStack() {
        return this.getStackInSlot(0);
    }

    public ItemStack getInput(int index) {
        return this.getStackInSlot(index);
    }

    public ItemStack getOutput(int index) {
        return this.getStackInSlot(index + this.separation);
    }

    public void setOutput(int index, ItemStack stack) {
        this.setStackInSlot(index + this.separation, stack);
    }

    public int getInputCount() {
        return this.separation;
    }
}

