/*
 * Decompiled with CFR 0.152.
 */
package dev.wolfieboy09.tfmgjs.electrodes;

import com.drmangotea.tfmg.content.machinery.vat.electrode_holder.electrode.Electrode;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.wolfieboy09.tfmgjs.KubeJSRegistrate;
import dev.wolfieboy09.tfmgjs.TFMGJSRegistryInfo;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class ElectrodeBuilderJS
extends BuilderBase<Electrode> {
    private Consumer<Item.Properties> electrodeItemProperties = p -> new Item.Properties();
    private Electrode.Properties electrodeProperties;
    private boolean built = false;

    public ElectrodeBuilderJS(ResourceLocation id) {
        super(id);
    }

    @Info(value="Set's the electrode's resistance", params={@Param(value="The electrode's resistance")})
    public ElectrodeBuilderJS resistance(int resistance) {
        this.ensureNotBuilt();
        this.getElectrodeProperties().resistance(resistance);
        return this;
    }

    @Info(value="Set's the operation ID for the chemical vat machines. Defaults to the namespace given", params={@Param(value="The new operation id")})
    public ElectrodeBuilderJS operationId(@NotNull ResourceLocation operationId) {
        this.ensureNotBuilt();
        this.getElectrodeProperties().operationId(operationId.toString());
        return this;
    }

    public ElectrodeBuilderJS properties(Consumer<Item.Properties> itemProperties) {
        this.ensureNotBuilt();
        this.electrodeItemProperties = itemProperties;
        return this;
    }

    public RegistryInfo<Electrode> getRegistryType() {
        return TFMGJSRegistryInfo.ELECTRODE;
    }

    public Electrode createObject() {
        if (!this.built) {
            this.buildEntries();
        }
        return new Electrode(this.electrodeProperties);
    }

    public void createAdditionalObjects() {
        if (!this.built) {
            this.buildEntries();
        }
    }

    @HideFromJS
    private void buildEntries() {
        if (this.built) {
            return;
        }
        ItemEntry itemEntry = KubeJSRegistrate.REGISTRATE.item(this.id.m_135815_(), Item::new).register();
        this.electrodeProperties = new Electrode.Properties(this.id).operationId(this.id.toString()).item(itemEntry);
        this.built = true;
    }

    @HideFromJS
    private Electrode.Properties getElectrodeProperties() {
        if (this.electrodeProperties == null) {
            this.electrodeProperties = new Electrode.Properties(this.id).operationId(this.id.toString());
        }
        return this.electrodeProperties;
    }

    @HideFromJS
    private void ensureNotBuilt() {
        if (this.built) {
            throw new IllegalStateException("Cannot modify electrode builder after it has been built");
        }
    }
}

