/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.electrode_holder;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGRegistries;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.machinery.vat.base.IVatMachine;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlock;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlockEntity;
import com.drmangotea.tfmg.content.machinery.vat.electrode_holder.electrode.Electrode;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ElectrodeHolderBlockEntity
extends ElectricBlockEntity
implements IVatMachine {
    Electrode electrode = TFMGUtils.getElectrode(TFMG.asResource("none"));
    boolean isTallEnough = true;

    public ElectrodeHolderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == Direction.UP;
    }

    public boolean setElectrode(ItemStack modeItem, boolean simulate) {
        if (this.f_58857_ == null) {
            return false;
        }
        for (Electrode electrode : this.f_58857_.m_9598_().m_175515_(TFMGRegistries.ELECTRODE)) {
            if (electrode.getStack().m_41619_() || !modeItem.m_150930_(electrode.getStack().m_41720_())) continue;
            if (!simulate) {
                this.electrode = electrode;
                continue;
            }
            return true;
        }
        if (!simulate && this.m_58898_()) {
            VatBlock.updateVatState(this.m_58900_(), this.m_58904_(), this.m_58899_().m_121945_(Direction.DOWN));
        }
        this.sendData();
        return false;
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        if (this.getCurrent() < (float)((Integer)TFMGConfigs.common().machines.electrolysisMinimumCurrent.get()).intValue()) {
            CreateLang.translate((String)"goggles.electrode_holder.min_amps", (Object[])new Object[0]).style(ChatFormatting.RED).add(CreateLang.text((String)(TFMGConfigs.common().machines.electrolysisMinimumCurrent.get() + "A)"))).forGoggles(tooltip);
        }
        return true;
    }

    @Override
    public float resistance() {
        return this.electrode.getResistance();
    }

    @Override
    public boolean canBeInGroups() {
        return true;
    }

    public boolean setElectrode(Electrode electrode, boolean simulate) {
        if (electrode != null) {
            if (!simulate) {
                this.electrode = electrode;
            } else {
                return true;
            }
        }
        if (!simulate && this.m_58898_()) {
            VatBlock.updateVatState(this.m_58900_(), this.m_58904_(), this.m_58899_().m_121945_(Direction.DOWN));
        }
        this.sendData();
        return false;
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        VatBlock.updateVatState(this.m_58900_(), this.f_58857_, this.m_58899_().m_121945_(Direction.DOWN));
    }

    boolean isOperational() {
        return this.getCurrent() >= (float)((Integer)TFMGConfigs.common().machines.electrolysisMinimumCurrent.get()).intValue() && this.canWork();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_165887_((double)(this.m_58899_().m_123342_() - 2));
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128359_("Electrode", this.electrode.getKey().toString());
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.setElectrode(TFMGUtils.getElectrode(new ResourceLocation(compound.m_128461_("Electrode"))), false);
    }

    public void destroy() {
        ItemStack electrodeItem = this.electrode.getStack();
        Containers.m_18992_((Level)this.m_58904_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)electrodeItem);
    }

    @Override
    public String getOperationId() {
        return this.electrode.getOperationId();
    }

    @Override
    public boolean canOperate(VatBlockEntity vat) {
        return this.isOperational();
    }

    @Override
    public int getWorkPercentage() {
        return this.getPowerUsage() / 5000 * 100;
    }

    @Override
    public void vatUpdated(VatBlockEntity be) {
        IVatMachine.super.vatUpdated(be);
    }
}

