/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.coke_oven;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.metallurgy.coke_oven.CokeOvenBlock;
import com.drmangotea.tfmg.content.machinery.metallurgy.coke_oven.CokeOvenPacket;
import com.drmangotea.tfmg.recipes.CokingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CokeOvenBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SmartInventory inventory;
    public FluidTank primaryTank;
    public FluidTank secondaryTank;
    protected LazyOptional<IFluidHandler> primaryFluidCapability;
    protected LazyOptional<IFluidHandler> secondaryFluidCapability;
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    int timer = -1;
    public LerpedFloat doorAngle = LerpedFloat.angular();
    public boolean createNextTick;
    public BlockPos controller = this.m_58899_();
    public int size = 1;
    public boolean forceOpen = false;

    public CokeOvenBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.inventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(64).whenContentsChanged(i -> this.onContentsChanged());
        this.primaryTank = new SmartFluidTank(8000, this::onFluidChanged);
        this.secondaryTank = new SmartFluidTank(8000, this::onFluidChanged);
        this.itemCapability = LazyOptional.of(() -> this.inventory);
        this.primaryFluidCapability = LazyOptional.of(() -> this.primaryTank);
        this.secondaryFluidCapability = LazyOptional.of(() -> this.secondaryTank);
        this.createNextTick = true;
    }

    public void onContentsChanged() {
        if (!this.inventory.m_7983_() && this.timer == -1) {
            this.executeRecipe();
        }
        if (this.inventory.m_7983_()) {
            this.timer = -1;
        }
    }

    public void executeRecipe() {
        Optional optional = TFMGRecipeTypes.COKING.find(new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.f_58857_);
        if (optional.isEmpty()) {
            return;
        }
        CokingRecipe recipe = (CokingRecipe)((Object)optional.get());
        if (((Ingredient)recipe.m_7527_().get(0)).test(this.inventory.m_8020_(0))) {
            this.timer = recipe.getProcessingDuration() / Math.max(this.size / 2, 1);
        }
    }

    private void onFluidChanged(FluidStack stack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public void tick() {
        super.tick();
        this.tickRecipe();
        if (this.f_58857_.f_46443_) {
            this.doorAngle.chase(this.timer > 0 && this.timer < 50 || this.forceOpen ? 90.0 : 0.0, (double)0.1f, LerpedFloat.Chaser.EXP);
            this.doorAngle.tickChaser();
            if (!this.forceOpen) {
                this.manageDoors(this.timer > 0 && this.timer < 50);
            }
        }
        if (this.createNextTick) {
            this.createMultiblock();
            this.createNextTick = false;
        }
    }

    public void tickRecipe() {
        if (this.inventory.m_7983_() || this.timer == -1) {
            return;
        }
        Optional optional = TFMGRecipeTypes.COKING.find(new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.f_58857_);
        if (optional.isEmpty()) {
            this.timer = -1;
            return;
        }
        CokingRecipe recipe = (CokingRecipe)((Object)optional.get());
        if (this.timer == 0) {
            this.timer = -1;
            this.inventory.m_8020_(0).m_41774_(((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41613_());
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Vec3 dropVec = VecHelper.getCenterOf((Vec3i)this.f_58858_.m_121945_(direction)).m_82520_(0.0, 0.4, 0.0);
            ItemEntity dropped = new ItemEntity(this.f_58857_, dropVec.f_82479_, dropVec.f_82480_, dropVec.f_82481_, recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
            dropped.m_32060_();
            dropped.m_20334_(direction.m_122434_() == Direction.Axis.X ? (direction == Direction.WEST ? (double)-0.01f : (double)0.01f) : 0.0, (double)0.05f, direction.m_122434_() == Direction.Axis.Z ? (direction == Direction.NORTH ? (double)-0.01f : (double)0.01f) : 0.0);
            this.f_58857_.m_7967_((Entity)dropped);
            if (!this.f_58857_.f_46443_) {
                this.m_6596_();
                this.sendData();
            }
            this.onContentsChanged();
        }
        if (this.timer > 0 && this.primaryTank.getSpace() != 0 && this.secondaryTank.getSpace() != 0) {
            this.primaryTank.fill(recipe.getPrimaryResult(), IFluidHandler.FluidAction.EXECUTE);
            this.secondaryTank.fill(recipe.getSecondaryResult(), IFluidHandler.FluidAction.EXECUTE);
            --this.timer;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.onContentsChanged();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"goggles.coke_oven.header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof CokeOvenBlockEntity) {
            CokeOvenBlockEntity controller = (CokeOvenBlockEntity)blockEntity;
            if (controller.timer > 0) {
                CreateLang.translate((String)"goggles.coke_oven.progress", (Object[])new Object[]{controller.timer / 20}).style(ChatFormatting.GOLD).forGoggles(tooltip);
            }
        }
        CokeOvenBlockEntity.createFluidTooltip(this, tooltip);
        TFMGUtils.createItemTooltip((BlockEntity)this, tooltip);
        return true;
    }

    public static boolean createFluidTooltip(CokeOvenBlockEntity be, List<Component> tooltip) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        BlockEntity blockEntity = be.f_58857_.m_7702_(be.controller);
        if (blockEntity instanceof CokeOvenBlockEntity) {
            CokeOvenBlockEntity controller = (CokeOvenBlockEntity)blockEntity;
            CombinedTankWrapper tank = new CombinedTankWrapper(new IFluidHandler[]{controller.primaryTank, controller.secondaryTank});
            if (tank.getTanks() == 0) {
                return false;
            }
            CreateLang.translate((String)"goggles.fluid_storage", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            boolean isEmpty = true;
            for (int i = 0; i < tank.getTanks(); ++i) {
                FluidStack fluidStack = tank.getFluidInTank(i);
                if (fluidStack.isEmpty()) continue;
                CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
                CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
                isEmpty = false;
            }
            if (tank.getTanks() > 1) {
                if (isEmpty) {
                    tooltip.remove(tooltip.size() - 1);
                }
                return true;
            }
            if (!isEmpty) {
                return true;
            }
            CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        }
        return true;
    }

    public void manageDoors(boolean open) {
        for (int i = 0; i < this.size; ++i) {
            BlockPos pos = this.m_58899_().m_6630_(i);
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof CokeOvenBlockEntity)) continue;
            CokeOvenBlockEntity be = (CokeOvenBlockEntity)blockEntity;
            if (pos == this.m_58899_()) continue;
            be.forceOpen = open;
        }
    }

    public boolean isController() {
        return this.controller == this.m_58899_();
    }

    public void createMultiblock() {
        CokeOvenBlockEntity be;
        BlockEntity blockEntity;
        if (this.f_58857_ == null) {
            return;
        }
        int maxSize = (Integer)TFMGConfigs.common().machines.cokeOvenMaxSize.get();
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (this.f_58857_.m_8055_(this.m_58899_().m_121945_(facing)).m_60713_((Block)TFMGBlocks.COKE_OVEN.get()) || this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_60713_((Block)TFMGBlocks.COKE_OVEN.get())) {
            return;
        }
        int size = 1;
        for (int i = 1; i <= maxSize; ++i) {
            boolean cantBuildMultiblock = false;
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_58899_(), (BlockPos)this.m_58899_().m_6630_(i).m_5484_(facing.m_122424_(), i))) {
                if (!this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.COKE_OVEN.get())) {
                    cantBuildMultiblock = true;
                    continue;
                }
                if (!this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.COKE_OVEN.get()) || this.f_58857_.m_8055_(pos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == facing) continue;
                cantBuildMultiblock = true;
            }
            if (cantBuildMultiblock) break;
            ++size;
        }
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_58899_(), (BlockPos)this.m_58899_().m_6630_(size - 1).m_5484_(facing.m_122424_(), size - 1))) {
            blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof CokeOvenBlockEntity)) continue;
            be = (CokeOvenBlockEntity)blockEntity;
            if (this.f_58857_.m_8055_(this.m_58899_().m_121945_(facing)).m_60713_((Block)TFMGBlocks.COKE_OVEN.get()) || this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_60713_((Block)TFMGBlocks.COKE_OVEN.get())) continue;
            be.controller = this.m_58899_();
            be.refreshCapability();
        }
        if (!this.f_58857_.m_8055_(this.m_58899_().m_121945_(facing)).m_60713_((Block)TFMGBlocks.COKE_OVEN.get()) && !this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_60713_((Block)TFMGBlocks.COKE_OVEN.get())) {
            this.setBlockStates(size);
        }
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_58899_(), (BlockPos)this.m_58899_().m_6630_(this.size - 1).m_5484_(facing.m_122424_(), this.size - 1))) {
            blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof CokeOvenBlockEntity)) continue;
            be = (CokeOvenBlockEntity)blockEntity;
            if (Math.abs(this.m_58899_().m_123341_() - be.m_58899_().m_123341_()) < size && Math.abs(this.m_58899_().m_123342_() - be.m_58899_().m_123342_()) < size && Math.abs(this.m_58899_().m_123343_() - be.m_58899_().m_123343_()) < size || be.controller != this.m_58899_() && be.controller == be.m_58899_()) continue;
            be.controller = be.m_58899_();
            be.refreshCapability();
            be.forceOpen = false;
            be.doorAngle.setValue(0.0);
            this.f_58857_.m_7731_(be.m_58899_(), (BlockState)this.m_58900_().m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.CASUAL)), 2);
        }
        this.size = size;
    }

    public void setBlockStates(int size) {
        if (size > 1) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.BOTTOM_ON)), 2);
            this.f_58857_.m_7731_(this.m_58899_().m_6630_(size - 1), (BlockState)this.m_58900_().m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.TOP_ON)), 2);
        } else {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.CASUAL)), 2);
        }
        for (int i = 0; i < size; ++i) {
            BlockPos pos = this.m_58899_().m_6630_(i);
            if (i <= 0 || i == size - 1) continue;
            this.f_58857_.m_7731_(pos, (BlockState)this.m_58900_().m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.MIDDLE_ON)), 2);
        }
    }

    public void onPlaced() {
        this.createNextTick = true;
        this.updateOvenBlocks();
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new CokeOvenPacket(this.m_58899_()));
        }
    }

    public void remove() {
        super.remove();
        this.updateOvenBlocks();
    }

    public void destroy() {
        super.destroy();
        if (this.isController()) {
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
        }
    }

    public void updateOvenBlocks() {
        int maxSize = (Integer)TFMGConfigs.common().machines.cokeOvenMaxSize.get();
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_58899_(), (BlockPos)this.m_58899_().m_6625_(maxSize).m_5484_(facing, maxSize))) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof CokeOvenBlockEntity)) continue;
            CokeOvenBlockEntity be = (CokeOvenBlockEntity)blockEntity;
            be.createMultiblock();
        }
    }

    private void refreshCapability() {
        CokeOvenBlockEntity be;
        LazyOptional<IFluidHandler> oldPrimaryFluidCap = this.primaryFluidCapability;
        LazyOptional<IFluidHandler> oldSecondaryFluidCap = this.secondaryFluidCapability;
        LazyOptional<IItemHandlerModifiable> oldItemCap = this.itemCapability;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof CokeOvenBlockEntity) {
            CokeOvenBlockEntity be1;
            be = be1 = (CokeOvenBlockEntity)blockEntity;
        } else {
            this.controller = this.m_58899_();
            be = (CokeOvenBlockEntity)this.f_58857_.m_7702_(this.m_58899_());
        }
        this.primaryFluidCapability = LazyOptional.of(() -> be.primaryTank);
        this.secondaryFluidCapability = LazyOptional.of(() -> be.secondaryTank);
        this.itemCapability = LazyOptional.of(() -> be.inventory);
        oldPrimaryFluidCap.invalidate();
        oldSecondaryFluidCap.invalidate();
        oldItemCap.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return side == Direction.UP ? this.secondaryFluidCapability.cast() : this.primaryFluidCapability.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("PrimaryTankContent", (Tag)this.primaryTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("SecondaryTankContent", (Tag)this.secondaryTank.writeToNBT(new CompoundTag()));
        compound.m_128356_("Controller", this.controller.m_121878_());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.timer = compound.m_128451_("Timer");
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.primaryTank.readFromNBT(compound.m_128469_("PrimaryTankContent"));
        this.secondaryTank.readFromNBT(compound.m_128469_("SecondaryTankContent"));
        this.controller = BlockPos.m_122022_((long)compound.m_128454_("Controller"));
    }
}

