/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.measurement;

import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.measurement.MultimeterItem;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.mixin.accessor.MouseHandlerAccessor;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.Map;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class MultimeterOverlayRenderer {
    public static final IGuiOverlay OVERLAY = MultimeterOverlayRenderer::renderOverlay;
    private static final Map<Object, Outliner.OutlineEntry> outlines = Outliner.getInstance().getOutlines();
    public static int hoverTicks = 0;
    public static BlockPos lastHovered = null;

    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult objectMouseOver = mc.f_91077_;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            lastHovered = null;
            hoverTicks = 0;
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        int prevHoverTicks = hoverTicks++;
        lastHovered = pos;
        pos = MultimeterOverlayRenderer.proxiedOverlayPosition((Level)world, pos);
        BlockEntity be = world.m_7702_(pos);
        boolean holdsMultimeter = MultimeterItem.isHeldByPlayer((Player)mc.f_91074_);
        boolean isShifting = mc.f_91074_.m_6144_();
        boolean isElectricBlock = be instanceof IElectric;
        if (!isElectricBlock) {
            return;
        }
        ItemStack item = TFMGItems.MULTIMETER.asStack();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)CreateLang.number((double)1.0).component());
        ((IElectric)be).makeMultimeterTooltip(tooltip, isShifting);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.f_91062_.m_92852_(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        CClient cClient = AllConfigs.client();
        int posX = width / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = height / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = Mth.m_14036_((float)(((float)hoverTicks + partialTicks) / 24.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color(((Integer)cClient.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        Color colorBorderTop = new Color(1356585748);
        Color colorBorderBot = new Color(1354611983);
        if (fade < 1.0f) {
            poseStack.m_85837_(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cClient.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        GuiGameElement.of((ItemStack)item).at((float)(posX + 10), (float)(posY - 16), 450.0f).render(graphics);
        if (!Mods.MODERNUI.isLoaded()) {
            RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)width, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.f_91062_);
            poseStack.m_85849_();
            return;
        }
        MouseHandler mouseHandler = Minecraft.m_91087_().f_91067_;
        Window window = Minecraft.m_91087_().m_91268_();
        double guiScale = window.m_85449_();
        double cursorX = mouseHandler.m_91589_();
        double cursorY = mouseHandler.m_91594_();
        ((MouseHandlerAccessor)mouseHandler).create$setXPos((double)Math.round(cursorX / guiScale) * guiScale);
        ((MouseHandlerAccessor)mouseHandler).create$setYPos((double)Math.round(cursorY / guiScale) * guiScale);
        RemovedGuiUtils.drawHoveringText((GuiGraphics)graphics, tooltip, (int)posX, (int)posY, (int)width, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.f_91062_);
        ((MouseHandlerAccessor)mouseHandler).create$setXPos(cursorX);
        ((MouseHandlerAccessor)mouseHandler).create$setYPos(cursorY);
        poseStack.m_85849_();
    }

    public static BlockPos proxiedOverlayPosition(Level level, BlockPos pos) {
        BlockState targetedState = level.m_8055_(pos);
        Block block = targetedState.m_60734_();
        if (block instanceof IProxyHoveringInformation) {
            IProxyHoveringInformation proxy = (IProxyHoveringInformation)block;
            return proxy.getInformationSource(level, pos, targetedState);
        }
        return pos;
    }
}

