/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.silentsdelight.player;

import com.scouter.silentsdelight.effects.SDEffects;
import com.scouter.silentsdelight.message.EntityRenderOutlineMessage;
import com.scouter.silentsdelight.message.SDMessages;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.Nullable;

public class PlayerVibration
implements VibrationSystem {
    private final VibrationSystem.Data data = new VibrationSystem.Data();
    private final VibrationSystem.User user;

    public PlayerVibration(ServerPlayer serverPlayer) {
        this.user = new VibrationUser((LivingEntity)serverPlayer);
    }

    public VibrationSystem.Data m_280002_() {
        return this.data;
    }

    public VibrationSystem.User m_280445_() {
        return this.user;
    }

    public static class VibrationUser
    implements VibrationSystem.User {
        private final UUID owner;
        private final Level level;
        private final PositionSource positionSource;
        private final LivingEntity serverPlayer;

        public VibrationUser(LivingEntity entity) {
            this.owner = entity.m_20148_();
            this.level = entity.m_9236_();
            this.positionSource = new EntityPositionSource((Entity)entity, entity.m_20192_());
            this.serverPlayer = entity;
        }

        public int m_280351_() {
            return 12;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280080_(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, GameEvent.Context pContext) {
            if (!this.serverPlayer.m_21023_((MobEffect)SDEffects.WARDENS_SENSE.get())) {
                return false;
            }
            Entity entity = pContext.f_223711_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                return !serverPlayer.m_7306_((Entity)serverPlayer);
            }
            entity = pContext.f_223711_();
            if (entity instanceof TamableAnimal) {
                TamableAnimal animal = (TamableAnimal)entity;
                return !animal.m_146862_(e -> true);
            }
            return true;
        }

        public void m_280271_(ServerLevel pLevel, BlockPos pPos, GameEvent pGameEvent, @Nullable Entity pEntity, @Nullable Entity pPlayerEntity, float pDistance) {
            if (pEntity != null) {
                SDMessages.sendToClients(new EntityRenderOutlineMessage(this.serverPlayer.m_20148_(), pEntity.m_19879_()));
            }
            if (pPlayerEntity != null) {
                SDMessages.sendToClients(new EntityRenderOutlineMessage(this.serverPlayer.m_20148_(), pPlayerEntity.m_19879_()));
            }
        }
    }
}

