/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.network.packet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.QuestlogClient;
import org.infernalstudios.questlog.core.QuestManager;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.network.IPacketContext;
import org.infernalstudios.questlog.network.packet.QuestDefinitionHandledPacket;
import org.infernalstudios.questlog.platform.Services;

public class QuestDefinitionPacket {
    public static final IPacketContext.Direction DIRECTION = IPacketContext.Direction.SERVER_TO_CLIENT;
    private static final Gson GSON = new GsonBuilder().create();
    private static final List<QuestDefinitionPacket> DEFERRED = new CopyOnWriteArrayList<QuestDefinitionPacket>();
    private final ResourceLocation id;
    private final JsonObject definition;

    public QuestDefinitionPacket(ResourceLocation id, JsonObject definition) {
        this.id = id;
        this.definition = definition;
    }

    public static QuestDefinitionPacket decode(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        int length = buf.readInt();
        String json = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        JsonObject definition = (JsonObject)GSON.fromJson(json, JsonObject.class);
        return new QuestDefinitionPacket(id, definition);
    }

    public static void handle(QuestDefinitionPacket packet, IPacketContext ctx) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            QuestDefinitionPacket.defer(packet);
            return;
        }
        try {
            QuestManager manager = QuestlogClient.getLocal();
            Quest quest = Quest.create(Objects.requireNonNull(packet.definition), packet.id, manager);
            manager.addQuest(quest);
            Services.PLATFORM.sendPacketToServer(new QuestDefinitionHandledPacket(packet.id));
        }
        catch (Throwable e) {
            Questlog.LOGGER.error("Failed to handle QuestDefinitionPacket", e);
        }
    }

    private static void defer(QuestDefinitionPacket packet) {
        DEFERRED.add(packet);
    }

    public static void handleDeferred() {
        Questlog.LOGGER.debug("Handling deferred QuestDefinitionPackets");
        for (QuestDefinitionPacket packet : DEFERRED) {
            QuestDefinitionPacket.handle(packet, null);
        }
        DEFERRED.clear();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        String json = GSON.toJson((JsonElement)this.definition);
        buf.writeInt(json.getBytes(StandardCharsets.UTF_8).length);
        buf.writeCharSequence((CharSequence)json, StandardCharsets.UTF_8);
    }
}

