/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.rewards;

import com.google.gson.JsonObject;
import javax.annotation.CheckForNull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.core.quests.display.RewardDisplayData;
import org.infernalstudios.questlog.core.quests.display.WithDisplayData;
import org.infernalstudios.questlog.util.JsonUtils;
import org.infernalstudios.questlog.util.NbtSaveable;
import org.jetbrains.annotations.Nullable;

public abstract class Reward
implements NbtSaveable,
WithDisplayData<RewardDisplayData> {
    private final RewardDisplayData display;
    private final boolean isInstant;
    @CheckForNull
    private Quest parent;
    private boolean rewarded = false;

    public Reward(JsonObject definition) {
        if (definition.has("instant")) {
            if (!definition.get("instant").isJsonPrimitive()) {
                throw new IllegalStateException("Reward instant must be a boolean");
            }
            this.isInstant = JsonUtils.getBoolean(definition, "instant");
        } else {
            this.isInstant = false;
        }
        this.display = new RewardDisplayData(JsonUtils.getOrDefault(definition, "display", new JsonObject()));
        this.display.setReward(this);
    }

    @javax.annotation.Nullable
    public Quest getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable Quest parent) {
        this.parent = parent;
    }

    @Override
    @javax.annotation.Nullable
    public RewardDisplayData getDisplay() {
        return this.display;
    }

    public boolean rewardsInstantly() {
        return this.isInstant;
    }

    public void applyReward(ServerPlayer player) {
        this.rewarded = true;
        if (this.getParent() != null) {
            this.getParent().markForUpdate();
        }
    }

    public void revokeReward() {
        this.rewarded = false;
        if (this.getParent() != null) {
            this.getParent().markForUpdate();
        }
    }

    public boolean hasRewarded() {
        return this.rewarded;
    }

    @Override
    public void writeInitialData(CompoundTag data) {
        data.m_128379_("rewarded", false);
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("rewarded", this.rewarded);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag data) {
        this.rewarded = data.m_128471_("rewarded");
    }
}

