/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.rewards;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.core.quests.rewards.Reward;
import org.infernalstudios.questlog.util.JsonUtils;
import org.infernalstudios.questlog.util.Util;

public class LootTableReward
extends Reward {
    private final ResourceLocation lootTable;

    public LootTableReward(JsonObject definition) {
        super(definition);
        this.lootTable = new ResourceLocation(JsonUtils.getString(definition, "loot_table"));
    }

    @Override
    public void applyReward(ServerPlayer player) {
        LootDataManager tables = Objects.requireNonNull(player.m_20194_()).m_278653_();
        LootTable table = tables.m_278676_(this.lootTable);
        if (table == LootTable.f_79105_) {
            Questlog.LOGGER.error("Loot table not found: {}", (Object)this.lootTable);
        }
        ObjectArrayList stacks = table.m_287195_(new LootParams.Builder(player.m_284548_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287286_(LootContextParams.f_81458_, (Object)player).m_287235_(LootContextParamSets.f_81410_));
        for (ItemStack stack : stacks) {
            Util.giveToPlayer(player, stack);
        }
        super.applyReward(player);
    }
}

