/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.objectives.misc;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.event.QuestlogEventBus;
import org.infernalstudios.questlog.event.events.QLPlayerEvent;
import org.infernalstudios.questlog.util.JsonUtils;

public class VisitDimensionObjective
extends Objective {
    private final ResourceLocation dimension;
    private int ticksUntilCheck = 0;

    public VisitDimensionObjective(JsonObject definition) {
        super(definition);
        this.dimension = new ResourceLocation(JsonUtils.getString(definition, "dimension"));
    }

    @Override
    public void registerEventListeners(QuestlogEventBus bus) {
        super.registerEventListeners(bus);
        bus.addListener(this::onPlayerMove);
    }

    private void onPlayerMove(QLPlayerEvent.Tick event) {
        ServerPlayer player;
        if (this.isCompleted() || this.getParent() == null) {
            return;
        }
        Player player2 = event.player;
        if (player2 instanceof ServerPlayer && this.getParent().manager.player.equals((Object)(player = (ServerPlayer)player2)) && --this.ticksUntilCheck <= 0) {
            if (player.m_9236_().m_220362_().m_135782_().equals((Object)this.dimension)) {
                this.setUnits(this.getUnits() + 1);
            }
            this.ticksUntilCheck = 20;
        }
    }
}

